/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.dt.DT;
import com.schneiderautomation.factorycast.MonitorNumber;
import com.schneiderautomation.factorycast.MonitorRef;
import com.schneiderautomation.factorycast.ServerChangeEvent;
import com.schneiderautomation.gde.GraphicalObject;
import com.schneiderautomation.gde.MonitorSupport;
import com.schneiderautomation.widgets.DIndicatorGui;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public class DIndicator
extends DIndicatorGui
implements GraphicalObject,
PropertyChangeListener,
Serializable {
    static final long serialVersionUID = -2596300463290305795L;
    private transient Number value;
    private MonitorNumber monitor = new MonitorNumber();
    private MonitorSupport support = new MonitorSupport((MonitorRef)this.monitor, (GraphicalObject)this);
    private float minValue;
    private float maxValue;

    public DIndicator() {
        this.monitor.addPropertyChangeListener((PropertyChangeListener)this);
        this.minValue = this.getMinimum();
        this.maxValue = this.getMaximum();
    }

    public void serverChanged(ServerChangeEvent serverChangeEvent) {
        this.monitor.serverChanged(serverChangeEvent);
    }

    public void enableUserInput() {
    }

    public void disableUserInput() {
    }

    public String getStatus() {
        return this.support.getStatus();
    }

    public boolean isErrorStatus() {
        return this.support.isErrorStatus();
    }

    public double getPlcValue() {
        return this.value != null ? this.value.doubleValue() : 0.0;
    }

    public void setPlcValue(double d) {
        short s = this.getDatatype();
        d = Math.min(Math.max(d, DT.minValue((short)s)), DT.maxValue((short)s));
        this.value = new Double(d);
        this.refreshValue();
    }

    public void setMinimum(float f) {
        super.setMinimum(f);
        this.refreshValue();
    }

    public void setMaximum(float f) {
        super.setMaximum(f);
        this.refreshValue();
    }

    public void setMinValue(float f) {
        short s = this.getDatatype();
        if ((f = (float)Math.min(Math.max((double)f, DT.minValue((short)s)), DT.maxValue((short)s))) > this.maxValue) {
            f = this.maxValue;
        }
        this.minValue = f;
        this.refreshValue();
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(float f) {
        short s = this.getDatatype();
        if ((f = (float)Math.min(Math.max((double)f, DT.minValue((short)s)), DT.maxValue((short)s))) < this.minValue) {
            f = this.minValue;
        }
        this.maxValue = f;
        this.refreshValue();
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public String getAddress() {
        return this.monitor.getAddress();
    }

    public void setAddress(String string) {
        this.monitor.setAddress(string);
    }

    public short getDatatype() {
        return this.monitor.getDatatype();
    }

    public void setDatatype(short s) {
        this.monitor.setDatatype(s);
        if (this.value != null) {
            this.setPlcValue(this.value.doubleValue());
        }
        this.setMinValue(this.minValue);
        this.setMaxValue(this.maxValue);
        this.setValueType(s);
        this.repaint();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("value")) {
            this.setValueType(this.monitor.getValueType());
            this.value = this.monitor.getValue();
            this.refreshValue();
        }
    }

    private void refreshValue() {
        if (this.value != null) {
            float f = this.getMinimum();
            float f2 = this.getMaximum();
            if (f == this.minValue && f2 == this.maxValue) {
                this.setValue(this.value);
            } else {
                float f3 = (f2 - f) / (this.maxValue - this.minValue);
                float f4 = (this.value.floatValue() - this.minValue) * f3 + f;
                this.setValue(new Float(f4));
            }
        }
    }
}

