/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.gde.GdeTopPanel;
import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.widgets.Border;
import com.schneiderautomation.widgets.ExtMotorLight;
import com.schneiderautomation.widgets.GenericImageLoader;
import com.schneiderautomation.widgets.HLabel;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;

public class ExtMotorGui
extends Canvas
implements Serializable {
    static final long serialVersionUID = -3394230083427734786L;
    private boolean on;
    private Border border = new Border();
    private ExtMotorLight display = new ExtMotorLight(this);
    private HLabel label = new HLabel();
    protected boolean bstatusError = false;

    public ExtMotorGui() {
        this.InitWrapper();
    }

    public void paint(Graphics graphics) {
        GenericImageLoader genericImageLoader = new GenericImageLoader();
        if (this.bstatusError && GdeTopPanel.bWidgeterror) {
            graphics.drawImage(genericImageLoader.iDownloadImage("Default.png"), this.display.box.x, this.display.box.y, this.display.box.width, this.display.box.height, this);
        } else if (this.getValue() == 0L) {
            graphics.drawImage(genericImageLoader.iDownloadImage(this.getOffBitmap()), this.display.box.x, this.display.box.y, this.display.box.width, this.display.box.height, this);
        } else if (this.getValue() == 1L) {
            graphics.drawImage(genericImageLoader.iDownloadImage(this.getOnBitmap()), this.display.box.x, this.display.box.y, this.display.box.width, this.display.box.height, this);
        } else {
            graphics.drawImage(genericImageLoader.iDownloadImage(this.getDefautBitmap()), this.display.box.x, this.display.box.y, this.display.box.width, this.display.box.height, this);
        }
        this.display.paint(graphics);
        this.label.paint(graphics);
        this.border.paint(graphics);
        if (Wrapper.BORDER_WIDTH != 0) {
            this.InitWrapper();
        }
    }

    private void InitWrapper() {
        Wrapper.BORDER_WIDTH = 0;
        Wrapper.BORDER_WIDTH_X2 = 0;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        if (n3 < dimension2.width) {
            n3 = dimension2.width;
        }
        if (n4 < dimension2.height) {
            n4 = dimension2.height;
        }
        super.setBounds(n, n2, n3, n4);
        if (dimension.width != n3 || dimension.height != n4) {
            this.doLayout();
        }
    }

    public void setValue(long l) {
        this.display.setValue(l);
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.display.paint(graphics);
            graphics.dispose();
        }
    }

    public long getValue() {
        return this.display.getValue();
    }

    public void setLabel(String string) {
        this.label.setText(string);
        this.doLayout();
        this.repaint();
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setLabelColor(Color color) {
        this.label.setForeground(color);
        this.repaint();
    }

    public Color getLabelColor() {
        return this.label.getForeground();
    }

    public void setLabelFont(Font font) {
        this.label.setFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getLabelFont() {
        return this.label.getFont();
    }

    public void setOffWordForeground(Color color) {
        this.display.setOffForeground(color);
        this.repaint();
    }

    public Color getOffWordForeground() {
        return this.display.getOffForeground();
    }

    public void setOnWordForeground(Color color) {
        this.display.setOnForeground(color);
        this.repaint();
    }

    public Color getOnWordForeground() {
        return this.display.getOnForeground();
    }

    public void setDefaultWordForeground(Color color) {
        this.display.setDefaultForeground(color);
        this.repaint();
    }

    public Color getDefaultWordForeground() {
        return this.display.getDefaultForeground();
    }

    public void setOffWord(String string) {
        this.display.setOffWord(string);
        this.doLayout();
        this.repaint();
    }

    public String getOffWord() {
        return this.display.getOffWord();
    }

    public void setOffWordFont(Font font) {
        this.display.setOffFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getOffWordFont() {
        return this.display.getOffFont();
    }

    public void setOnWord(String string) {
        this.display.setOnWord(string);
        this.doLayout();
        this.repaint();
    }

    public String getOnWord() {
        return this.display.getOnWord();
    }

    public void setOnWordFont(Font font) {
        this.display.setOnFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getOnWordFont() {
        return this.display.getOnFont();
    }

    public void setDefaultWord(String string) {
        this.display.setDefaultWord(string);
        this.doLayout();
        this.repaint();
    }

    public String getDefaultWord() {
        return this.display.getDefaultWord();
    }

    public void setDefaultWordFont(Font font) {
        this.display.setDefaultFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getDefaultWordFont() {
        return this.display.getDefaultFont();
    }

    public void setOffBitmap(String string) {
        this.display.setOffBitmap(string);
        this.doLayout();
        this.repaint();
    }

    public String getOffBitmap() {
        return this.display.getOffBitmap();
    }

    public void setOnBitmap(String string) {
        this.display.setOnBitmap(string);
        this.doLayout();
        this.repaint();
    }

    public String getOnBitmap() {
        return this.display.getOnBitmap();
    }

    public String getDefautBitmap() {
        return this.display.getDefautBitmap();
    }

    public void setDefautBitmap(String string) {
        this.display.setDefautBitmap(string);
        this.doLayout();
        this.repaint();
    }

    public void setBorderColor(Color color) {
        this.border.setColor(color);
        this.repaint();
    }

    public Color getBorderColor() {
        return this.border.getColor();
    }

    public void setBorderWidth(int n) {
        this.border.setWidth(n);
        this.doLayout();
        this.repaint();
    }

    public int getBorderWidth() {
        return this.border.getWidth();
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        this.border.setBounds(new Rectangle(0, 0, dimension.width, dimension.height));
        int n = this.border.getMinimumSize().height;
        dimension.width -= n;
        dimension.height -= n;
        int n2 = this.label.getMinimumSize().height;
        int n3 = dimension.height - n2;
        int n4 = n / 2;
        this.display.setBounds(new Rectangle(n4, n4, dimension.width, n3));
        this.label.setBounds(new Rectangle(n4, n4 + n3, dimension.width, n2));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        dimension.width += 50;
        dimension.height += 30;
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.display.getMinimumSize();
        Dimension dimension2 = this.label.getMinimumSize();
        Dimension dimension3 = this.border.getMinimumSize();
        int n = dimension.width;
        if (dimension2.width > n) {
            n = dimension2.width;
        }
        int n2 = dimension2.height + dimension.height + dimension3.height;
        return new Dimension(n += dimension3.width, n2);
    }
}

