/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.widgets.HScale;
import com.schneiderautomation.widgets.Scale;
import com.schneiderautomation.widgets.Scroller;
import com.schneiderautomation.widgets.SliderGui;
import com.schneiderautomation.widgets.SliderInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;

public class HSliderGui
extends SliderGui
implements Serializable {
    static final long serialVersionUID = -3274132615559708736L;
    private Scale scale = new HScale(true);
    private Scroller bar = new Scroller(0);

    public HSliderGui() {
        this.InitWrapper();
        this.setBackground(Color.lightGray);
        this.add(this.bar);
        this.scale.setMinimum(this.bar.getEUMinimum());
        this.scale.setMaximum(this.bar.getEUMaximum());
    }

    protected Scale getScale() {
        return this.scale;
    }

    private void InitWrapper() {
        Wrapper.BORDER_WIDTH = 4;
        Wrapper.BORDER_WIDTH_X2 = Wrapper.BORDER_WIDTH * 2;
    }

    protected SliderInterface getSlider() {
        return this.bar;
    }

    public void paint(Graphics graphics) {
        this.scale.paint(graphics);
        super.paint(graphics);
        if (Wrapper.BORDER_WIDTH != 4) {
            this.InitWrapper();
        }
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        this.border.setBounds(new Rectangle(0, 0, dimension.width, dimension.height));
        int n = this.border.getMinimumSize().height;
        dimension.width -= n;
        dimension.height -= n;
        int n2 = this.scale.getMinimumSize().height;
        int n3 = this.label.getMinimumSize().height;
        int n4 = dimension.height - (n2 + n3);
        int n5 = n / 2;
        int n6 = dimension.width - 32 - this.bar.getThumbLength();
        int n7 = n5 + 16 + this.bar.getThumbLength() / 2;
        int n8 = n5;
        this.scale.setBounds(new Rectangle(n7, n8, n6, n2));
        this.bar.setBounds(new Rectangle(n5, n8 += n2, dimension.width, n4));
        this.label.setBounds(new Rectangle(n5, n8 += n4, dimension.width, n3));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        dimension.width += 80;
        dimension.height += 6;
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.scale.getMinimumSize();
        Dimension dimension2 = this.bar.getMinimumSize();
        Dimension dimension3 = this.label.getMinimumSize();
        Dimension dimension4 = this.border.getMinimumSize();
        int n = dimension.width;
        if (dimension2.width > n) {
            n = dimension2.width;
        }
        if (dimension3.width > n) {
            n = dimension3.width;
        }
        int n2 = dimension.height + dimension3.height + dimension2.height + dimension4.height;
        return new Dimension(n += dimension4.width, n2);
    }
}

