/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.widgets.LiveCircle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

class Knob
extends LiveCircle
implements MouseListener,
MouseMotionListener,
Serializable {
    static final long serialVersionUID = 7790096524716366430L;
    static final int N_NUBS = 12;
    static final int NUB_SIZE = 8;
    private transient boolean fDragging;
    private transient double lastAngle;
    private double dialRadius;
    private boolean fEnabled = true;
    private Component parent;
    private Vector listeners = new Vector();

    Knob(Component component) {
        this.parent = component;
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.listeners.addElement(adjustmentListener);
    }

    void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.listeners.removeElement(adjustmentListener);
    }

    void setEnabled(boolean bl) {
        this.fEnabled = bl;
    }

    boolean isEnabled() {
        return this.fEnabled;
    }

    void setBounds(Rectangle rectangle, double d, double d2, double d3) {
        super.setBounds(rectangle, d, d2, d3);
        this.dialRadius = d3 * 8.0 / 9.0 - 2.0;
    }

    void paint(Graphics graphics) {
        Shape shape = graphics.getClip();
        graphics.setClip(this.clip);
        this.drawKnob(graphics);
        graphics.setClip(shape);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.fEnabled) {
            double d;
            double d2 = (double)mouseEvent.getX() - this.cx;
            double d3 = this.cy - (double)mouseEvent.getY();
            double d4 = Math.atan2(d3, d2);
            double d5 = d = d2 != 0.0 ? d2 / Math.cos(d4) : d3 / Math.sin(d4);
            if (d <= this.dialRadius) {
                this.lastAngle = d4;
                this.fDragging = true;
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.fDragging && this.fEnabled) {
            double d = (double)mouseEvent.getX() - this.cx;
            double d2 = this.cy - (double)mouseEvent.getY();
            double d3 = Math.atan2(d2, d);
            double d4 = d3 - this.lastAngle;
            if (d4 > Math.PI) {
                d4 -= Math.PI * 2;
            } else if (d4 < -Math.PI) {
                d4 += Math.PI * 2;
            }
            double d5 = (double)this.degSweep * Math.PI / 180.0;
            double d6 = (double)(this.maximum - this.minimum) / d5;
            double d7 = d4 * d6;
            float f = this.value - (float)d7;
            if (f > this.maximum) {
                f = this.maximum;
            }
            if (f < this.minimum) {
                f = this.minimum;
            }
            this.updateValue(f);
            this.lastAngle = d3;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.fDragging = false;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.fDragging = false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected void refresh() {
        Graphics graphics = this.parent.getGraphics();
        if (graphics != null) {
            this.paint(graphics);
            graphics.dispose();
        }
    }

    private void updateValue(float f) {
        if (this.value != f) {
            this.value = f;
            this.refresh();
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                AdjustmentListener adjustmentListener = (AdjustmentListener)enumeration.nextElement();
                adjustmentListener.adjustmentValueChanged(null);
            }
        }
    }

    private void drawKnob(Graphics graphics) {
        double d;
        double d2;
        double d3;
        Color color = this.fEnabled ? this.ptrColor.brighter() : Color.lightGray;
        Color color2 = this.fEnabled ? this.ptrColor.darker() : Color.darkGray;
        double d4 = (double)this.degSweep * Math.PI / 180.0;
        double d5 = (Math.PI - d4) / 2.0;
        double d6 = d5 + d4;
        double d7 = (double)(this.maximum - this.minimum) / d4;
        double d8 = d6 - (double)(this.value - this.minimum) / d7;
        int n = (int)(this.dialRadius * 2.0 + 0.5);
        int n2 = (int)(this.cx - this.dialRadius + 0.5);
        int n3 = (int)(this.cy - this.dialRadius + 0.5);
        graphics.setColor(this.fEnabled ? this.ptrColor : Color.gray);
        graphics.fillOval(n2, n3, n, n);
        graphics.setColor(color);
        graphics.drawArc(n2, n3, n - 1, n - 1, 45, 180);
        graphics.drawArc(n2 + 1, n3 + 1, n - 3, n - 3, 45, 180);
        graphics.setColor(color2);
        graphics.drawArc(n2, n3, n - 1, n - 1, 225, 180);
        graphics.drawArc(n2 + 1, n3 + 1, n - 3, n - 3, 225, 180);
        double d9 = this.dialRadius / 8.0;
        n = (int)(d9 * 2.0 + 0.5);
        double d10 = Math.atan(8.0) * 2.0;
        double d11 = Math.PI + d10 / 2.0;
        int n4 = (int)(d10 * 180.0 / Math.PI + 0.5);
        double d12 = 0.5235987755982988;
        double d13 = (d8 + Math.PI * 2) % (Math.PI * 2) + d12 / 2.0;
        double d14 = d13 + Math.PI * 2;
        for (d3 = d13; d3 < d14; d3 += d12) {
            d2 = this.cx + this.dialRadius * Math.cos(d3);
            double d15 = this.cy - this.dialRadius * Math.sin(d3);
            n2 = (int)(d2 - d9 + 0.5);
            n3 = (int)(d15 - d9 + 0.5);
            graphics.setColor(this.ptrBkgrnd);
            graphics.fillOval(n2, n3, n, n);
            int n5 = (int)((d3 - d11) * 180.0 / Math.PI + 0.5);
            d = d3 % (Math.PI * 2);
            boolean bl = d > 0.7853981633974483 && d < 3.9269908169872414;
            graphics.setColor(bl ? color : color2);
            graphics.drawArc(n2, n3, n - 1, n - 1, n5, n4);
        }
        d3 = 1.5707963267948966;
        d2 = this.dialRadius * 0.12;
        Polygon polygon = new Polygon();
        int n6 = (int)(this.cx + d2 * Math.cos(d8 - d3) + 0.5);
        int n7 = (int)(this.cy - d2 * Math.sin(d8 - d3) + 0.5);
        polygon.addPoint(n6, n7);
        n6 = (int)(this.cx + (this.dialRadius - 2.0) * Math.cos(d8) + 0.5);
        n7 = (int)(this.cy - (this.dialRadius - 2.0) * Math.sin(d8) + 0.5);
        polygon.addPoint(n6, n7);
        n6 = (int)(this.cx + d2 * Math.cos(d8 + d3) + 0.5);
        n7 = (int)(this.cy - d2 * Math.sin(d8 + d3) + 0.5);
        polygon.addPoint(n6, n7);
        graphics.setColor(this.fEnabled ? this.ptrBkgrnd : Color.lightGray);
        graphics.fillPolygon(polygon);
        d = this.dialRadius / 4.0;
        n = (int)(d * 2.0 + 0.5);
        n2 = (int)(this.cx - d + 0.5);
        n3 = (int)(this.cy - d + 0.5);
        graphics.setColor(this.fEnabled ? this.ptrColor : Color.gray);
        graphics.fillOval(n2, n3, n, n);
    }
}

