/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.widgets.Border;
import com.schneiderautomation.widgets.Choices;
import com.schneiderautomation.widgets.HLabel;
import com.schneiderautomation.widgets.MDisplay;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;

public class MIndicatorGui
extends Canvas
implements Serializable {
    static final long serialVersionUID = 6252101352151314561L;
    private Border border = new Border();
    private MDisplay display = new MDisplay();
    private HLabel label = new HLabel();

    public MIndicatorGui() {
        this.InitWrapper();
        this.setBackground(Color.lightGray);
    }

    public void paint(Graphics graphics) {
        this.display.paint(graphics);
        this.label.paint(graphics);
        this.border.paint(graphics);
        if (Wrapper.BORDER_WIDTH != 4) {
            this.InitWrapper();
        }
    }

    private void InitWrapper() {
        Wrapper.BORDER_WIDTH = 4;
        Wrapper.BORDER_WIDTH_X2 = Wrapper.BORDER_WIDTH * 2;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        if (n3 < dimension2.width) {
            n3 = dimension2.width;
        }
        if (n4 < dimension2.height) {
            n4 = dimension2.height;
        }
        super.setBounds(n, n2, n3, n4);
        if (dimension.width != n3 || dimension.height != n4) {
            this.doLayout();
        }
    }

    public void setValue(long l) {
        this.display.setValue(l);
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.display.paint(graphics);
            graphics.dispose();
        }
    }

    public long getValue() {
        return this.display.getValue();
    }

    public void setChoices(Choices choices) {
        this.display.setChoices(choices);
        this.display.setValue(this.getValue());
        this.doLayout();
        this.repaint();
    }

    public Choices getChoices() {
        return this.display.getChoices();
    }

    public void setLabel(String string) {
        this.label.setText(string);
        this.doLayout();
        this.repaint();
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setLabelColor(Color color) {
        this.label.setForeground(color);
        this.repaint();
    }

    public Color getLabelColor() {
        return this.label.getForeground();
    }

    public void setLabelFont(Font font) {
        this.label.setFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getLabelFont() {
        return this.label.getFont();
    }

    public void setMessageForeground(Color color) {
        this.display.setForeground(color);
        this.repaint();
    }

    public Color getMessageForeground() {
        return this.display.getForeground();
    }

    public void setMessageBackground(Color color) {
        this.display.setBackground(color);
        this.repaint();
    }

    public Color getMessageBackground() {
        return this.display.getBackground();
    }

    public void setMessageFont(Font font) {
        this.display.setFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getMessageFont() {
        return this.display.getFont();
    }

    public void setBorderColor(Color color) {
        this.border.setColor(color);
        this.repaint();
    }

    public Color getBorderColor() {
        return this.border.getColor();
    }

    public void setBorderWidth(int n) {
        this.border.setWidth(n);
        this.doLayout();
        this.repaint();
    }

    public int getBorderWidth() {
        return this.border.getWidth();
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        this.border.setBounds(new Rectangle(0, 0, dimension.width, dimension.height));
        int n = this.border.getMinimumSize().height;
        dimension.width -= n;
        dimension.height -= n;
        int n2 = this.label.getMinimumSize().height;
        int n3 = dimension.height - n2;
        int n4 = n / 2;
        this.display.setBounds(new Rectangle(n4, n4, dimension.width, n3));
        this.label.setBounds(new Rectangle(n4, n4 + n3, dimension.width, n2));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        dimension.width += 100;
        dimension.height += 10;
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.display.getMinimumSize();
        Dimension dimension2 = this.label.getMinimumSize();
        Dimension dimension3 = this.border.getMinimumSize();
        int n = dimension.width;
        if (dimension2.width > n) {
            n = dimension2.width;
        }
        int n2 = dimension2.height + dimension.height + dimension3.height;
        return new Dimension(n += dimension3.width, n2);
    }
}

