/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.dt.DT;
import com.schneiderautomation.factorycast.MonitorNumber;
import com.schneiderautomation.factorycast.MonitorRef;
import com.schneiderautomation.factorycast.ServerChangeEvent;
import com.schneiderautomation.gde.GraphicalObject;
import com.schneiderautomation.gde.MonitorSupport;
import com.schneiderautomation.widgets.MeterGui;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public class Meter
extends MeterGui
implements GraphicalObject,
PropertyChangeListener,
Serializable {
    static final long serialVersionUID = -8637950254221358058L;
    private transient float value;
    private MonitorNumber monitor = new MonitorNumber();
    private MonitorSupport support = new MonitorSupport((MonitorRef)this.monitor, (GraphicalObject)this);
    private float minValue;
    private float maxValue;

    public Meter() {
        this.monitor.addPropertyChangeListener((PropertyChangeListener)this);
        this.minValue = this.getMinimum();
        this.maxValue = this.getMaximum();
    }

    public void serverChanged(ServerChangeEvent serverChangeEvent) {
        this.monitor.serverChanged(serverChangeEvent);
    }

    public void enableUserInput() {
    }

    public void disableUserInput() {
    }

    public String getStatus() {
        return this.support.getStatus();
    }

    public boolean isErrorStatus() {
        return this.support.isErrorStatus();
    }

    public float getPlcValue() {
        return this.value;
    }

    public void setPlcValue(float f) {
        short s = this.getDatatype();
        this.value = (float)Math.min(Math.max((double)f, DT.minValue((short)s)), DT.maxValue((short)s));
        this.refreshValue();
    }

    public void setMinimum(float f) {
        super.setMinimum(f);
        this.refreshValue();
    }

    public void setMaximum(float f) {
        super.setMaximum(f);
        this.refreshValue();
    }

    public void setMinValue(float f) {
        short s = this.getDatatype();
        if ((f = (float)Math.min(Math.max((double)f, DT.minValue((short)s)), DT.maxValue((short)s))) > this.maxValue) {
            f = this.maxValue;
        }
        this.minValue = f;
        this.refreshValue();
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(float f) {
        short s = this.getDatatype();
        if ((f = (float)Math.min(Math.max((double)f, DT.minValue((short)s)), DT.maxValue((short)s))) < this.minValue) {
            f = this.minValue;
        }
        this.maxValue = f;
        this.refreshValue();
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public String getAddress() {
        return this.monitor.getAddress();
    }

    public void setAddress(String string) {
        this.monitor.setAddress(string);
    }

    public short getDatatype() {
        return this.monitor.getDatatype();
    }

    public void setDatatype(short s) {
        this.monitor.setDatatype(s);
        this.setPlcValue(this.value);
        this.setMinValue(this.minValue);
        this.setMaxValue(this.maxValue);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("value")) {
            this.value = this.monitor.getValue().floatValue();
            this.refreshValue();
        }
    }

    private void refreshValue() {
        float f = this.getMinimum();
        float f2 = this.getMaximum();
        float f3 = (f2 - f) / (this.maxValue - this.minValue);
        float f4 = (this.value - this.minValue) * f3 + f;
        if (f4 < f) {
            f4 = f;
        }
        if (f4 > f2) {
            f4 = f2;
        }
        this.setValue(f4);
    }
}

