/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.widgets.MScale;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.Toolkit;
import java.io.Serializable;

class RScale
extends MScale
implements Serializable {
    static final long serialVersionUID = -3722513086817433983L;
    private Color ptrBkgrnd = Color.white;
    private Color dialColor = Color.blue;
    private float[] limits = new float[]{this.minval, this.minval, this.maxval, this.maxval};
    private Color[] colors = new Color[]{Color.red, Color.yellow, Color.yellow, Color.red};

    RScale() {
        this.minorTics = 4;
        this.majorTics = 2;
    }

    int getLabelLength() {
        int n;
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        int n2 = fontMetrics.getHeight();
        int n3 = fontMetrics.stringWidth(this.formatValue(this.minval));
        int n4 = n3 > (n = fontMetrics.stringWidth(this.formatValue(this.maxval))) ? n3 : n;
        return n4 > n2 ? n4 : n2;
    }

    String getLabel(int n) {
        if (n == this.majorTics) {
            return this.formatValue(this.minval);
        }
        double d = (double)this.maxval - (double)this.minval;
        double d2 = (double)n / (double)this.majorTics;
        return this.formatValue((float)((double)this.maxval - d2 * d));
    }

    void setMinimum(float f) {
        super.setMinimum(f);
        for (int i = 0; i < this.limits.length; ++i) {
            this.limits[i] = Math.max(this.limits[i], this.minval);
        }
    }

    void setMaximum(float f) {
        super.setMaximum(f);
        for (int i = 0; i < this.limits.length; ++i) {
            this.limits[i] = Math.min(this.limits[i], this.maxval);
        }
    }

    void setPointerBackground(Color color) {
        this.ptrBkgrnd = color;
    }

    void setDialColor(Color color) {
        this.dialColor = color;
    }

    Color getDialColor() {
        return this.dialColor;
    }

    void setLimitColor(int n, Color color) {
        this.colors[n] = color;
    }

    Color getLimitColor(int n) {
        return this.colors[n];
    }

    void setLimitValue(int n, float f) {
        this.limits[n] = Math.min(Math.max(f, this.minval), this.maxval);
    }

    float getLimitValue(int n) {
        return this.limits[n];
    }

    void paint(Graphics graphics) {
        if (this.majorTics > 0 || this.minorTics > 0) {
            Shape shape = graphics.getClip();
            graphics.setClip(this.box);
            this.drawColorBand(graphics);
            graphics.setClip(shape);
        }
        super.paint(graphics);
    }

    private void drawColorBand(Graphics graphics) {
        double d = (double)this.degSweep * Math.PI / 180.0;
        double d2 = (double)(this.maxval - this.minval) / d;
        double d3 = (Math.PI - d) / 2.0;
        float f = this.limits[3] > this.maxval ? this.maxval : this.limits[3];
        float f2 = this.limits[2] > f ? f : this.limits[2];
        float f3 = this.limits[1] > f2 ? f2 : this.limits[1];
        float f4 = this.limits[0] > f3 ? f3 : this.limits[0];
        float f5 = this.limits[0] < this.minval ? this.minval : this.limits[0];
        float f6 = this.limits[1] < f5 ? f5 : this.limits[1];
        float f7 = this.limits[2] < f6 ? f6 : this.limits[2];
        float f8 = this.limits[3] < f7 ? f7 : this.limits[3];
        float f9 = f5 > f4 ? f4 : f5;
        float f10 = f6 > f3 ? f3 : f6;
        float f11 = f2 > f7 ? f7 : f2;
        float f12 = f > f8 ? f8 : f;
        double d4 = d3;
        double d5 = (double)(this.maxval - f12) / d2;
        graphics.setColor(this.colors[3]);
        this.fillArc(graphics, this.ticRadius, d4, d5);
        d4 += d5;
        d5 = (double)(f12 - f11) / d2;
        graphics.setColor(this.colors[2]);
        this.fillArc(graphics, this.ticRadius, d4, d5);
        d4 += d5;
        d5 = (double)(f11 - f10) / d2;
        graphics.setColor(this.dialColor);
        this.fillArc(graphics, this.ticRadius, d4, d5);
        d4 += d5;
        d5 = (double)(f10 - f9) / d2;
        graphics.setColor(this.colors[1]);
        this.fillArc(graphics, this.ticRadius, d4, d5);
        d4 += d5;
        d5 = (double)(f9 - this.minval) / d2;
        graphics.setColor(this.colors[0]);
        this.fillArc(graphics, this.ticRadius, d4, d5);
        graphics.setColor(this.ptrBkgrnd);
        this.fillCircle(graphics, this.colorRadius);
        graphics.setColor(this.foreground);
        this.drawArc(graphics, this.colorRadius);
        this.drawArc(graphics, this.ticRadius);
    }

    private void drawArc(Graphics graphics, double d) {
        int n = (int)(d * 2.0 + 0.5);
        int n2 = (int)(this.cx - d + 0.5);
        int n3 = (int)(this.cy - d + 0.5);
        int n4 = (180 - this.degSweep) / 2;
        graphics.drawArc(n2, n3, n - 1, n - 1, n4, this.degSweep);
    }

    private void fillArc(Graphics graphics, double d, double d2, double d3) {
        int n = (int)(d * 2.0 + 0.5);
        int n2 = (int)(this.cx - d + 0.5);
        int n3 = (int)(this.cy - d + 0.5);
        int n4 = (int)(d2 * 180.0 / Math.PI + 0.5);
        int n5 = (int)(d3 * 180.0 / Math.PI + 0.5);
        graphics.fillArc(n2, n3, n, n, n4, n5);
    }

    private void fillCircle(Graphics graphics, double d) {
        int n = (int)(d * 2.0 + 0.5);
        int n2 = (int)(this.cx - d + 0.5);
        int n3 = (int)(this.cy - d + 0.5);
        graphics.fillOval(n2, n3, n, n);
    }
}

