/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.widgets.CircularSelector;
import com.schneiderautomation.widgets.ListScaleInterface;
import com.schneiderautomation.widgets.RList;
import com.schneiderautomation.widgets.SelectorGui;
import com.schneiderautomation.widgets.SelectorInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.io.Serializable;

public class RSelectorGui
extends SelectorGui
implements Serializable {
    static final long serialVersionUID = -5195110895724741710L;
    private transient Integer selected;
    private RList scale = new RList();
    private CircularSelector knob = new CircularSelector(this);

    public RSelectorGui() {
        this.InitWrapper();
        this.setBackground(Color.lightGray);
        this.scale.setDialBandWidth(30);
        this.knob.setDegSweep(this.scale.getDegSweep());
        this.knob.addAdjustmentListener(this);
    }

    protected ListScaleInterface getScale() {
        return this.scale;
    }

    private void InitWrapper() {
        Wrapper.BORDER_WIDTH = 4;
        Wrapper.BORDER_WIDTH_X2 = Wrapper.BORDER_WIDTH * 2;
    }

    protected SelectorInterface getSelector() {
        return this.knob;
    }

    public void paint(Graphics graphics) {
        this.scale.paint(graphics);
        this.knob.paint(graphics);
        super.paint(graphics);
        if (Wrapper.BORDER_WIDTH != 4) {
            this.InitWrapper();
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.knob.setPointerBackground(color);
    }

    public void setDegSweep(int n) {
        this.scale.setDegSweep(n);
        this.knob.setDegSweep(this.scale.getDegSweep());
        this.doLayout();
        this.repaint();
    }

    public int getDegSweep() {
        return this.scale.getDegSweep();
    }

    public void setKnobColor(Color color) {
        this.knob.setPointerColor(color);
    }

    public Color getKnobColor() {
        return this.knob.getPointerColor();
    }

    public int getSelectedIndex() {
        return this.knob.getValue();
    }

    public void setSelection(long l) {
        this.knob.select(l);
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.knob.paint(graphics);
            graphics.dispose();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = this.getSelectedIndex();
        if (this.selected == null || this.selected != n) {
            this.selected = new Integer(n);
            this.knob.setValue(n);
            Graphics graphics = this.getGraphics();
            this.knob.paint(graphics);
            graphics.dispose();
            super.adjustmentValueChanged(adjustmentEvent);
        }
    }

    public void doLayout() {
        int n;
        Dimension dimension = this.getSize();
        this.border.setBounds(new Rectangle(0, 0, dimension.width, dimension.height));
        int n2 = this.border.getMinimumSize().height;
        dimension.width -= n2;
        dimension.height -= n2;
        int n3 = this.label.getMinimumSize().height;
        int n4 = dimension.height - n3;
        int n5 = n = n2 / 2;
        this.scale.setBounds(new Rectangle(n, n5, dimension.width, n4));
        this.knob.setBounds(this.scale.getBounds(), this.scale.getCenterX(), this.scale.getCenterY(), this.scale.getInnerRadius());
        this.label.setBounds(new Rectangle(n, n5 += n4, dimension.width, n3));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        dimension.width += 30;
        dimension.height += 15;
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.scale.getMinimumSize();
        Dimension dimension2 = this.label.getMinimumSize();
        Dimension dimension3 = this.border.getMinimumSize();
        int n = dimension.width;
        if (dimension2.width > n) {
            n = dimension2.width;
        }
        int n2 = dimension.height + dimension2.height + dimension3.height;
        return new Dimension(n += dimension3.width, n2);
    }
}

