/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.widgets.CircularSlider;
import com.schneiderautomation.widgets.RScale;
import com.schneiderautomation.widgets.Scale;
import com.schneiderautomation.widgets.SliderGui;
import com.schneiderautomation.widgets.SliderInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;

public class RSliderGui
extends SliderGui
implements Serializable {
    static final long serialVersionUID = -6485469268906964726L;
    private RScale scale = new RScale();
    private CircularSlider knob = new CircularSlider(this);

    public RSliderGui() {
        this.InitWrapper();
        this.setBackground(Color.lightGray);
        this.scale.setDialBandWidth(30);
        this.scale.setDialColor(this.getBackground());
        this.knob.setDegSweep(this.scale.getDegSweep());
        this.scale.setMinimum(this.knob.getEUMinimum());
        this.scale.setMaximum(this.knob.getEUMaximum());
        this.scale.setLimitValue(0, this.knob.getEUMinimum());
        this.scale.setLimitValue(1, this.knob.getEUMinimum());
        this.scale.setLimitValue(2, this.knob.getEUMaximum());
        this.scale.setLimitValue(3, this.knob.getEUMaximum());
    }

    protected Scale getScale() {
        return this.scale;
    }

    protected SliderInterface getSlider() {
        return this.knob;
    }

    private void InitWrapper() {
        Wrapper.BORDER_WIDTH = 4;
        Wrapper.BORDER_WIDTH_X2 = Wrapper.BORDER_WIDTH * 2;
    }

    public void paint(Graphics graphics) {
        this.InitWrapper();
        this.scale.paint(graphics);
        this.knob.paint(graphics);
        super.paint(graphics);
        if (Wrapper.BORDER_WIDTH != 4) {
            this.InitWrapper();
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.scale.setPointerBackground(color);
        this.knob.setPointerBackground(color);
    }

    public void setValue(float f) {
        this.knob.setEUValue(f);
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.knob.paint(graphics);
            graphics.dispose();
        }
    }

    public void setMinimum(float f) {
        this.knob.setEUMinimum(f);
        this.scale.setMinimum(this.knob.getEUMinimum());
        this.scale.setLimitValue(0, this.knob.getEUMinimum());
        this.scale.setLimitValue(1, this.knob.getEUMinimum());
        this.doLayout();
        this.repaint();
    }

    public void setMaximum(float f) {
        this.knob.setEUMaximum(f);
        this.scale.setMaximum(this.knob.getEUMaximum());
        this.scale.setLimitValue(2, this.knob.getEUMaximum());
        this.scale.setLimitValue(3, this.knob.getEUMaximum());
        this.doLayout();
        this.repaint();
    }

    public void setDegSweep(int n) {
        this.scale.setDegSweep(n);
        this.knob.setDegSweep(this.scale.getDegSweep());
        this.doLayout();
        this.repaint();
    }

    public int getDegSweep() {
        return this.scale.getDegSweep();
    }

    public void setKnobColor(Color color) {
        this.knob.setPointerColor(color);
    }

    public Color getKnobColor() {
        return this.knob.getPointerColor();
    }

    public void setDialColor(Color color) {
        this.scale.setDialColor(color);
        this.repaint();
    }

    public Color getDialColor() {
        return this.scale.getDialColor();
    }

    public void doLayout() {
        int n;
        Dimension dimension = this.getSize();
        this.border.setBounds(new Rectangle(0, 0, dimension.width, dimension.height));
        int n2 = this.border.getMinimumSize().height;
        dimension.width -= n2;
        dimension.height -= n2;
        int n3 = this.label.getMinimumSize().height;
        int n4 = dimension.height - n3;
        int n5 = n = n2 / 2;
        this.scale.setBounds(new Rectangle(n, n5, dimension.width, n4));
        this.knob.setBounds(this.scale.getBounds(), this.scale.getCenterX(), this.scale.getCenterY(), this.scale.getInnerRadius());
        this.label.setBounds(new Rectangle(n, n5 += n4, dimension.width, n3));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        dimension.width += 30;
        dimension.height += 15;
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.scale.getMinimumSize();
        Dimension dimension2 = this.label.getMinimumSize();
        Dimension dimension3 = this.border.getMinimumSize();
        int n = dimension.width;
        if (dimension2.width > n) {
            n = dimension2.width;
        }
        int n2 = dimension.height + dimension2.height + dimension3.height;
        return new Dimension(n += dimension3.width, n2);
    }
}

