/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.text.NumberFormat;

abstract class Scale
implements Serializable {
    static final long serialVersionUID = 3788899871686348269L;
    protected transient NumberFormat format;
    protected boolean fCenterEndLabels;
    protected float minval;
    protected float maxval;
    protected int minorTics = 5;
    protected int majorTics = 1;
    protected int minorTicSize = 8;
    protected int majorTicSize = 12;
    protected int precision = 0;
    protected Color foreground = Color.black;
    protected Font font = new Font("SansSerif", 0, 12);
    protected Rectangle box = new Rectangle();

    Scale() {
    }

    Scale(boolean bl) {
        this.fCenterEndLabels = bl;
    }

    abstract void paint(Graphics var1);

    abstract Dimension getMinimumSize();

    void setBounds(Rectangle rectangle) {
        this.box = rectangle;
    }

    void setMinimum(float f) {
        this.minval = f;
    }

    void setMaximum(float f) {
        this.maxval = f;
    }

    void setPrecision(int n) {
        this.precision = Math.min(Math.max(n, -1), 6);
        if (this.format != null && this.precision >= 0) {
            this.format.setMaximumFractionDigits(this.precision);
            this.format.setMinimumFractionDigits(this.precision);
        }
    }

    int getPrecision() {
        return this.precision;
    }

    void setForeground(Color color) {
        this.foreground = color;
    }

    Color getForeground() {
        return this.foreground;
    }

    void setFont(Font font) {
        this.font = font;
    }

    Font getFont() {
        return this.font;
    }

    void setMinorTics(int n) {
        this.minorTics = Math.min(Math.max(n, 0), 100);
    }

    int getMinorTics() {
        return this.minorTics;
    }

    void setMajorTics(int n) {
        this.majorTics = Math.min(Math.max(n, 0), 100);
    }

    int getMajorTics() {
        return this.majorTics;
    }

    void setMinorTicSize(int n) {
        if (n < 0) {
            n = 0;
        }
        this.minorTicSize = n;
    }

    int getMinorTicSize() {
        return this.minorTicSize;
    }

    void setMajorTicSize(int n) {
        if (n < 0) {
            n = 0;
        }
        this.majorTicSize = n;
    }

    int getMajorTicSize() {
        return this.majorTicSize;
    }

    String formatValue(float f) {
        if (this.format == null && this.precision >= 0) {
            this.format = NumberFormat.getInstance();
            this.format.setMaximumFractionDigits(this.precision);
            this.format.setMinimumFractionDigits(this.precision);
        }
        if (this.precision < 0) {
            return String.valueOf(f);
        }
        return this.format.format(f);
    }
}

