/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.factorycast.MonitorRef;
import com.schneiderautomation.gde.BeanErrorHandler;
import com.schneiderautomation.gde.CommSupport;
import com.schneiderautomation.gde.GraphicalObject;
import com.schneiderautomation.gde.MonitorSupport;
import com.schneiderautomation.widgets.InputSupport;
import com.schneiderautomation.widgets.InputSupportInterface;
import com.schneiderautomation.widgets.SelectorSupportInterface;
import com.schneiderautomation.widgets.WidgetStrings;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class SelectorSupport
extends MonitorSupport
implements InputSupportInterface,
Serializable {
    static final long serialVersionUID = 8911474771075413254L;
    private transient boolean fBadInit;
    private InputSupport support = new InputSupport(this);
    private SelectorSupportInterface selector;

    public SelectorSupport(SelectorSupportInterface selectorSupportInterface, MonitorRef monitorRef, GraphicalObject graphicalObject) {
        super(monitorRef, graphicalObject);
        this.selector = selectorSupportInterface;
    }

    public void updateNotify() {
        this.support.updateNotify();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("value")) {
            this.support.input((Number)propertyChangeEvent.getNewValue());
            return;
        }
        super.propertyChange(propertyChangeEvent);
    }

    public void receive(Number number) {
        this.setSelection(number.longValue());
    }

    private void setSelection(long l) {
        boolean bl = this.selector.select(l);
        if (!bl && !this.fBadInit) {
            Object[] objectArray = new Object[]{String.valueOf(l)};
            String string = WidgetStrings.getFormattedString("BAD_SELECTOR_INIT", objectArray);
            String string2 = ((Component)((CommSupport)this).bean).getName() + " (" + this.monitor.getAddress() + "):";
            BeanErrorHandler beanErrorHandler = this.getErrorHandler();
            if (beanErrorHandler != null) {
                beanErrorHandler.reportReadError(string2, string);
            } else {
                System.err.println("Initialization error reported by " + string2);
                System.err.println("\t" + string);
            }
        }
        this.fBadInit = !bl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            if (this.support == null) {
                this.support = new InputSupport(this);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("ClassNotFoundException reading SelectorSupport object: " + classNotFoundException.getMessage());
        }
    }
}

