/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.widgets.Border;
import com.schneiderautomation.widgets.HLabel;
import com.schneiderautomation.widgets.Scale;
import com.schneiderautomation.widgets.SliderInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.AdjustmentListener;
import java.io.Serializable;

public abstract class SliderGui
extends Panel
implements Serializable {
    static final long serialVersionUID = -5843076152000475736L;
    protected Border border = new Border();
    protected HLabel label = new HLabel();

    public SliderGui() {
        this.setLayout(null);
    }

    protected abstract Scale getScale();

    protected abstract SliderInterface getSlider();

    public void paint(Graphics graphics) {
        this.label.paint(graphics);
        this.border.paint(graphics);
        super.paint(graphics);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        if (n3 < dimension2.width) {
            n3 = dimension2.width;
        }
        if (n4 < dimension2.height) {
            n4 = dimension2.height;
        }
        super.setBounds(n, n2, n3, n4);
        if (dimension.width != n3 || dimension.height != n4) {
            this.doLayout();
        }
    }

    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.getSlider().addAdjustmentListener(adjustmentListener);
    }

    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.getSlider().removeAdjustmentListener(adjustmentListener);
    }

    public void setEnabled(boolean bl) {
        this.getSlider().setEnabled(bl);
        this.repaint();
    }

    public boolean isEnabled() {
        return this.getSlider().isEnabled();
    }

    public void setValue(float f) {
        this.getSlider().setEUValue(f);
    }

    public float getValue() {
        return this.getSlider().getEUValue();
    }

    public void setMinimum(float f) {
        this.getSlider().setEUMinimum(f);
        this.getScale().setMinimum(this.getSlider().getEUMinimum());
        this.doLayout();
        this.repaint();
    }

    public float getMinimum() {
        return this.getSlider().getEUMinimum();
    }

    public void setMaximum(float f) {
        this.getSlider().setEUMaximum(f);
        this.getScale().setMaximum(this.getSlider().getEUMaximum());
        this.doLayout();
        this.repaint();
    }

    public float getMaximum() {
        return this.getSlider().getEUMaximum();
    }

    public void setBlockIncrement(float f) {
        this.getSlider().setEUBlockIncrement(f);
        this.repaint();
    }

    public float getBlockIncrement() {
        return this.getSlider().getEUBlockIncrement();
    }

    public void setUnitIncrement(float f) {
        this.getSlider().setEUUnitIncrement(f);
        this.repaint();
    }

    public float getUnitIncrement() {
        return this.getSlider().getEUUnitIncrement();
    }

    public void setLabel(String string) {
        this.label.setText(string);
        this.doLayout();
        this.repaint();
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setLabelColor(Color color) {
        this.label.setForeground(color);
        this.repaint();
    }

    public Color getLabelColor() {
        return this.label.getForeground();
    }

    public void setLabelFont(Font font) {
        this.label.setFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getLabelFont() {
        return this.label.getFont();
    }

    public void setPrecision(int n) {
        this.getScale().setPrecision(n);
        this.doLayout();
        this.repaint();
    }

    public int getPrecision() {
        return this.getScale().getPrecision();
    }

    public void setMinorTics(int n) {
        this.getScale().setMinorTics(n);
        this.doLayout();
        this.repaint();
    }

    public int getMinorTics() {
        return this.getScale().getMinorTics();
    }

    public void setMajorTics(int n) {
        this.getScale().setMajorTics(n);
        this.doLayout();
        this.repaint();
    }

    public int getMajorTics() {
        return this.getScale().getMajorTics();
    }

    public void setScaleFont(Font font) {
        this.getScale().setFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getScaleFont() {
        return this.getScale().getFont();
    }

    public void setScaleColor(Color color) {
        this.getScale().setForeground(color);
        this.repaint();
    }

    public Color getScaleColor() {
        return this.getScale().getForeground();
    }

    public void setBorderColor(Color color) {
        this.border.setColor(color);
        this.repaint();
    }

    public Color getBorderColor() {
        return this.border.getColor();
    }

    public void setBorderWidth(int n) {
        this.border.setWidth(n);
        this.doLayout();
        this.repaint();
    }

    public int getBorderWidth() {
        return this.border.getWidth();
    }
}

