/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.widgets.Bar;
import com.schneiderautomation.widgets.IndicatorGui;
import com.schneiderautomation.widgets.Scale;
import com.schneiderautomation.widgets.VBar;
import com.schneiderautomation.widgets.VScale;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.Serializable;

public class VIndicatorGui
extends IndicatorGui
implements Serializable {
    static final long serialVersionUID = 3770182818859628804L;
    private VScale scale;
    private VBar bar;

    public VIndicatorGui() {
        this.InitWrapper();
        this.scale = new VScale(false);
        this.bar = new VBar();
        this.scale.setMinimum(this.bar.getMinimum());
        this.scale.setMaximum(this.bar.getMaximum());
    }

    Scale getScale() {
        return this.scale;
    }

    private void InitWrapper() {
        Wrapper.BORDER_WIDTH = 4;
        Wrapper.BORDER_WIDTH_X2 = Wrapper.BORDER_WIDTH * 2;
    }

    Bar getBar() {
        return this.bar;
    }

    public void setPrecision(int n) {
        this.scale.setPrecision(n);
        this.doLayout();
        this.repaint();
    }

    public int getPrecision() {
        return this.scale.getPrecision();
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        this.border.setBounds(new Rectangle(0, 0, dimension.width, dimension.height));
        int n = this.border.getMinimumSize().height;
        dimension.width -= n;
        dimension.height -= n;
        int n2 = this.scale.getMinimumSize().width;
        int n3 = this.label.getMinimumSize().height;
        int n4 = dimension.width - n2;
        int n5 = dimension.height - n3;
        int n6 = n / 2;
        this.bar.setBounds(new Rectangle(n6, n6, n4, n5));
        this.scale.setBounds(new Rectangle(n6 + n4, n6, n2, n5));
        this.label.setBounds(new Rectangle(n6, n6 + n5, dimension.width, n3));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        dimension.width += 12;
        dimension.height += 100;
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.scale.getMinimumSize();
        Dimension dimension2 = this.bar.getMinimumSize();
        Dimension dimension3 = this.label.getMinimumSize();
        Dimension dimension4 = this.border.getMinimumSize();
        int n = dimension.width + dimension2.width;
        if (dimension3.width > n) {
            n = dimension3.width;
        }
        n += dimension4.width;
        int n2 = dimension.height;
        if (dimension2.height > n2) {
            n2 = dimension2.height;
        }
        return new Dimension(n, n2 += dimension4.height + dimension3.height);
    }
}

