/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;

public class WidgetScrollbar
extends Canvas
implements Runnable,
Adjustable,
MouseListener,
MouseMotionListener {
    static final long serialVersionUID = 323472142497507410L;
    static final int MIN_THUMB = 8;
    static final int CX_ARROW = 16;
    static final int CX_ARROW_X2 = 32;
    private static final Color TRACK_COLOR = new Color(215, 210, 215);
    private Vector listeners = new Vector();
    private int orientation;
    private int value;
    private int visibleAmount;
    private int minimum;
    private int maximum;
    private int lineIncrement = 1;
    private int pageIncrement = 10;
    private transient Rectangle thumb;
    private transient Point dragStart;
    private transient int dragValue;
    private transient Rectangle dragThumb;
    private transient Thread repeater;
    private transient int adjustmentType;
    private transient int pageLimit;
    private transient boolean fPaging;

    public WidgetScrollbar() {
        this(1);
    }

    public WidgetScrollbar(int n) {
        this(n, 0, 10, 0, 100);
    }

    public WidgetScrollbar(int n, int n2, int n3, int n4, int n5) {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setOrientation(n);
        this.setValues(n2, n3, n4, n5);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.orientation == 0) {
            graphics.setColor(Color.lightGray);
            graphics.fillRect(0, 0, 16, dimension.height);
            graphics.fillRect(dimension.width - 16, 0, 16, dimension.height);
            Polygon polygon = this.getArrow(6, dimension.height / 2, 3);
            Polygon polygon2 = this.getArrow(dimension.width - 6 - 1, dimension.height / 2, -3);
            graphics.setColor(this.isEnabled() ? Color.black : Color.gray);
            graphics.fillPolygon(polygon);
            graphics.drawPolygon(polygon);
            graphics.fillPolygon(polygon2);
            graphics.drawPolygon(polygon2);
            this.draw3DRect(graphics, 0, 0, 16, dimension.height, Color.white, Color.black);
            this.draw3DRect(graphics, dimension.width - 16, 0, dimension.width, dimension.height, Color.white, Color.black);
        } else {
            graphics.setColor(Color.lightGray);
            graphics.fillRect(0, 0, dimension.width, 16);
            graphics.fillRect(0, dimension.height - 16, dimension.width, 16);
            Polygon polygon = this.getArrow(dimension.width / 2, 6, 3);
            Polygon polygon3 = this.getArrow(dimension.width / 2, dimension.height - 6 - 1, -3);
            graphics.setColor(this.isEnabled() ? Color.black : Color.gray);
            graphics.fillPolygon(polygon);
            graphics.drawPolygon(polygon);
            graphics.fillPolygon(polygon3);
            graphics.drawPolygon(polygon3);
            this.draw3DRect(graphics, 0, 0, dimension.width, 16, Color.white, Color.black);
            this.draw3DRect(graphics, 0, dimension.height - 16, dimension.width, dimension.height, Color.white, Color.black);
        }
        if (this.thumb == null) {
            this.setThumb();
        }
        if (this.thumb != null) {
            this.drawThumb(graphics);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.thumb = null;
        this.repaint();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.repaint();
    }

    public synchronized void setOrientation(int n) {
        if (n == this.orientation) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: {
                this.orientation = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal scrollbar orientation");
            }
        }
        this.invalidate();
        this.thumb = null;
        this.repaint();
    }

    public synchronized void setValues(int n, int n2, int n3, int n4) {
        this.minimum = n3;
        this.maximum = Math.max(n4, this.minimum + 1);
        this.visibleAmount = Math.min(Math.max(n2, 1), this.maximum - this.minimum);
        this.value = Math.min(Math.max(n, this.minimum), this.maximum - this.visibleAmount);
        this.thumb = null;
        this.repaint();
    }

    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.listeners.addElement(adjustmentListener);
    }

    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.listeners.removeElement(adjustmentListener);
    }

    public int getBlockIncrement() {
        return this.pageIncrement;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getUnitIncrement() {
        return this.lineIncrement;
    }

    public int getValue() {
        return this.value;
    }

    public int getVisibleAmount() {
        return this.visibleAmount;
    }

    public void setUnitIncrement(int n) {
        this.lineIncrement = n;
    }

    public void setBlockIncrement(int n) {
        this.pageIncrement = n;
    }

    public void setMaximum(int n) {
        this.setValues(this.value, this.visibleAmount, this.minimum, n);
    }

    public void setMinimum(int n) {
        this.setValues(this.value, this.visibleAmount, n, this.maximum);
    }

    public void setVisibleAmount(int n) {
        this.setValues(this.value, n, this.minimum, this.maximum);
    }

    public synchronized void setValue(int n) {
        if ((n = Math.min(Math.max(n, this.minimum), this.maximum - this.visibleAmount)) != this.value) {
            this.value = n;
            this.setThumb();
            this.drawThumb();
        }
    }

    public void run() {
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (this.repeater != null) {
            this.adjustValue();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.thumb != null && this.dragStart == null && this.repeater == null) {
            int n;
            int n2;
            int n3;
            int n4;
            if (this.thumb.contains(mouseEvent.getPoint())) {
                this.adjustmentType = 5;
                this.dragStart = mouseEvent.getPoint();
                this.dragValue = this.value;
                this.dragThumb = new Rectangle(this.thumb);
                return;
            }
            if (this.orientation == 0) {
                n4 = mouseEvent.getX();
                n3 = this.thumb.x;
                n2 = 16;
                n = this.getSize().width - 16;
            } else {
                n4 = mouseEvent.getY();
                n3 = this.thumb.y;
                n2 = 16;
                n = this.getSize().height - 16;
            }
            if (n4 <= n2) {
                this.adjustmentType = 2;
                Dimension dimension = this.getSize();
                Graphics graphics = this.getGraphics();
                if (this.orientation == 0) {
                    this.draw3DRect(graphics, 0, 0, 16, dimension.height, Color.black, Color.white);
                } else {
                    this.draw3DRect(graphics, 0, 0, dimension.width, 16, Color.black, Color.white);
                }
                graphics.dispose();
            } else if (n4 < n3) {
                this.adjustmentType = 3;
                this.setPageLimit(n4);
            } else if (n4 >= n) {
                this.adjustmentType = 1;
                Dimension dimension = this.getSize();
                Graphics graphics = this.getGraphics();
                if (this.orientation == 0) {
                    this.draw3DRect(graphics, dimension.width - 16, 0, dimension.width, dimension.height, Color.black, Color.white);
                } else {
                    this.draw3DRect(graphics, 0, dimension.height - 16, dimension.width, dimension.height, Color.black, Color.white);
                }
                graphics.dispose();
            } else {
                this.adjustmentType = 4;
                this.setPageLimit(n4);
            }
            this.adjustValue();
            this.repeater = new Thread(this);
            this.repeater.start();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.dragStart != null) {
            this.dragStart = null;
            this.repaint();
        }
        if (this.repeater != null) {
            Thread thread = this.repeater;
            this.repeater = null;
            try {
                thread.interrupt();
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.fPaging = false;
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dragStart != null) {
            int n;
            float f = this.maximum - this.visibleAmount;
            float f2 = this.minimum;
            Rectangle rectangle = new Rectangle(this.dragThumb);
            if (this.orientation == 0) {
                int n2 = this.getSize().width - 32;
                int n3 = n2 - this.thumb.width;
                float f3 = (f - f2) / (float)n3;
                int n4 = mouseEvent.getX() - this.dragStart.x;
                n = (int)((double)((float)this.dragValue + (float)n4 * f3) + 0.5);
                rectangle.x = Math.min(Math.max(this.dragThumb.x + n4, 16), 16 + n3);
            } else {
                int n5 = this.getSize().height - 32;
                int n6 = n5 - this.thumb.height;
                float f4 = (f - f2) / (float)n6;
                int n7 = mouseEvent.getY() - this.dragStart.y;
                n = (int)((double)((float)this.dragValue + (float)n7 * f4) + 0.5);
                rectangle.y = Math.min(Math.max(this.dragThumb.y + n7, 16), 16 + n6);
            }
            this.adjustValue(n, rectangle);
        }
        if (this.repeater != null) {
            if (this.adjustmentType == 3) {
                if (this.orientation == 0) {
                    if (mouseEvent.getX() < this.thumb.x) {
                        this.setPageLimit(mouseEvent.getX());
                    }
                } else if (mouseEvent.getY() < this.thumb.y) {
                    this.setPageLimit(mouseEvent.getY());
                }
            } else if (this.adjustmentType == 4) {
                if (this.orientation == 0) {
                    if (mouseEvent.getX() > this.thumb.x + this.thumb.width) {
                        this.setPageLimit(mouseEvent.getX());
                    }
                } else if (mouseEvent.getY() > this.thumb.y + this.thumb.height) {
                    this.setPageLimit(mouseEvent.getY());
                }
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.dragStart = null;
        this.repeater = null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            AdjustmentListener adjustmentListener = (AdjustmentListener)enumeration.nextElement();
            adjustmentListener.adjustmentValueChanged(adjustmentEvent);
        }
    }

    protected String paramString() {
        return super.paramString() + ",val=" + this.value + ",vis=" + this.visibleAmount + ",min=" + this.minimum + ",max=" + this.maximum + (this.orientation == 1 ? ",vert" : ",horz");
    }

    private final void adjustValue() {
        switch (this.adjustmentType) {
            case 4: {
                if (this.value < this.pageLimit) {
                    this.fPaging = true;
                    this.adjustValue(this.value + this.pageIncrement, null);
                    break;
                }
                this.fPaging = false;
                this.drawThumb();
                break;
            }
            case 3: {
                if (this.value > this.pageLimit) {
                    this.fPaging = true;
                    this.adjustValue(this.value - this.pageIncrement, null);
                    break;
                }
                this.fPaging = false;
                this.drawThumb();
                break;
            }
            case 1: {
                this.adjustValue(this.value + this.lineIncrement, null);
                break;
            }
            case 2: {
                this.adjustValue(this.value - this.lineIncrement, null);
            }
        }
    }

    private final void adjustValue(int n, Rectangle rectangle) {
        if ((n = Math.min(Math.max(n, this.minimum), this.maximum - this.visibleAmount)) != this.value) {
            this.value = n;
            this.setThumb();
            if (rectangle == null) {
                rectangle = this.thumb;
            }
            this.processEvent(new AdjustmentEvent(this, 601, this.adjustmentType, this.value));
        }
        if (rectangle != null) {
            this.drawThumb(rectangle);
        }
    }

    private final void setThumb() {
        Dimension dimension = this.getSize();
        int n = (this.orientation == 0 ? dimension.width : dimension.height) - 32;
        float f = (float)this.visibleAmount / (float)(this.maximum - this.minimum);
        int n2 = Math.max((int)((double)(f * (float)n) + 0.5), 8);
        int n3 = n - n2;
        float f2 = this.maximum - this.visibleAmount;
        float f3 = this.minimum;
        float f4 = ((float)this.value - f3) / (f2 - f3);
        int n4 = (int)(f4 * (float)n3);
        this.thumb = this.orientation == 0 ? new Rectangle(n4 + 16, 0, n2, dimension.height) : new Rectangle(0, n4 + 16, dimension.width, n2);
    }

    private final void setPageLimit(int n) {
        int n2;
        int n3;
        if (this.orientation == 0) {
            n3 = this.getSize().width - 32;
            n2 = this.thumb.width;
        } else {
            n3 = this.getSize().height - 32;
            n2 = this.thumb.height;
        }
        float f = this.maximum - this.visibleAmount;
        float f2 = this.minimum;
        float f3 = (f - f2) / (float)(n3 - n2);
        int n4 = (int)((double)((float)(n -= 16 + n2 / 2) * f3) + 0.5);
        this.pageLimit = Math.min(Math.max(n4, this.minimum), this.maximum);
    }

    private final void drawThumb() {
        this.drawThumb(this.thumb);
    }

    private final void drawThumb(Graphics graphics) {
        this.drawThumb(graphics, this.thumb);
    }

    private final void drawThumb(Rectangle rectangle) {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.drawThumb(graphics, rectangle);
            graphics.dispose();
        }
    }

    private final void drawThumb(Graphics graphics, Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        Color color = TRACK_COLOR;
        Color color2 = TRACK_COLOR;
        if (this.fPaging) {
            if (this.adjustmentType == 3) {
                color = Color.darkGray;
            } else {
                color2 = Color.darkGray;
            }
        }
        Dimension dimension = this.getSize();
        if (this.orientation == 0) {
            graphics.setColor(color);
            graphics.fillRect(16, 0, rectangle.x - 16, rectangle.height);
            n3 = rectangle.x + rectangle.width;
            graphics.setColor(color2);
            graphics.fillRect(n3, 0, dimension.width - 16 - n3, rectangle.height);
            n2 = dimension.width - 16 - 1;
            n = dimension.height - 1;
            graphics.setColor(Color.gray);
            graphics.drawLine(16, 0, n2, 0);
            graphics.drawLine(16, n, n2, n);
        } else {
            graphics.setColor(color);
            graphics.fillRect(0, 16, rectangle.width, rectangle.y - 16);
            n3 = rectangle.y + rectangle.height;
            graphics.setColor(color2);
            graphics.fillRect(0, n3, rectangle.width, dimension.height - 16 - n3);
            n2 = dimension.width - 1;
            n = dimension.height - 16 - 1;
            graphics.setColor(Color.gray);
            graphics.drawLine(0, 16, 0, n);
            graphics.drawLine(n2, 16, n2, n);
        }
        graphics.setColor(this.isEnabled() ? Color.lightGray : TRACK_COLOR);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        n3 = rectangle.x;
        n2 = rectangle.y;
        n = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        if (this.isEnabled()) {
            this.draw3DRect(graphics, n3, n2, n, n4, Color.lightGray, Color.black);
            this.draw3DRect(graphics, ++n3, ++n2, --n, --n4, Color.white, Color.gray);
        } else {
            this.draw3DRect(graphics, n3, n2, n, n4, Color.white, Color.gray);
        }
    }

    private final void draw3DRect(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2) {
        graphics.setColor(color);
        graphics.drawLine(n, --n4, n, n2);
        graphics.drawLine(n, n2, --n3, n2);
        graphics.setColor(color2);
        graphics.drawLine(n3, n2, n3, n4);
        graphics.drawLine(n3, n4, n, n4);
    }

    private final Polygon getArrow(int n, int n2, int n3) {
        Polygon polygon = new Polygon();
        if (this.orientation == 0) {
            polygon.addPoint(n, n2);
            polygon.addPoint(n + n3, n2 - n3);
            polygon.addPoint(n + n3, n2 + n3);
        } else {
            polygon.addPoint(n, n2);
            polygon.addPoint(n - n3, n2 + n3);
            polygon.addPoint(n + n3, n2 + n3);
        }
        return polygon;
    }
}

