/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.gde;

import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.gde.BeanBox;
import com.schneiderautomation.gde.BeanLoader;
import com.schneiderautomation.gde.ConfirmDialog;
import com.schneiderautomation.gde.GdeApplet;
import com.schneiderautomation.gde.GdeEditor;
import com.schneiderautomation.gde.GdeMsgArea;
import com.schneiderautomation.gde.GdeStrings;
import com.schneiderautomation.gde.ObjectDescriptor;
import com.schneiderautomation.gde.PaletteDescriptor;
import com.schneiderautomation.gde.Wrapper;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.IOException;

public class GdeTopPanel
extends Panel {
    static final Color panelBkgnd = new Color(233, 228, 223);
    static final String LIST_FILLER = "------------";
    private static GdeApplet applet;
    private GdeMsgArea statusOut;
    private CommBean comm;
    private static boolean fSymbolsOK;
    static TopCard topCard;
    private static SaveCard saveCard;
    private static DeleteCard delCard;
    private static PaletteCard paletteCard;
    private LayoutCard layoutCard;
    private OptionsCard optionsCard;
    private static PasswordCard pwCard;
    private CardLayout cards = new CardLayout(2, 2);
    public static boolean bWidgeterror;

    GdeTopPanel(GdeApplet gdeApplet, GdeMsgArea gdeMsgArea) {
        applet = gdeApplet;
        this.statusOut = gdeMsgArea;
        this.comm = gdeApplet.comm;
        topCard = new TopCard();
        saveCard = new SaveCard();
        delCard = new DeleteCard();
        paletteCard = new PaletteCard();
        this.layoutCard = new LayoutCard();
        this.optionsCard = new OptionsCard();
        pwCard = new PasswordCard();
        this.setBackground(panelBkgnd);
        this.setForeground(Color.black);
        this.setLayout(this.cards);
        this.add((Component)topCard, "TOP");
        this.add((Component)saveCard, "SAVE");
        this.add((Component)delCard, "DELETE");
        this.add((Component)paletteCard, "PALETTE");
        this.add((Component)this.layoutCard, "LAYOUT");
        this.add((Component)this.optionsCard, "OPTIONS");
        this.add((Component)pwCard, "PASSWORD");
        this.showTopCard();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = 0;
        int n2 = 0;
        int n3 = dimension.width - 1;
        int n4 = dimension.height - 1;
        graphics.setColor(Color.gray);
        graphics.drawLine(n, n4, n, n2);
        graphics.drawLine(n, n2, n3, n2);
        graphics.setColor(Color.white);
        graphics.drawLine(n3, n2, n3, n4);
        graphics.drawLine(n3, n4, n, n4);
        graphics.setColor(Color.black);
        graphics.drawLine(++n, --n4, n, ++n2);
        graphics.drawLine(n, n2, --n3, n2);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n3, n2, n3, n4);
        graphics.drawLine(n3, n4, n, n4);
    }

    void connect(boolean bl, boolean bl2) {
        Object[] objectArray;
        try {
            topCard.connect(bl);
        }
        catch (IOException iOException) {
            objectArray = new Object[]{iOException.getMessage()};
            this.statusOut.printErr(GdeStrings.getFormattedString("GDT_ERROR", objectArray));
        }
        try {
            pwCard.connect(bl2);
            GdeTopPanel.topCard.pwordButton.setEnabled(true);
        }
        catch (IOException iOException) {
            objectArray = new Object[]{iOException.getMessage()};
            this.statusOut.printErr(GdeStrings.getFormattedString("PASSWORD_ERROR", objectArray));
        }
    }

    void disconnect() {
        GdeTopPanel.topCard.pwordButton.setEnabled(false);
        pwCard.disconnect();
        topCard.disconnect();
    }

    void beanInitDone() {
        paletteCard.init();
        topCard.editButton.setEnabled(true);
    }

    void selectionChanged(int n) {
        this.layoutCard.alignLeftButton.setEnabled(n > 1);
        this.layoutCard.alignTopButton.setEnabled(n > 1);
        this.layoutCard.alignRightButton.setEnabled(n > 1);
        this.layoutCard.alignBottomButton.setEnabled(n > 1);
        this.layoutCard.alignHorzButton.setEnabled(n > 1);
        this.layoutCard.alignVertButton.setEnabled(n > 1);
        this.layoutCard.spaceHorzButton.setEnabled(n > 2);
        this.layoutCard.spaceVertButton.setEnabled(n > 2);
        this.layoutCard.matchWidthButton.setEnabled(n > 1);
        this.layoutCard.matchHeightButton.setEnabled(n > 1);
        paletteCard.cutButton.setEnabled(n > 0);
        paletteCard.copyButton.setEnabled(n > 0);
        this.showReferenceInfo();
    }

    void clearInsertBean() {
        GdeTopPanel.applet.idBeanInsert = -1;
        applet.setDefaultCursor();
        paletteCard.palette.idBeanMouseOver = -1;
        paletteCard.palette.repaint();
    }

    void setPasteEnabled(boolean bl) {
        paletteCard.pasteButton.setEnabled(bl);
    }

    void showProgramInfo(String string) {
        topCard.infoOut.setText(string);
    }

    void showReferenceInfo() {
        boolean bl = false;
        String string = "";
        Wrapper wrapper = GdeTopPanel.applet.editorPanel.bb.reference;
        if (wrapper != null) {
            Rectangle rectangle = wrapper.getBounds();
            string = wrapper.getBean().getName() + " (" + rectangle.width + " x " + rectangle.height + ")";
            bl = BeanLoader.getCustomizerClass(wrapper.getBean().getClass()) != null;
        }
        paletteCard.objInfo.setText(string);
        paletteCard.cstmButton.setEnabled(bl);
    }

    void setDisplay(String string) {
        topCard.setDisplay(string);
    }

    boolean loadDisplay(String string) {
        return topCard.loadDisplay(string);
    }

    void showTopCard() {
        this.cards.show(this, "TOP");
    }

    void showCard(String string) {
        this.cards.show(this, string);
    }

    static {
        bWidgeterror = false;
    }

    class PasswordCard
    extends Panel
    implements ActionListener {
        private String password;
        private TextField pwEntered = new TextField(16);
        private Button applyButton = new Button(GdeStrings.getString("OK_BTN_LBL"));
        private Button backButton = new Button(GdeStrings.getString("CANCEL_BTN_LBL"));

        PasswordCard() {
            this.pwEntered.addActionListener(this);
            this.applyButton.addActionListener(this);
            this.backButton.addActionListener(this);
            Label label = new Label(GdeStrings.getString("PASSWORD_PROMPT"));
            Panel panel = new Panel();
            panel.add(this.applyButton);
            panel.add(this.backButton);
            this.pwEntered.setEchoChar('*');
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(new GridBagLayout());
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = 0;
            this.add((Component)label, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            ++gridBagConstraints.gridx;
            this.add((Component)this.pwEntered, gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 2.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            this.add((Component)panel, gridBagConstraints);
        }

        void connect(boolean bl) throws IOException {
            if (bl) {
                applet.editorPanel.passwordEntered(true);
                topCard.passwordEntered(true);
            }
            this.password = applet.gdtFiles.getPassword();
        }

        void disconnect() {
            this.password = null;
            applet.editorPanel.passwordEntered(false);
            topCard.passwordEntered(false);
        }

        void display() {
            this.pwEntered.setText("");
            GdeTopPanel.this.showCard("PASSWORD");
            this.pwEntered.requestFocus();
        }

        public synchronized void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() != this.backButton && this.password != null) {
                boolean bl = this.password.equals(this.pwEntered.getText());
                applet.editorPanel.passwordEntered(bl);
                topCard.passwordEntered(bl);
                if (!bl) {
                    if (this.pwEntered.getText().length() > 0) {
                        GdeTopPanel.this.statusOut.printErr(GdeStrings.getString("PASSWORD_INVALID"));
                    } else {
                        GdeTopPanel.this.statusOut.printMsg(GdeStrings.getString("PASSWORD_CANCELLED"));
                    }
                } else {
                    GdeTopPanel.this.statusOut.printMsg(GdeStrings.getString("PASSWORD_OK"));
                }
            }
            GdeTopPanel.this.showTopCard();
            GdeTopPanel.topCard.pwordButton.requestFocus();
        }
    }

    class OptionsCard
    extends Panel
    implements ActionListener,
    TextListener {
        private final int MIN_GRID = 8;
        private final int MAX_GRID = 100;
        private Checkbox showGrid = new Checkbox(GdeStrings.getString("SHOW_GRID_BOX_LBL"));
        private Checkbox snapToGrid = new Checkbox(GdeStrings.getString("SNAP_GRID_BOX_LBL"));
        private Label widthLbl = new Label("", 2);
        private TextField widthInput = new TextField(6);
        private Label heightLbl = new Label("", 2);
        private TextField heightInput = new TextField(6);
        private Button applyButton = new Button(GdeStrings.getString("OK_BTN_LBL"));
        private Button backButton = new Button(GdeStrings.getString("CANCEL_BTN_LBL"));
        private boolean fHaveWidth;
        private boolean fHaveHeight;

        OptionsCard() {
            this.applyButton.addActionListener(this);
            this.backButton.addActionListener(this);
            this.widthInput.addTextListener(this);
            this.widthInput.addActionListener(this);
            this.heightInput.addTextListener(this);
            this.heightInput.addActionListener(this);
            Object[] objectArray = new Object[]{String.valueOf(8), String.valueOf(100)};
            this.widthLbl.setText(GdeStrings.getFormattedString("GRID_WIDTH_PROMPT", objectArray));
            this.heightLbl.setText(GdeStrings.getFormattedString("GRID_HEIGHT_PROMPT", objectArray));
            Panel panel = new Panel();
            panel.add(this.applyButton);
            panel.add(this.backButton);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.insets.left = 1;
            gridBagConstraints.insets.right = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.widthLbl, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)this.widthInput, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets.left = 15;
            this.add((Component)this.showGrid, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets.left = 4;
            this.add((Component)this.snapToGrid, gridBagConstraints);
            gridBagConstraints.insets.left = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            this.add((Component)this.heightLbl, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)this.heightInput, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets.left = 0;
            this.add((Component)panel, gridBagConstraints);
        }

        void display() {
            this.showGrid.setState(applet.editorPanel.fGrid);
            this.snapToGrid.setState(applet.editorPanel.fSnap);
            this.widthInput.setText(String.valueOf(applet.editorPanel.cxGrid));
            this.heightInput.setText(String.valueOf(applet.editorPanel.cyGrid));
            this.fHaveWidth = true;
            this.fHaveHeight = true;
            this.applyButton.setEnabled(true);
            GdeTopPanel.this.showCard("OPTIONS");
        }

        public void textValueChanged(TextEvent textEvent) {
            if (textEvent.getSource() == this.widthInput) {
                try {
                    int n = Integer.parseInt(this.widthInput.getText().trim());
                    this.fHaveWidth = n >= 8 && n <= 100;
                }
                catch (NumberFormatException numberFormatException) {
                    this.fHaveWidth = false;
                }
            } else if (textEvent.getSource() == this.heightInput) {
                try {
                    int n = Integer.parseInt(this.heightInput.getText().trim());
                    this.fHaveHeight = n >= 8 && n <= 100;
                }
                catch (NumberFormatException numberFormatException) {
                    this.fHaveHeight = false;
                }
            }
            this.applyButton.setEnabled(this.fHaveWidth && this.fHaveHeight);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() != this.backButton) {
                if (!this.applyButton.isEnabled()) {
                    return;
                }
                try {
                    int n = Integer.parseInt(this.widthInput.getText().trim());
                    int n2 = Integer.parseInt(this.heightInput.getText().trim());
                    boolean bl = n != applet.editorPanel.cxGrid || n2 != applet.editorPanel.cyGrid;
                    boolean bl2 = bl || applet.editorPanel.fGrid != this.showGrid.getState();
                    applet.editorPanel.cxGrid = n;
                    applet.editorPanel.cyGrid = n2;
                    applet.editorPanel.fGrid = this.showGrid.getState();
                    applet.editorPanel.fSnap = this.snapToGrid.getState();
                    if (bl) {
                        applet.editorPanel.bb.resetGrid();
                    }
                    if (bl2) {
                        applet.editorPanel.bb.repaint();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
            paletteCard.display();
        }
    }

    class LayoutCard
    extends Panel {
        private Label alignEdgesLbl = new Label(GdeStrings.getString("ALIGN_PROMPT"), 2);
        private Button alignLeftButton = new Button(GdeStrings.getString("LEFT_BTN_LBL"));
        private Button alignTopButton = new Button(GdeStrings.getString("TOP_BTN_LBL"));
        private Button alignRightButton = new Button(GdeStrings.getString("RIGHT_BTN_LBL"));
        private Button alignBottomButton = new Button(GdeStrings.getString("BOTTOM_BTN_LBL"));
        private Label alignCenterLbl = new Label(GdeStrings.getString("CENTER_PROMPT"), 2);
        private Button alignHorzButton = new Button(GdeStrings.getString("HORIZ_BTN_LBL"));
        private Button alignVertButton = new Button(GdeStrings.getString("VERT_BTN_LBL"));
        private Label spaceBeanLbl = new Label(GdeStrings.getString("SPACE_PROMPT"), 2);
        private Button spaceHorzButton = new Button(GdeStrings.getString("HORIZ_BTN_LBL"));
        private Button spaceVertButton = new Button(GdeStrings.getString("VERT_BTN_LBL"));
        private Label matchLbl = new Label(GdeStrings.getString("MATCH_PROMPT"), 2);
        private Button matchWidthButton = new Button(GdeStrings.getString("WIDTH_BTN_LBL"));
        private Button matchHeightButton = new Button(GdeStrings.getString("HEIGHT_BTN_LBL"));
        private Button doneButton = new Button(GdeStrings.getString("DONE_BTN_LBL"));

        LayoutCard() {
            this.alignLeftButton.setEnabled(false);
            this.alignTopButton.setEnabled(false);
            this.alignRightButton.setEnabled(false);
            this.alignBottomButton.setEnabled(false);
            this.alignVertButton.setEnabled(false);
            this.alignHorzButton.setEnabled(false);
            this.spaceHorzButton.setEnabled(false);
            this.spaceVertButton.setEnabled(false);
            this.matchWidthButton.setEnabled(false);
            this.matchHeightButton.setEnabled(false);
            this.alignLeftButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ LayoutCard this$1;
                {
                    this.this$1 = layoutCard;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    GdeTopPanel.access$2000().editorPanel.bb.alignLeft();
                }
            });
            this.alignTopButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ LayoutCard this$1;
                {
                    this.this$1 = layoutCard;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    GdeTopPanel.access$2000().editorPanel.bb.alignTop();
                }
            });
            this.alignRightButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ LayoutCard this$1;
                {
                    this.this$1 = layoutCard;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    GdeTopPanel.access$2000().editorPanel.bb.alignRight();
                }
            });
            this.alignBottomButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ LayoutCard this$1;
                {
                    this.this$1 = layoutCard;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    GdeTopPanel.access$2000().editorPanel.bb.alignBottom();
                }
            });
            this.alignHorzButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ LayoutCard this$1;
                {
                    this.this$1 = layoutCard;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    GdeTopPanel.access$2000().editorPanel.bb.alignCenter();
                }
            });
            this.alignVertButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ LayoutCard this$1;
                {
                    this.this$1 = layoutCard;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    GdeTopPanel.access$2000().editorPanel.bb.alignMiddle();
                }
            });
            this.spaceHorzButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ LayoutCard this$1;
                {
                    this.this$1 = layoutCard;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    GdeTopPanel.access$2000().editorPanel.bb.spaceHorz();
                }
            });
            this.spaceVertButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ LayoutCard this$1;
                {
                    this.this$1 = layoutCard;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    GdeTopPanel.access$2000().editorPanel.bb.spaceVert();
                }
            });
            this.matchWidthButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ LayoutCard this$1;
                {
                    this.this$1 = layoutCard;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    GdeTopPanel.access$2000().editorPanel.bb.matchWidth();
                }
            });
            this.matchHeightButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ LayoutCard this$1;
                {
                    this.this$1 = layoutCard;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    GdeTopPanel.access$2000().editorPanel.bb.matchHeight();
                }
            });
            this.doneButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ LayoutCard this$1;
                {
                    this.this$1 = layoutCard;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    GdeTopPanel.access$2300().display();
                }
            });
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.insets.left = 1;
            gridBagConstraints.insets.right = 1;
            gridBagConstraints.insets.top = 2;
            gridBagConstraints.insets.bottom = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.alignEdgesLbl, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)this.alignRightButton, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)this.alignBottomButton, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)this.alignLeftButton, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)this.alignTopButton, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets.left = 15;
            this.add((Component)this.spaceBeanLbl, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets.left = 1;
            this.add((Component)this.spaceHorzButton, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)this.spaceVertButton, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            this.add((Component)this.alignCenterLbl, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)this.alignHorzButton, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)this.alignVertButton, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridx = 5;
            gridBagConstraints.insets.left = 15;
            this.add((Component)this.matchLbl, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets.left = 1;
            this.add((Component)this.matchWidthButton, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)this.matchHeightButton, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets.left = 25;
            this.add((Component)this.doneButton, gridBagConstraints);
        }

        void display() {
            GdeTopPanel.this.showCard("LAYOUT");
        }
    }

    class PaletteCard
    extends Panel
    implements ActionListener,
    ItemListener {
        private final int imgSize = 32;
        private Choice palettes = new Choice();
        private Palette palette = new Palette();
        private Label objInfo = new Label();
        private Button propButton = new Button(GdeStrings.getString("PROP_BTN_LBL"));
        private Button cstmButton = new Button(GdeStrings.getString("CSTM_BTN_LBL"));
        private Button cutButton = new Button(GdeStrings.getString("CUT_BTN_LBL"));
        private Button copyButton = new Button(GdeStrings.getString("COPY_BTN_LBL"));
        private Button pasteButton = new Button(GdeStrings.getString("PASTE_BTN_LBL"));
        private Button layoutButton = new Button(GdeStrings.getString("LAYOUT_BTN_LBL"));
        private Button optButton = new Button(GdeStrings.getString("OPTIONS_BTN_LBL"));
        private Button doneButton = new Button(GdeStrings.getString("DONE_BTN_LBL"));

        PaletteCard() {
            this.cutButton.setEnabled(false);
            this.copyButton.setEnabled(false);
            this.pasteButton.setEnabled(false);
            this.cstmButton.setEnabled(false);
            this.propButton.addActionListener(new PropertyAdaptor());
            this.cstmButton.addActionListener(new CustomizerAdaptor());
            this.cutButton.addActionListener(new CutAdaptor());
            this.copyButton.addActionListener(new CopyAdaptor());
            this.pasteButton.addActionListener(new PasteAdaptor());
            this.optButton.addActionListener(new OptionsAdaptor());
            this.layoutButton.addActionListener(new LayoutAdaptor());
            this.doneButton.addActionListener(this);
            this.palettes.addItemListener(this);
            this.palettes.add("WWWWWWWW");
            this.objInfo.setBackground(Color.white);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.insets.left = 3;
            gridBagConstraints.insets.right = 3;
            gridBagConstraints.insets.top = 3;
            gridBagConstraints.insets.bottom = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            this.add((Component)this.palettes, gridBagConstraints);
            gridBagConstraints.gridwidth = 8;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            this.add((Component)this.palette, gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            this.add((Component)this.propButton, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            this.add((Component)this.cstmButton, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.ipady = -2;
            this.add((Component)this.objInfo, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 3;
            gridBagConstraints.ipady = 0;
            this.add((Component)this.cutButton, gridBagConstraints);
            gridBagConstraints.insets.left = 0;
            gridBagConstraints.gridx = 4;
            this.add((Component)this.copyButton, gridBagConstraints);
            gridBagConstraints.gridx = 5;
            this.add((Component)this.pasteButton, gridBagConstraints);
            gridBagConstraints.gridx = 6;
            this.add((Component)this.layoutButton, gridBagConstraints);
            gridBagConstraints.gridx = 7;
            this.add((Component)this.optButton, gridBagConstraints);
            gridBagConstraints.insets.left = 10;
            gridBagConstraints.gridx = 8;
            this.add((Component)this.doneButton, gridBagConstraints);
        }

        void init() {
            this.palettes.removeAll();
            for (int i = 0; i < applet.palettes.size(); ++i) {
                PaletteDescriptor paletteDescriptor = (PaletteDescriptor)applet.palettes.elementAt(i);
                this.palettes.addItem(paletteDescriptor.name);
            }
        }

        void display() {
            if (!applet.fEditMode) {
                applet.fEditMode = true;
                applet.editorPanel.bb.setUserInputEnabled(false);
                applet.editorPanel.editModeChanged();
                GdeTopPanel.this.comm.stop();
            }
            GdeTopPanel.this.showCard("PALETTE");
        }

        public void paint(Graphics graphics) {
            Rectangle rectangle = this.objInfo.getBounds();
            graphics.setColor(Color.gray);
            graphics.draw3DRect(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1, false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GdeTopPanel.this.clearInsertBean();
            applet.fEditMode = false;
            if (applet.ps != null) {
                applet.ps.dispose();
            }
            if (applet.cs != null) {
                applet.cs.dispose();
            }
            applet.editorPanel.bb.setCurrentComponent(null, true);
            applet.editorPanel.bb.setUserInputEnabled(applet.fPasswordOK);
            GdeTopPanel.this.comm.start();
            applet.editorPanel.editModeChanged();
            GdeTopPanel.this.showTopCard();
        }

        public synchronized void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                GdeTopPanel.this.clearInsertBean();
                applet.idPaletteInsert = this.palettes.getSelectedIndex();
                this.palette.repaint();
            }
        }

        class Palette
        extends Canvas
        implements MouseListener,
        MouseMotionListener {
            private Insets insets = new Insets(0, 0, 0, 0);
            private int idBeanMouseOver = -1;

            Palette() {
                this.setForeground(new Color(255, 255, 226));
                this.setBackground(Color.gray);
                this.setFont(new Font("SansSerif", 0, 10));
                this.addMouseListener(this);
                this.addMouseMotionListener(this);
            }

            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }

            public Dimension getMinimumSize() {
                return new Dimension(this.insets.left + this.insets.right, 32 + this.insets.top + this.insets.bottom);
            }

            public void update(Graphics graphics) {
                this.paint(graphics);
            }

            public void paint(Graphics graphics) {
                PaletteDescriptor paletteDescriptor = (PaletteDescriptor)applet.palettes.elementAt(applet.idPaletteInsert);
                int n = this.insets.left;
                for (int i = 0; i < paletteDescriptor.objects.size(); ++i) {
                    ObjectDescriptor objectDescriptor = (ObjectDescriptor)paletteDescriptor.objects.elementAt(i);
                    if (objectDescriptor.icon != null) {
                        graphics.drawImage(objectDescriptor.icon, n, this.insets.top, 32, 32, Color.white, this);
                    }
                    n += 32;
                }
                Dimension dimension = this.getSize();
                int n2 = dimension.width - n - this.insets.right;
                if (n2 > 0) {
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(n, this.insets.top, n2, dimension.height - this.insets.top - this.insets.bottom);
                }
                if (this.idBeanMouseOver >= 0) {
                    ObjectDescriptor objectDescriptor = (ObjectDescriptor)paletteDescriptor.objects.elementAt(this.idBeanMouseOver);
                    Font font = this.getFont();
                    FontMetrics fontMetrics = graphics.getFontMetrics(font);
                    int n3 = this.idBeanMouseOver * 32 + this.insets.left;
                    int n4 = this.insets.top;
                    int n5 = fontMetrics.stringWidth(objectDescriptor.label) + 4;
                    int n6 = fontMetrics.getAscent() + fontMetrics.getDescent() + 2;
                    int n7 = dimension.width - this.insets.right;
                    if (n3 + n5 > n7) {
                        n3 = n7 - n5;
                    }
                    graphics.setColor(applet.idBeanInsert < 0 ? this.getForeground() : Color.yellow);
                    graphics.fillRect(n3, n4, n5, n6);
                    graphics.setFont(font);
                    graphics.setColor(Color.black);
                    graphics.drawString(objectDescriptor.label, n3 + 2, n4 + 1 + fontMetrics.getAscent());
                    graphics.drawRect(n3, n4, n5 - 1, n6 - 1);
                }
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                if (applet.idBeanInsert < 0) {
                    int n = (mouseEvent.getX() - this.insets.left) / 32;
                    PaletteDescriptor paletteDescriptor = (PaletteDescriptor)applet.palettes.elementAt(applet.idPaletteInsert);
                    if (n >= paletteDescriptor.objects.size()) {
                        n = -1;
                    }
                    if (n != this.idBeanMouseOver) {
                        this.idBeanMouseOver = n;
                        this.repaint();
                    }
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (applet.idBeanInsert < 0 && this.idBeanMouseOver >= 0) {
                    this.idBeanMouseOver = -1;
                    this.repaint();
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                int n = (mouseEvent.getX() - this.insets.left) / 32;
                PaletteDescriptor paletteDescriptor = (PaletteDescriptor)applet.palettes.elementAt(applet.idPaletteInsert);
                if (n >= 0 && n < paletteDescriptor.objects.size()) {
                    if (n == applet.idBeanInsert) {
                        applet.idBeanInsert = -1;
                        applet.setDefaultCursor();
                    } else {
                        applet.idBeanInsert = n;
                        GdeTopPanel.this.setCursor(GdeEditor.INSERT_CURSOR);
                    }
                    this.idBeanMouseOver = n;
                    this.repaint();
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
            }
        }

        class OptionsAdaptor
        implements ActionListener {
            OptionsAdaptor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TopCard topCard = GdeTopPanel.topCard;
                synchronized (topCard) {
                    GdeTopPanel.this.clearInsertBean();
                    GdeTopPanel.this.optionsCard.display();
                }
            }
        }

        class LayoutAdaptor
        implements ActionListener {
            LayoutAdaptor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TopCard topCard = GdeTopPanel.topCard;
                synchronized (topCard) {
                    GdeTopPanel.this.clearInsertBean();
                    GdeTopPanel.this.layoutCard.display();
                }
            }
        }

        class PasteAdaptor
        implements ActionListener {
            PasteAdaptor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TopCard topCard = GdeTopPanel.topCard;
                synchronized (topCard) {
                    applet.editorPanel.bb.paste();
                }
            }
        }

        class CopyAdaptor
        implements ActionListener {
            CopyAdaptor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TopCard topCard = GdeTopPanel.topCard;
                synchronized (topCard) {
                    applet.editorPanel.bb.copySelected();
                }
            }
        }

        class CutAdaptor
        implements ActionListener {
            CutAdaptor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TopCard topCard = GdeTopPanel.topCard;
                synchronized (topCard) {
                    applet.editorPanel.bb.cutSelected();
                }
            }
        }

        class CustomizerAdaptor
        implements ActionListener {
            CustomizerAdaptor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TopCard topCard = GdeTopPanel.topCard;
                synchronized (topCard) {
                    applet.showCustomizer();
                }
            }
        }

        class PropertyAdaptor
        implements ActionListener {
            PropertyAdaptor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TopCard topCard = GdeTopPanel.topCard;
                synchronized (topCard) {
                    applet.showPropertySheet();
                }
            }
        }
    }

    class DeleteCard
    extends Panel
    implements ActionListener {
        private String gdt;
        private Label confirmLbl = new Label();
        private Button applyButton = new Button(GdeStrings.getString("YES_BTN_LBL"));
        private Button backButton = new Button(GdeStrings.getString("NO_BTN_LBL"));

        DeleteCard() {
            this.applyButton.addActionListener(this);
            this.backButton.addActionListener(this);
            this.confirmLbl.setAlignment(1);
            Panel panel = new Panel();
            panel.add(this.applyButton);
            panel.add(this.backButton);
            this.setLayout(new GridLayout(2, 1));
            this.add(this.confirmLbl);
            this.add(panel);
        }

        void display(String string) {
            this.gdt = string;
            Object[] objectArray = new Object[]{string};
            this.confirmLbl.setText(GdeStrings.getFormattedString("DELETE_PROMPT", objectArray));
            GdeTopPanel.this.showCard("DELETE");
            this.applyButton.requestFocus();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.applyButton) {
                applet.setWaitCursor();
                GdeTopPanel.this.comm.stop();
                try {
                    applet.gdtFiles.delete(this.gdt);
                    topCard.refresh(null);
                    applet.editorPanel.loadDisplay(null);
                }
                catch (IOException iOException) {
                    Object[] objectArray = new Object[]{this.gdt, iOException.getMessage()};
                    GdeTopPanel.this.statusOut.printErr(GdeStrings.getFormattedString("DELETE_ERROR", objectArray));
                }
                finally {
                    GdeTopPanel.this.comm.start();
                    applet.setDefaultCursor();
                }
            }
            GdeTopPanel.this.showTopCard();
            topCard.deleteButton.requestFocus();
        }
    }

    class SaveCard
    extends Panel
    implements ActionListener,
    TextListener {
        private final String LEGAL_START = "abcdefghijklmnopqrstuvwxyz";
        private final String LEGAL_OTHER = "0123456789_$-";
        private final int MAX_LEN = 8;
        private String oldGdtName;
        private TextField nameEntered = new TextField(12);
        private Button applyButton = new Button(GdeStrings.getString("OK_BTN_LBL"));
        private Button backButton = new Button(GdeStrings.getString("CANCEL_BTN_LBL"));

        SaveCard() {
            this.applyButton.addActionListener(this);
            this.backButton.addActionListener(this);
            this.nameEntered.addActionListener(this);
            this.nameEntered.addTextListener(this);
            this.nameEntered.addKeyListener(new NameFilter());
            Label label = new Label(GdeStrings.getString("NAME_PROMPT"));
            Panel panel = new Panel();
            panel.add(this.applyButton);
            panel.add(this.backButton);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(new GridBagLayout());
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = 0;
            this.add((Component)label, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            ++gridBagConstraints.gridx;
            this.add((Component)this.nameEntered, gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 2.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            this.add((Component)panel, gridBagConstraints);
        }

        void display(String string) {
            this.oldGdtName = string;
            this.nameEntered.setText(this.oldGdtName);
            GdeTopPanel.this.showCard("SAVE");
            if (string.length() > 0) {
                this.applyButton.requestFocus();
                this.applyButton.setEnabled(true);
            } else {
                this.nameEntered.requestFocus();
                this.applyButton.setEnabled(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() != this.backButton) {
                if (!this.applyButton.isEnabled()) {
                    return;
                }
                applet.setWaitCursor();
                GdeTopPanel.this.comm.stop();
                this.applyButton.setEnabled(false);
                String string = this.nameEntered.getText();
                try {
                    BeanBox beanBox = applet.editorPanel.bb;
                    try {
                        beanBox.disconnect();
                        applet.gdtFiles.put(string, beanBox);
                        Object var5_5 = null;
                        beanBox.connect(applet, applet.editorPanel, GdeTopPanel.this.statusOut);
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        beanBox.connect(applet, applet.editorPanel, GdeTopPanel.this.statusOut);
                        throw throwable;
                    }
                    if (!string.equals(this.oldGdtName)) {
                        topCard.refresh(string);
                    }
                }
                catch (IOException iOException) {
                    Object[] objectArray = new Object[]{string, iOException.getMessage()};
                    GdeTopPanel.this.statusOut.printErr(GdeStrings.getFormattedString("SAVE_ERROR", objectArray));
                }
                finally {
                    GdeTopPanel.this.comm.start();
                    applet.setDefaultCursor();
                }
                applet.fModified = false;
            }
            GdeTopPanel.this.showTopCard();
            GdeTopPanel.topCard.saveButton.requestFocus();
        }

        public void textValueChanged(TextEvent textEvent) {
            char c;
            boolean bl = false;
            String string = this.nameEntered.getText();
            if (string.length() > 0 && string.length() <= 8 && "abcdefghijklmnopqrstuvwxyz".indexOf(c = Character.toLowerCase(string.charAt(0))) >= 0) {
                bl = true;
                for (int i = 1; i < string.length(); ++i) {
                    c = Character.toLowerCase(string.charAt(i));
                    if ("abcdefghijklmnopqrstuvwxyz".indexOf(c) >= 0 || "0123456789_$-".indexOf(c) >= 0) continue;
                    bl = false;
                    break;
                }
            }
            this.applyButton.setEnabled(bl);
        }

        class NameFilter
        extends KeyAdapter {
            NameFilter() {
            }

            public void keyTyped(KeyEvent keyEvent) {
                char c = Character.toLowerCase(keyEvent.getKeyChar());
                if (c == '\t' || c == '\b') {
                    return;
                }
                if (SaveCard.this.nameEntered.getText().length() >= 8 && SaveCard.this.nameEntered.getSelectedText().length() == 0) {
                    keyEvent.consume();
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                if ("abcdefghijklmnopqrstuvwxyz".indexOf(c) < 0 && "0123456789_$-".indexOf(c) < 0) {
                    keyEvent.consume();
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
        }
    }

    public class TopCard
    extends Panel
    implements ItemListener {
        public final String NEW_GDT = GdeStrings.getString("GDT_NEW_ITEM");
        public Choice gdtList = new Choice();
        public Button saveButton = new Button(GdeStrings.getString("SAVE_BTN_LBL"));
        private Button deleteButton = new Button(GdeStrings.getString("DELETE_BTN_LBL"));
        private Button editButton = new Button(GdeStrings.getString("EDIT_BTN_LBL"));
        public Button pwordButton = new Button(GdeStrings.getString("PWORD_BTN_LBL"));
        private Label infoOut = new Label();
        public String current = this.NEW_GDT;

        TopCard() {
            this.saveButton.addActionListener(new SaveAdaptor());
            this.deleteButton.addActionListener(new DeleteAdaptor());
            this.editButton.addActionListener(new EditAdaptor());
            this.pwordButton.addActionListener(new PWordAdaptor());
            this.saveButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.pwordButton.setEnabled(false);
            this.gdtList.addItemListener(this);
            this.gdtList.setEnabled(false);
            this.gdtList.add("");
            this.gdtList.add("WWWWWWWW");
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets.left = 3;
            gridBagConstraints.insets.right = 3;
            gridBagConstraints.insets.top = 4;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.gdtList, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)this.saveButton, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)this.deleteButton, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)this.editButton, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)this.pwordButton, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridwidth = 6;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            this.add((Component)this.infoOut, gridBagConstraints);
        }

        synchronized void connect(boolean bl) throws IOException {
            fSymbolsOK = bl;
            this.refresh(null);
        }

        synchronized void disconnect() {
            this.gdtList.setEnabled(false);
            this.gdtList.removeAll();
            fSymbolsOK = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void refresh(String string) throws IOException {
            this.deleteButton.setEnabled(false);
            this.gdtList.setEnabled(false);
            this.gdtList.removeAll();
            this.gdtList.add(this.NEW_GDT);
            try {
                String[] stringArray = applet.gdtFiles.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.gdtList.add(stringArray[i]);
                }
            }
            finally {
                this.gdtList.setEnabled(true);
            }
            if (string != null) {
                this.gdtList.select(string);
                this.deleteButton.setEnabled(applet.fPasswordOK);
            }
            this.current = this.gdtList.getSelectedItem();
        }

        synchronized void setDisplay(String string) {
            this.gdtList.select(string);
            this.current = string;
            this.deleteButton.setEnabled(applet.fPasswordOK && !this.gdtList.getSelectedItem().equals(this.NEW_GDT));
        }

        synchronized void passwordEntered(boolean bl) {
            applet.fPasswordOK = bl;
            this.saveButton.setEnabled(applet.fPasswordOK);
            this.deleteButton.setEnabled(applet.fPasswordOK && !this.gdtList.getSelectedItem().equals(this.NEW_GDT));
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                applet.loadDisplay(this.gdtList.getSelectedItem());
            }
        }

        boolean loadDisplay(String string) {
            if (applet.fModified) {
                Container container = this.getParent();
                while (!(container instanceof Frame)) {
                    container = ((Component)container).getParent();
                }
                ConfirmDialog confirmDialog = new ConfirmDialog((Frame)container, this.current);
                if (!confirmDialog.isYes()) {
                    this.gdtList.select(this.current);
                    return false;
                }
            }
            this.current = string;
            this.gdtList.select(this.current);
            if (this.current.equals(this.NEW_GDT)) {
                this.deleteButton.setEnabled(false);
                applet.editorPanel.loadDisplay(null);
                return false;
            }
            this.deleteButton.setEnabled(applet.fPasswordOK);
            return true;
        }

        class PWordAdaptor
        implements ActionListener {
            PWordAdaptor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TopCard topCard = GdeTopPanel.topCard;
                synchronized (topCard) {
                    pwCard.display();
                }
            }
        }

        class EditAdaptor
        implements ActionListener {
            EditAdaptor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TopCard topCard = GdeTopPanel.topCard;
                synchronized (topCard) {
                    paletteCard.display();
                    bWidgeterror = false;
                    int n = applet.getSize().width;
                    int n2 = applet.getSize().height;
                    applet.resize(n + 1, n2 + 1);
                    applet.resize(n, n2);
                }
            }
        }

        class DeleteAdaptor
        implements ActionListener {
            DeleteAdaptor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TopCard topCard = GdeTopPanel.topCard;
                synchronized (topCard) {
                    delCard.display(TopCard.this.gdtList.getSelectedItem());
                }
            }
        }

        class SaveAdaptor
        implements ActionListener {
            SaveAdaptor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TopCard topCard = GdeTopPanel.topCard;
                synchronized (topCard) {
                    String string = TopCard.this.gdtList.getSelectedItem();
                    saveCard.display(string.equals(TopCard.this.NEW_GDT) ? "" : string);
                }
            }
        }
    }
}

