/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.gde;

import com.schneiderautomation.factorycast.AppletColorTable;
import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.factorycast.LiveLabelMgrApplet;
import com.schneiderautomation.gde.BeanLoader;
import com.schneiderautomation.gde.ErrorHandler;
import com.schneiderautomation.gde.GdePropertyEditorManager;
import com.schneiderautomation.gde.GdeStrings;
import com.schneiderautomation.gde.LiveBeanMgrApplet;
import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.misc.GlobalConfig;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class LiveBeanApplet
extends Applet {
    private static final Object[] ZERO_ARGS = new Object[0];
    private LiveBeanMgrApplet mgr;
    private String libName;
    private String beanName;
    private Color background;
    private CommBean comm;
    private Wrapper wrapper;

    public void init() {
        Color color;
        GlobalConfig.setLanguage((String)this.getParameter("Language"));
        this.setLocale(GlobalConfig.getLocale());
        this.setLayout(null);
        GdeStrings.init(this.getLocale());
        String string = this.getParameter("LIBRARY");
        this.libName = string != null ? string : "<?>";
        string = this.getParameter("BEAN");
        this.beanName = string != null ? string : "<?>";
        string = this.getParameter("BACKGRND");
        if (string != null && (color = AppletColorTable.lookupColor((String)string)) != null) {
            this.setBackground(color);
        }
        this.background = this.getBackground();
    }

    public void start() {
        this.mgr = this.findCommMgr();
        if (this.mgr == null) {
            if (this.wrapper != null) {
                this.wrapper.setErrorStatus(true);
            }
            this.setBackground(Color.magenta);
            this.repaint();
            return;
        }
        CommBean commBean = this.mgr.getCommBean();
        if (this.comm == commBean && this.wrapper != null) {
            this.wrapper.setErrorStatus(this.wrapper.getGraphicalObject().isErrorStatus());
            this.setBackground(this.background);
            this.repaint();
            return;
        }
        this.comm = commBean;
        if (this.wrapper != null) {
            this.wrapper.disconnect();
            this.wrapper.connect(this.comm);
        } else {
            this.wrapper = this.mgr.getInstance(this.libName, this.beanName);
            if (this.wrapper != null) {
                this.setBeanProperties();
                int n = Math.max(0, (this.getSize().width - this.wrapper.getSize().width) / 2);
                int n2 = Math.max(0, (this.getSize().height - this.wrapper.getSize().height) / 2);
                this.wrapper.setLocation(n, n2);
                this.wrapper.setUserInputEnabled(true);
                this.add(this.wrapper);
                this.wrapper.connect(this.comm);
                this.wrapper.setUserInputEnabled(this.mgr.isPasswordOK());
            } else {
                Object[] objectArray = new Object[]{this.libName, this.beanName};
                String string = GdeStrings.getFormattedString("INSTANCE_ERROR", objectArray);
                ErrorHandler.report(string);
            }
        }
        this.mgr.addPasswordListener(this);
        this.mgr.clientModified();
        this.setBackground(this.background);
        this.repaint();
    }

    public void destroy() {
        if (this.mgr != null) {
            this.mgr.removePasswordListener(this);
        }
        super.destroy();
    }

    void passwordEntered(boolean bl) {
        this.wrapper.setUserInputEnabled(bl);
    }

    private void setBeanProperties() {
        String string = this.getParameter("PROPERTIES");
        if (string == null) {
            return;
        }
        Component component = this.wrapper.getBean();
        BeanInfo beanInfo = BeanLoader.getBeanInfo(component.getClass());
        if (beanInfo == null) {
            return;
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        if (propertyDescriptorArray == null || propertyDescriptorArray.length == 0) {
            System.err.println("No properties for " + component.getName());
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            Object[] objectArray;
            Object[] objectArray2;
            Object object;
            Object object2;
            Object[] objectArray3;
            String string2;
            String string3;
            String string4 = stringTokenizer.nextToken();
            try {
                int n = string4.indexOf("=");
                string3 = string4.substring(0, n).trim();
                string2 = string4.substring(n + 1).trim();
            }
            catch (Exception exception) {
                objectArray3 = new Object[]{string4};
                object2 = GdeStrings.getFormattedString("INVALID_TOKEN_ERROR", objectArray3);
                ErrorHandler.report(this.libName, this.beanName, (String)object2);
                continue;
            }
            PropertyDescriptor propertyDescriptor = null;
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                if (!string3.equals(propertyDescriptorArray[i].getName())) continue;
                propertyDescriptor = propertyDescriptorArray[i];
                break;
            }
            if (propertyDescriptor == null) {
                objectArray3 = new Object[]{string3};
                object2 = GdeStrings.getFormattedString("NO_SUCH_PROPERTY_ERROR", objectArray3);
                ErrorHandler.report(this.libName, this.beanName, (String)object2);
                continue;
            }
            objectArray3 = propertyDescriptor.getReadMethod();
            object2 = propertyDescriptor.getWriteMethod();
            if (objectArray3 == null || object2 == null) {
                object = new Object[]{string3};
                objectArray2 = GdeStrings.getFormattedString("INVALID_PROPERTY_ERROR", (Object[])object);
                ErrorHandler.report(this.libName, this.beanName, (String)objectArray2);
                continue;
            }
            try {
                String string5;
                object = null;
                objectArray2 = propertyDescriptor.getPropertyEditorClass();
                if (objectArray2 != null) {
                    try {
                        object = (PropertyEditor)objectArray2.newInstance();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (object == null) {
                    objectArray = propertyDescriptor.getPropertyType();
                    object = GdePropertyEditorManager.findEditor(objectArray);
                }
                if (object == null) {
                    objectArray = new Object[]{string3};
                    string5 = GdeStrings.getFormattedString("NO_EDITOR_ERROR", objectArray);
                    ErrorHandler.report(this.libName, this.beanName, string5);
                    continue;
                }
                object.setValue(objectArray3.invoke((Object)component, ZERO_ARGS));
                if (object.getAsText() == null) {
                    objectArray = new Object[]{string3};
                    string5 = GdeStrings.getFormattedString("NO_TEXTEDIT_ERROR", objectArray);
                    ErrorHandler.report(this.libName, this.beanName, string5);
                    continue;
                }
                object.setAsText(string2);
                objectArray = new Object[]{object.getValue()};
                ((Method)object2).invoke((Object)component, objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                objectArray2 = new Object[]{string2, string3};
                objectArray = GdeStrings.getFormattedString("ILLEGAL_VALUE_ERROR", objectArray2);
                ErrorHandler.report(this.libName, this.beanName, (String)objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("Skipping property " + string3 + ".  IllegalAccessException: " + illegalAccessException);
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                objectArray2 = invocationTargetException.getTargetException();
                System.err.println("Skipping property " + string3 + ".  Exception on target: " + objectArray2);
                objectArray2.printStackTrace();
            }
            catch (Exception exception) {
                System.err.println("Skipping property " + string3 + ".  Exception: " + exception);
                exception.printStackTrace();
            }
        }
    }

    private LiveBeanMgrApplet findCommMgr() {
        String string = this.getParameter("GLOBAL_COMM_MGR");
        boolean bl = string != null ? string.equalsIgnoreCase("TRUE") : false;
        LiveLabelMgrApplet liveLabelMgrApplet = LiveLabelMgrApplet.findCommMgr((AppletContext)(bl ? null : this.getAppletContext()));
        if (liveLabelMgrApplet instanceof LiveBeanMgrApplet) {
            return (LiveBeanMgrApplet)liveLabelMgrApplet;
        }
        ErrorHandler.report(this.libName, this.beanName, GdeStrings.getString("NO_MGR_ERROR"));
        return null;
    }
}

