/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.gde;

import com.schneiderautomation.gde.GdeTopPanel;
import com.schneiderautomation.gde.PropertySheet;
import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.namespace.VarLookupInterface;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class PropertySheetPanel
extends Panel
implements PropertyChangeListener {
    private static final Object[] ZERO_ARGS = new Object[0];
    private Frame parent;
    private PropertySheet ps;
    private VarLookupInterface varLookup;
    private Component target;
    private PropertyDescriptor[] properties;
    private PropertyEditor[] editors;
    private Object[] values;
    private Component[] views;
    private Insets insets = new Insets(4, 4, 4, 4);
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints labelConstraints = new GridBagConstraints();
    private GridBagConstraints viewConstraints = new GridBagConstraints();

    PropertySheetPanel(Frame frame, PropertySheet propertySheet, VarLookupInterface varLookupInterface) {
        this.parent = frame;
        this.ps = propertySheet;
        this.varLookup = varLookupInterface;
        this.labelConstraints.gridx = 0;
        this.labelConstraints.gridwidth = 1;
        this.labelConstraints.gridheight = 1;
        this.labelConstraints.anchor = 17;
        this.labelConstraints.fill = 2;
        this.labelConstraints.insets.bottom = 4;
        this.viewConstraints.gridx = 1;
        this.viewConstraints.gridwidth = 1;
        this.viewConstraints.gridheight = 1;
        this.viewConstraints.anchor = 17;
        this.viewConstraints.fill = 1;
        this.viewConstraints.insets.bottom = 4;
        this.viewConstraints.weightx = 1.0;
        this.setBackground(GdeTopPanel.panelBkgnd);
        this.setLayout(this.layout);
    }

    public final Insets getInsets() {
        return this.insets;
    }

    synchronized void refresh() {
        if (this.properties == null) {
            return;
        }
        for (int i = 0; i < this.properties.length; ++i) {
            Object object;
            if (this.views[i] == null) continue;
            try {
                Method method = this.properties[i].getReadMethod();
                object = method.invoke((Object)this.target, ZERO_ARGS);
                if (object == null || object.equals(this.values[i])) continue;
                this.values[i] = object;
                this.editors[i].setValue(object);
                this.views[i].repaint();
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                object = invocationTargetException.getTargetException();
                System.err.println("Unexpected exception while reading " + this.properties[i].getName() + ".  Exception on target: " + object);
                continue;
            }
            catch (Exception exception) {
                System.err.println("Unexpected exception while reading " + this.properties[i].getName() + ".  Exception: " + exception);
            }
        }
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray;
        Object object;
        PropertyEditor propertyEditor = (PropertyEditor)propertyChangeEvent.getSource();
        for (int i = 0; i < this.editors.length; ++i) {
            if (this.editors[i] != propertyEditor) continue;
            PropertyDescriptor propertyDescriptor = this.properties[i];
            try {
                object = propertyEditor.getValue();
                if (object.equals(this.values[i])) {
                    return;
                }
                objectArray = new Object[]{object};
                propertyDescriptor.getWriteMethod().invoke((Object)this.target, objectArray);
                this.values[i] = object;
                this.ps.notifyModified();
            }
            catch (InvocationTargetException invocationTargetException) {
                objectArray = invocationTargetException.getTargetException();
                if (objectArray instanceof PropertyVetoException) {
                    System.out.println("Warning: Update vetoed for " + propertyDescriptor.getName());
                    System.out.println("    " + objectArray.getMessage());
                } else {
                    System.err.println("Unexpected exception while updating " + propertyDescriptor.getName() + ".  Exception on target: " + objectArray);
                }
            }
            catch (Exception exception) {
                System.err.println("Unexpected exception while updating " + propertyDescriptor.getName() + ".  Exception: " + exception);
            }
            this.views[i].repaint();
            break;
        }
        if (this.target.getParent() instanceof Wrapper) {
            Wrapper wrapper = (Wrapper)this.target.getParent();
            this.target.invalidate();
            int n = Wrapper.BORDER_WIDTH;
            object = this.target.getMinimumSize();
            if (((Dimension)object).width < n) {
                ((Dimension)object).width = n;
            }
            if (((Dimension)object).height < n) {
                ((Dimension)object).height = n;
            }
            objectArray = this.target.getSize();
            if (objectArray.width < ((Dimension)object).width) {
                objectArray.width = ((Dimension)object).width;
            }
            if (objectArray.height < ((Dimension)object).height) {
                objectArray.height = ((Dimension)object).height;
            }
            wrapper.setSize(objectArray.width + Wrapper.BORDER_WIDTH_X2, objectArray.height + Wrapper.BORDER_WIDTH_X2);
            this.target.repaint();
        }
        this.refresh();
    }
}

