/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.sysdiag.qbf;

import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.factorycast.GetUInt;
import com.schneiderautomation.factorycast.comm.xbf.ENetStats;
import com.schneiderautomation.sysdiag.qbf.ConfigExtension;
import com.schneiderautomation.sysdiag.qbf.EnetApplet;
import com.schneiderautomation.sysdiag.qbf.EnetStrings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.net.InetAddress;
import java.net.UnknownHostException;

class EnetPanel
extends Panel {
    private static final Font f1 = new Font("Dialog", 1, 12);
    private static final Color lightGray = new Color(226, 226, 226);
    private CommBean comm;
    private EnetApplet applet;
    private TextField status;
    private TextField reference;
    private TextField rack;
    private TextField slot;
    private TextField xmitspeed;
    private TextField hostname;
    private TextField macaddress;
    private TextField ipaddress;
    private TextField subnetmask;
    private TextField gateway;

    EnetPanel(CommBean commBean, EnetApplet enetApplet, String string) {
        this.comm = commBean;
        this.applet = enetApplet;
        this.status = this.newTextField();
        this.reference = this.newTextField();
        this.rack = this.newTextField();
        this.slot = this.newTextField();
        this.xmitspeed = this.newTextField();
        this.hostname = this.newTextField();
        this.macaddress = this.newTextField();
        this.ipaddress = this.newTextField();
        this.subnetmask = this.newTextField();
        this.gateway = this.newTextField();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.newLabel("STATUS"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.newLabel("REFERENCE"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.newLabel("RACK"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.newLabel("SLOT"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.newLabel("XMITSPD"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.status, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.reference, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.rack, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.slot, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.xmitspeed, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)new Label(), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.newLabel("HOST"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.newLabel("MAC"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.newLabel("IP"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.newLabel("MASK"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.newLabel("GATEWAY"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.hostname, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.macaddress, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.ipaddress, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.subnetmask, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.gateway, gridBagConstraints);
        ++gridBagConstraints.gridy;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            this.ipaddress.setForeground(Color.black);
            this.ipaddress.setText(inetAddress.getHostAddress());
            this.hostname.setForeground(Color.black);
            this.hostname.setText(inetAddress.getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            this.ipaddress.setForeground(Color.magenta);
            this.ipaddress.setText(EnetStrings.getString("UNKNOWN"));
            this.hostname.setForeground(Color.magenta);
            this.hostname.setText(string);
        }
    }

    void refresh(ENetStats eNetStats, boolean bl, boolean bl2) {
        Object object;
        boolean bl3;
        short s = eNetStats.moduleStatus;
        int n = (s & 0xFF) >> 4;
        boolean bl4 = bl3 = n == 3 || n == 7 || n == 10 || n == 11 || n == 12 || n == 13;
        if ((s & 1) != 0) {
            object = EnetStrings.getString("RUNNING");
            if (n == 0 || bl3) {
                if ((s & 0x8000) != 0) {
                    object = ((String)object).concat(EnetStrings.getString("LINK"));
                }
                if ((s & 0x4000) != 0) {
                    object = ((String)object).concat(EnetStrings.getString("APPL"));
                }
            }
            this.status.setText((String)object);
            this.status.setForeground(bl ? Color.magenta : Color.green.darker());
        } else {
            this.status.setText(EnetStrings.getString("STOPPED"));
            this.status.setForeground(bl ? Color.magenta : Color.red);
        }
        object = bl ? Color.magenta : Color.black;
        this.reference.setForeground((Color)object);
        switch (n) {
            case 0: {
                this.reference.setText("140 NOE 211 10");
                break;
            }
            case 3: {
                this.reference.setText("140 NOE 771 00");
                break;
            }
            case 7: {
                this.reference.setText("Ethernet Link");
                break;
            }
            case 10: {
                this.reference.setText("140 NOE 771 10");
                break;
            }
            case 11: {
                this.reference.setText("140 NOE 771 01");
                break;
            }
            case 12: {
                this.reference.setText("140 NOE 771 11");
                break;
            }
            case 13: {
                this.reference.setText("140 NWM 100 00");
                break;
            }
            default: {
                this.reference.setText("140 NOE xxx xx");
            }
        }
        this.xmitspeed.setForeground((Color)object);
        if ((s & 0x1000) != 0 && bl3) {
            this.xmitspeed.setText("100 MB");
        } else {
            this.xmitspeed.setText("10 MB");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < eNetStats.macAddress.length; ++i) {
            String string = Integer.toHexString(eNetStats.macAddress[i]);
            if (string.length() == 1) {
                string = "0" + string;
            }
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        this.macaddress.setForeground((Color)object);
        this.macaddress.setText(stringBuffer.toString());
        if (bl2) {
            this.rack.setText("1");
            if (n == 7) {
                this.refreshCoproConfig();
            } else {
                short[] sArray = eNetStats.ipAddress;
                this.refreshConfig(sArray[3] + "." + sArray[2] + "." + sArray[1] + "." + sArray[0]);
            }
        }
    }

    private void refreshCoproConfig() {
        block5: {
            this.slot.setText("");
            this.subnetmask.setText(EnetStrings.getString("UNKNOWN"));
            this.gateway.setText(EnetStrings.getString("UNKNOWN"));
            GetUInt getUInt = new GetUInt(this.comm.getServer());
            try {
                int n;
                getUInt.setAddress("800049");
                getUInt.setQuantity((short)1);
                getUInt.readValues();
                int n2 = getUInt.getValue();
                if (n2 <= 0) break block5;
                do {
                    getUInt.setAddress("8" + n2);
                    getUInt.setQuantity((short)3);
                    getUInt.readValues();
                    int[] nArray = getUInt.getValues();
                    n = nArray[0];
                    if (n > 0 && nArray[2] == 20) {
                        getUInt.setAddress("8" + (n2 + 11));
                        getUInt.setQuantity((short)6);
                        getUInt.readValues();
                        int[] nArray2 = getUInt.getValues();
                        String string = (nArray2[1] >> 8 & 0xFF) + "." + (nArray2[1] & 0xFF) + "." + (nArray2[0] >> 8 & 0xFF) + "." + (nArray2[0] & 0xFF);
                        if (string.equals(this.ipaddress.getText())) {
                            String string2 = (nArray2[3] >> 8 & 0xFF) + "." + (nArray2[3] & 0xFF) + "." + (nArray2[2] >> 8 & 0xFF) + "." + (nArray2[2] & 0xFF);
                            String string3 = (nArray2[5] >> 8 & 0xFF) + "." + (nArray2[5] & 0xFF) + "." + (nArray2[4] >> 8 & 0xFF) + "." + (nArray2[4] & 0xFF);
                            this.subnetmask.setText(string3);
                            this.gateway.setText(string2);
                            break;
                        }
                    }
                    n2 += n;
                } while (n > 0);
            }
            catch (Exception exception) {
                System.err.println("Exception reading IP Config for HE CPU Copro: " + exception);
            }
        }
    }

    private void refreshConfig(String string) {
        ConfigExtension configExtension = new ConfigExtension(this.comm, this.applet);
        for (int i = 0; i < configExtension.getNOECount(); ++i) {
            if (!configExtension.getIpAddr(i).equals(string)) continue;
            this.slot.setText(Integer.toString(configExtension.getNOESlot(i)));
            this.subnetmask.setText(configExtension.getSubnet(i));
            this.gateway.setText(configExtension.getGtwy(i));
            return;
        }
        this.slot.setText(EnetStrings.getString("UNKNOWN"));
        this.subnetmask.setText(EnetStrings.getString("UNKNOWN"));
        this.gateway.setText(EnetStrings.getString("UNKNOWN"));
    }

    private final TextField newTextField() {
        TextField textField = new TextField(15);
        textField.setBackground(lightGray);
        textField.setFont(f1);
        textField.setEditable(false);
        return textField;
    }

    private final Label newLabel(String string) {
        Label label = new Label(EnetStrings.getString(string));
        label.setFont(f1);
        return label;
    }
}

