/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.sysdiag.qbf;

import com.schneiderautomation.sysdiag.SysDiagUtil;
import com.schneiderautomation.sysdiag.qbf.ThreeDRectangle;
import java.applet.Applet;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class ImageButtonX
extends Component {
    private static final int defaultThickness = 1;
    private ThreeDRectangle border = new ThreeDRectangle(this);
    private Image image;
    private ActionListener actionListener = null;
    private int thickness;
    private Applet applet = null;
    public String[] itemList = new String[4];
    public int itemIndex = 0;
    public int instanceNumber = 0;
    public String productName = "xxx 000 00";
    public int prodType = 0;
    public int inputBytes = 0;
    public int outputBytes = 0;
    public short moduleId = 0;
    public boolean analogType = false;
    public String statusText = null;

    public ImageButtonX(Image image, Applet applet) {
        this(image, applet, 1);
    }

    public ImageButtonX(Image image, Applet applet, int n) {
        this.applet = applet;
        this.setImage(image);
        this.setThickness(n);
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                if (ImageButtonX.this.statusText != null) {
                    ImageButtonX.this.showStatusText();
                    if (ImageButtonX.this.itemIndex > 1 || ImageButtonX.this.inputBytes > 0 || ImageButtonX.this.outputBytes > 0 || ImageButtonX.this.productName.startsWith("NOE") || ImageButtonX.this.productName.startsWith("NWM") || ImageButtonX.this.productName.startsWith("NOM")) {
                        ImageButtonX.this.setCursor(Cursor.getPredefinedCursor(12));
                    }
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                ImageButtonX.this.clearStatusText();
                ImageButtonX.this.setCursor(Cursor.getPredefinedCursor(0));
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (ImageButtonX.this.actionListener != null) {
                    ImageButtonX.this.actionListener.actionPerformed(new ActionEvent(this, 1001, "ImageButtonX Action"));
                }
            }
        });
    }

    public void clearStatusText() {
        this.applet.showStatus("");
    }

    public void showStatusText() {
        if (this.statusText != null) {
            this.applet.showStatus(this.statusText);
        }
    }

    public void setStatusText(String string) {
        this.statusText = string;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setupMenuItem(String string) {
        this.itemList[this.itemIndex] = string;
        ++this.itemIndex;
    }

    public void setThickness(int n) {
        this.thickness = n;
        this.border.setThickness(n);
        if (this.isShowing()) {
            this.invalidate();
            this.getParent().validate();
        }
    }

    public void setImage(Image image) {
        this.image = image;
        if (image != null) {
            SysDiagUtil.waitForImage(this, image);
        }
        if (this.isShowing()) {
            this.invalidate();
            this.getParent().validate();
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(2 * this.thickness, 2 * this.thickness);
        if (this.image != null) {
            SysDiagUtil.waitForImage(this, this.image);
            dimension.width += this.image.getWidth(this);
            dimension.height += this.image.getHeight(this);
        }
        return dimension;
    }

    public boolean isRaised() {
        return this.border.isRaised();
    }

    public void setRaised() {
        this.border.raise();
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        this.border.clearInterior();
        if (this.image != null) {
            graphics.drawImage(this.image, this.thickness, this.thickness, this);
        }
        this.border.paintRaised();
    }

    public void processActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "ImageButtonX Action"));
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }
}

