/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.sysdiag.qbf;

import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.misc.GlobalConfig;
import com.schneiderautomation.sysdiag.MessageDisplay;
import com.schneiderautomation.sysdiag.qbf.ControllerStrings;
import com.schneiderautomation.sysdiag.qbf.MainPanel;
import com.schneiderautomation.sysdiag.qbf.MessageStrings;
import com.schneiderautomation.sysdiag.qbf.TrafficCop;
import java.applet.Applet;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;

public class ModuleLayoutApplet
extends Applet {
    private static final Color myLightYellow = new Color(240, 243, 187);
    private static final int MAIN = 0;
    private static final int DIGITAL = 1;
    private static final int ANALOG = 2;
    private static TrafficCop myCop;
    private String server;
    private Panel mainPanel;
    private Panel buttonPanel;
    private CardLayout card = new CardLayout();
    private Panel backPanel = new Panel();
    private CommBean comm;

    public void init() {
        GlobalConfig.setLanguage((String)this.getParameter("Language"));
        this.setLocale(GlobalConfig.getLocale());
        MessageStrings.init(this.getLocale());
        ControllerStrings.init(this.getLocale());
        this.setLayout(this.card);
        this.backPanel.setBackground(Color.white);
        this.comm = new CommBean(this.getLocale());
        this.server = this.getParameter("server");
        if (this.server == null) {
            this.server = this.getCodeBase().getHost();
        }
        try {
            this.showStatus(ControllerStrings.getString("S_CONNECT") + this.server);
            this.comm.connect(this.server, false);
            this.comm.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.displayEmptyMsg("Communications Failed... No data will be displayed.");
            new MessageDisplay(this, MessageStrings.getString("M_COMMERR"), exception.getMessage());
            return;
        }
        this.showStatus(ControllerStrings.getString("S_TCOP"));
        if (myCop == null) {
            myCop = new TrafficCop(this.comm);
        }
        if (!myCop.isTCopValid()) {
            this.displayEmptyMsg(ControllerStrings.getString("S_NO_TCOP"));
            return;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.backPanel.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridy = 0;
        Panel panel = new Panel();
        String string = this.getParameter("title");
        if (string == null) {
            string = ControllerStrings.getString("S_LOCALRACK");
        }
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        Label label = new Label(string, 1);
        label.setFont(new Font("TimesRoman", 1, 16));
        panel.add(label);
        this.backPanel.add((Component)panel, gridBagConstraints);
        this.buttonPanel = new Panel();
        Button button = new Button(" < ");
        this.buttonPanel.add(button);
        this.buttonPanel.setBackground(myLightYellow);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(this.buttonPanel, gridBagConstraints);
        this.backPanel.add(this.buttonPanel);
        button.setVisible(false);
        this.mainPanel = new MainPanel(this, this.comm, this.getLocale(), this.server, this.buttonPanel, button, this.card, this, myCop);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.mainPanel, gridBagConstraints);
        this.backPanel.add(this.mainPanel);
        this.add((Component)this.backPanel, "local");
        this.card.show(this, "local");
    }

    public void start() {
        try {
            this.comm.resume();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new MessageDisplay(this, MessageStrings.getString("M_COMMERR"), exception.getMessage());
        }
    }

    public void stop() {
        try {
            this.comm.suspend();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new MessageDisplay(this, MessageStrings.getString("M_COMMERR"), exception.getMessage());
        }
    }

    public void destroy() {
        try {
            this.comm.disconnect();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void displayEmptyMsg(String string) {
        this.backPanel.setBackground(Color.lightGray);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.backPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        Label label = new Label(string);
        label.setFont(new Font("TimesRoman", 1, 16));
        label.setForeground(Color.red);
        this.backPanel.add((Component)label, gridBagConstraints);
        this.add((Component)this.backPanel, "empty");
        this.card.show(this, "empty");
    }
}

