/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.sysdiag.qbf;

import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.sysdiag.SeparatorPanel;
import com.schneiderautomation.sysdiag.qbf.AnalogPanel;
import com.schneiderautomation.sysdiag.qbf.DigitalPanel;
import com.schneiderautomation.sysdiag.qbf.ModuleIDs;
import com.schneiderautomation.sysdiag.qbf.RioDropsPanel;
import com.schneiderautomation.sysdiag.qbf.RioMultiDropCard;
import com.schneiderautomation.sysdiag.qbf.RioRackCard;
import com.schneiderautomation.sysdiag.qbf.RioStrings;
import java.applet.Applet;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;

public class RioCardMgr
extends Panel {
    private static final short MAIN = 0;
    private static final short DROP = 1;
    private static final short MODULE = 2;
    private static final Color lightYellow = new Color(240, 243, 187);
    private static final short MAX_DROPS = 32;
    private static final short MAX_MODULES = 16;
    private CommBean comm;
    private String title;
    private Label l1;
    private short numberofracks;
    private short modulenumber;
    private short currentRack;
    private short dropnumber;
    private Button backbutton;
    private Button nextbutton;
    private RioDropsPanel riodropsPanel;
    private Panel titlepanel;
    private Panel buttonPanel;
    private RioRackCard[] rackpanel = new RioRackCard[5];
    private AnalogPanel analogPanel;
    private DigitalPanel digitalPanel;
    private CardLayout cardlayout;
    private CardLayout parentcard;
    private Panel parentcontainer;
    private RioMainCardPanel mainPanel;
    private String cardName;
    private Applet parent;
    private short whichcard;

    RioCardMgr(Locale locale, CommBean commBean, Applet applet, ModuleIDs moduleIDs, CardLayout cardLayout, Panel panel) {
        RioStrings.init(locale);
        this.comm = commBean;
        this.parent = applet;
        this.parentcard = cardLayout;
        this.parentcontainer = panel;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setBackground(Color.white);
        this.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.gridy = 0;
        this.titlepanel = new Panel();
        this.title = RioStrings.getString("DEFAULTTITLE");
        gridBagLayout.setConstraints(this.titlepanel, gridBagConstraints);
        this.l1 = new Label(this.title, 1);
        this.l1.setFont(new Font("TimesRoman", 1, 16));
        this.titlepanel.add(this.l1);
        this.add(this.titlepanel);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        this.riodropsPanel = new RioDropsPanel(this.title, applet, commBean, moduleIDs);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.riodropsPanel, gridBagConstraints);
        this.add(this.riodropsPanel);
        ++gridBagConstraints.gridy;
        SeparatorPanel separatorPanel = new SeparatorPanel();
        gridBagLayout.setConstraints(separatorPanel, gridBagConstraints);
        this.add(separatorPanel);
        ++gridBagConstraints.gridy;
        this.buttonPanel = new Panel();
        gridBagConstraints.insets = new Insets(-5, 0, -5, 0);
        gridBagLayout.setConstraints(this.buttonPanel, gridBagConstraints);
        this.buttonPanel.setBackground(lightYellow);
        this.add(this.buttonPanel);
        this.backbutton = new Button(" < ");
        PrevButtonListener prevButtonListener = new PrevButtonListener();
        this.buttonPanel.add(this.backbutton);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 65.0;
        gridBagConstraints.weighty = 65.0;
        RioCardListener rioCardListener = new RioCardListener();
        this.mainPanel = new RioMainCardPanel(applet, this.riodropsPanel, rioCardListener);
        gridBagLayout.setConstraints(this.mainPanel, gridBagConstraints);
        this.add(this.mainPanel);
    }

    void setTitle(short s) {
        this.title = RioStrings.getString("DEFAULTTITLE");
        if (s == 0) {
            this.l1.setText(this.title);
        } else if (s == 1) {
            String string = this.title.concat(RioStrings.getString("FORDROPNO"));
            string = string.concat(Integer.toString(this.dropnumber));
            string = string.concat(RioStrings.getString("RACKNO"));
            this.l1.setText(string.concat(Integer.toString(this.currentRack)));
        } else if (s == 2) {
            String string = this.title.concat(RioStrings.getString("FORDROPNO"));
            string = string.concat(Integer.toString(this.dropnumber));
            string = string.concat(RioStrings.getString("RACKNO"));
            string = string.concat(Integer.toString(this.currentRack));
            string = string.concat(RioStrings.getString("SLOTNO"));
            this.l1.setText(string.concat(Integer.toString(this.modulenumber)));
        }
        this.l1.invalidate();
        this.titlepanel.validate();
    }

    String getIO(short s) {
        short s2 = this.riodropsPanel.getIOType((short)(this.dropnumber - 1), (short)(this.currentRack - 1), (short)(s - 1));
        if (s2 == 1) {
            return "I";
        }
        if (s2 == 0) {
            return "O";
        }
        return "B";
    }

    static /* synthetic */ short access$210(RioCardMgr rioCardMgr) {
        short s = rioCardMgr.currentRack;
        rioCardMgr.currentRack = (short)(s - 1);
        return s;
    }

    static /* synthetic */ short access$208(RioCardMgr rioCardMgr) {
        short s = rioCardMgr.currentRack;
        rioCardMgr.currentRack = (short)(s + 1);
        return s;
    }

    class NextButtonListener
    implements ActionListener {
        NextButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (RioCardMgr.this.currentRack < RioCardMgr.this.numberofracks) {
                RioCardMgr.access$208(RioCardMgr.this);
                if (RioCardMgr.this.currentRack == RioCardMgr.this.numberofracks) {
                    RioCardMgr.this.nextbutton.setEnabled(false);
                }
                RioCardMgr.this.riodropsPanel.setDropData(RioCardMgr.this.dropnumber, RioCardMgr.this.currentRack);
                RioCardMgr.this.setTitle((short)1);
                RioCardMgr.this.cardName = "rack" + RioCardMgr.this.currentRack;
                RioCardMgr.this.cardlayout.show(RioCardMgr.this.mainPanel, RioCardMgr.this.cardName);
            }
        }
    }

    class PrevButtonListener
    implements ActionListener {
        String tmp;

        PrevButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (RioCardMgr.this.cardName != "digital" && RioCardMgr.this.cardName != "analog") {
                if (RioCardMgr.this.currentRack > 0) {
                    RioCardMgr.access$210(RioCardMgr.this);
                    if (RioCardMgr.this.currentRack == 0) {
                        RioCardMgr.this.whichcard = (short)0;
                        RioCardMgr.this.riodropsPanel.setMultiDropData(RioCardMgr.this.comm, RioCardMgr.this.riodropsPanel.getNumberOfDrops());
                        RioCardMgr.this.riodropsPanel.validate();
                        RioCardMgr.this.setTitle(RioCardMgr.this.whichcard);
                        RioCardMgr.this.cardlayout.show(RioCardMgr.this.mainPanel, "main");
                        RioCardMgr.this.cardName = "main";
                        if (RioCardMgr.this.nextbutton != null) {
                            RioCardMgr.this.buttonPanel.remove(RioCardMgr.this.nextbutton);
                        }
                        if (RioCardMgr.this.rackpanel[0] != null) {
                            RioCardMgr.this.mainPanel.remove(RioCardMgr.this.rackpanel[0]);
                        }
                        if (RioCardMgr.this.rackpanel[1] != null) {
                            RioCardMgr.this.mainPanel.remove(RioCardMgr.this.rackpanel[1]);
                        }
                        if (RioCardMgr.this.rackpanel[2] != null) {
                            RioCardMgr.this.mainPanel.remove(RioCardMgr.this.rackpanel[2]);
                        }
                        if (RioCardMgr.this.rackpanel[3] != null) {
                            RioCardMgr.this.mainPanel.remove(RioCardMgr.this.rackpanel[3]);
                        }
                        if (RioCardMgr.this.rackpanel[4] != null) {
                            RioCardMgr.this.mainPanel.remove(RioCardMgr.this.rackpanel[4]);
                        }
                        for (int i = 0; i < 5; ++i) {
                            ((RioCardMgr)RioCardMgr.this).rackpanel[i] = null;
                        }
                    } else {
                        RioCardMgr.this.nextbutton.setEnabled(true);
                        RioCardMgr.this.riodropsPanel.setDropData(RioCardMgr.this.dropnumber, RioCardMgr.this.currentRack);
                        RioCardMgr.this.riodropsPanel.validate();
                        RioCardMgr.this.whichcard = (short)1;
                        RioCardMgr.this.setTitle((short)1);
                        RioCardMgr.this.cardName = "rack" + RioCardMgr.this.currentRack;
                        RioCardMgr.this.cardlayout.show(RioCardMgr.this.mainPanel, RioCardMgr.this.cardName);
                    }
                } else {
                    RioCardMgr.this.cardName = "local";
                    RioCardMgr.this.parentcard.show(RioCardMgr.this.parentcontainer, RioCardMgr.this.cardName);
                }
            } else {
                RioCardMgr.this.riodropsPanel.setDropData(RioCardMgr.this.dropnumber, RioCardMgr.this.currentRack);
                RioCardMgr.this.riodropsPanel.validate();
                RioCardMgr.this.setTitle((short)1);
                RioCardMgr.this.whichcard = (short)1;
                RioCardMgr.this.cardName = "rack" + RioCardMgr.this.currentRack;
                RioCardMgr.this.cardlayout.show(RioCardMgr.this.mainPanel, RioCardMgr.this.cardName);
                if (RioCardMgr.this.nextbutton != null) {
                    RioCardMgr.this.nextbutton.setVisible(true);
                }
            }
            System.gc();
        }
    }

    class RioMainCardPanel
    extends Panel {
        RioMainCardPanel(Applet applet, RioDropsPanel rioDropsPanel, RioCardListener rioCardListener) {
            RioCardMgr.this.cardlayout = new CardLayout();
            this.setLayout(RioCardMgr.this.cardlayout);
            RioCardMgr.this.whichcard = (short)0;
            RioCardMgr.this.setTitle(RioCardMgr.this.whichcard);
            RioMultiDropCard rioMultiDropCard = new RioMultiDropCard(applet, RioCardMgr.this.comm, rioDropsPanel, rioCardListener);
            this.add("main", rioMultiDropCard);
            RioCardMgr.this.digitalPanel = new DigitalPanel(RioCardMgr.this.comm, rioDropsPanel.getTrafficCop(), RioCardMgr.this.backbutton);
            this.add("digital", RioCardMgr.this.digitalPanel);
            RioCardMgr.this.analogPanel = new AnalogPanel(RioCardMgr.this.comm, rioDropsPanel.getTrafficCop(), RioCardMgr.this.backbutton);
            this.add("analog", RioCardMgr.this.analogPanel);
            RioCardMgr.this.cardName = "main";
            RioCardMgr.this.cardlayout.show(this, "main");
            RioCardMgr.this.backbutton.addActionListener(new PrevButtonListener());
        }
    }

    class RioCardListener
    implements ActionListener {
        RioCardListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RioCardMgr.this.setCursor(Cursor.getPredefinedCursor(3));
            if (RioCardMgr.this.whichcard == 0) {
                RioCardMgr.this.dropnumber = new Integer(actionEvent.getActionCommand()).shortValue();
                RioCardMgr.this.whichcard = (short)1;
                RioCardMgr.this.currentRack = (short)1;
                RioCardMgr.this.riodropsPanel.setDropData(RioCardMgr.this.dropnumber, RioCardMgr.this.currentRack);
                RioCardMgr.this.riodropsPanel.validate();
                RioCardMgr.this.numberofracks = RioCardMgr.this.riodropsPanel.getNumberOfRacks((short)(RioCardMgr.this.dropnumber - 1));
                RioCardMgr.this.setTitle(RioCardMgr.this.whichcard);
                ((RioCardMgr)RioCardMgr.this).rackpanel[0] = new RioRackCard(RioCardMgr.this.parent, RioCardMgr.this.riodropsPanel, RioCardMgr.this.dropnumber, 1, this);
                RioCardMgr.this.cardName = "rack1";
                RioCardMgr.this.mainPanel.add(RioCardMgr.this.cardName, RioCardMgr.this.rackpanel[0]);
                RioCardMgr.this.cardlayout.show(RioCardMgr.this.mainPanel, RioCardMgr.this.cardName);
                if (RioCardMgr.this.numberofracks > 1 && RioCardMgr.this.numberofracks <= 5) {
                    RioCardMgr.this.nextbutton = new Button(" > ");
                    RioCardMgr.this.nextbutton.addActionListener(new NextButtonListener());
                    RioCardMgr.this.buttonPanel.add(RioCardMgr.this.nextbutton);
                    RioCardMgr.this.buttonPanel.validate();
                    if (RioCardMgr.this.numberofracks >= 2) {
                        ((RioCardMgr)RioCardMgr.this).rackpanel[1] = new RioRackCard(RioCardMgr.this.parent, RioCardMgr.this.riodropsPanel, RioCardMgr.this.dropnumber, 2, this);
                        RioCardMgr.this.mainPanel.add("rack2", RioCardMgr.this.rackpanel[1]);
                    }
                    if (RioCardMgr.this.numberofracks >= 3) {
                        ((RioCardMgr)RioCardMgr.this).rackpanel[2] = new RioRackCard(RioCardMgr.this.parent, RioCardMgr.this.riodropsPanel, RioCardMgr.this.dropnumber, 3, this);
                        RioCardMgr.this.mainPanel.add("rack3", RioCardMgr.this.rackpanel[2]);
                    }
                    if (RioCardMgr.this.numberofracks >= 4) {
                        ((RioCardMgr)RioCardMgr.this).rackpanel[3] = new RioRackCard(RioCardMgr.this.parent, RioCardMgr.this.riodropsPanel, RioCardMgr.this.dropnumber, 4, this);
                        RioCardMgr.this.mainPanel.add("rack4", RioCardMgr.this.rackpanel[3]);
                    }
                    if (RioCardMgr.this.numberofracks == 5) {
                        ((RioCardMgr)RioCardMgr.this).rackpanel[4] = new RioRackCard(RioCardMgr.this.parent, RioCardMgr.this.riodropsPanel, RioCardMgr.this.dropnumber, 5, this);
                        RioCardMgr.this.mainPanel.add("rack5", RioCardMgr.this.rackpanel[4]);
                    }
                }
            } else if (RioCardMgr.this.whichcard == 1) {
                RioCardMgr.this.riodropsPanel.setDropData(RioCardMgr.this.dropnumber, RioCardMgr.this.currentRack);
                RioCardMgr.this.modulenumber = new Integer(actionEvent.getActionCommand()).shortValue();
                short s = (short)(RioCardMgr.this.dropnumber - 1);
                short s2 = (short)(RioCardMgr.this.currentRack - 1);
                String string = RioCardMgr.this.rackpanel[s2].getPersonality(s, s2, (short)(RioCardMgr.this.modulenumber - 1), RioCardMgr.this.whichcard);
                String string2 = string.substring(0, 3);
                if (!(string2.equalsIgnoreCase("CPS") || string2.equals("???") || string2.equalsIgnoreCase("unk"))) {
                    RioCardMgr.this.whichcard = (short)2;
                    RioCardMgr.this.riodropsPanel.setModuleData(RioCardMgr.this.comm, RioCardMgr.this.dropnumber, RioCardMgr.this.currentRack, RioCardMgr.this.modulenumber);
                    RioCardMgr.this.riodropsPanel.validate();
                    short s3 = RioCardMgr.this.riodropsPanel.getDropType(s);
                    short s4 = RioCardMgr.this.riodropsPanel.getHeadSlot(RioCardMgr.this.dropnumber);
                    short s5 = RioCardMgr.this.riodropsPanel.getSlotNumber(s, s2, (short)(RioCardMgr.this.modulenumber - 1));
                    if (!RioCardMgr.this.riodropsPanel.getAnalog(s, s2, (short)(RioCardMgr.this.modulenumber - 1))) {
                        RioCardMgr.this.cardName = "digital";
                        RioCardMgr.this.digitalPanel.showActualModule(s4, RioCardMgr.this.dropnumber, RioCardMgr.this.currentRack, s5, RioCardMgr.this.comm, s3, string);
                    } else {
                        RioCardMgr.this.cardName = "analog";
                        RioCardMgr.this.analogPanel.showActualModule(s4, RioCardMgr.this.dropnumber, RioCardMgr.this.currentRack, s5, RioCardMgr.this.comm, s3, string);
                    }
                    RioCardMgr.this.cardlayout.show(RioCardMgr.this.mainPanel, RioCardMgr.this.cardName);
                    RioCardMgr.this.setTitle(RioCardMgr.this.whichcard);
                    if (RioCardMgr.this.nextbutton != null) {
                        RioCardMgr.this.nextbutton.setVisible(false);
                    }
                }
            }
            RioCardMgr.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

