/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.factorycast;

import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.factorycast.ServerChangeEvent;
import com.schneiderautomation.factorycast.ServerChangeListener;
import com.schneiderautomation.factorycast.comm.ClientHandlerInterface;
import com.schneiderautomation.factorycast.comm.ValueAdaptor;
import com.schneiderautomation.misc.GlobalConfig;
import com.schneiderautomation.namespace.VarLookupInterface;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public class CommBeanApplet
extends Applet
implements PropertyChangeListener,
Serializable {
    static final long serialVersionUID = -5904261677575760383L;
    private transient CommBean comm;
    private transient ServerChangeEvent serverChangeEvent;
    private transient String host;
    private transient boolean fAppletStarted;
    private boolean loadSymbols = true;
    private PropertyChangeSupport boundSupport = new PropertyChangeSupport(this);

    public void init() {
        this.setBackground(Color.magenta);
        this.setEnabled(false);
        this.initCommBean();
    }

    public void start() {
        if (!this.fAppletStarted) {
            this.fAppletStarted = true;
            this.startMonitoring();
        }
        this.resumeMonitoring();
    }

    public void stop() {
        this.suspendMonitoring();
    }

    public void destroy() {
        if (this.comm != null) {
            try {
                this.comm.disconnect();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void addNotify() {
        Container container;
        super.addNotify();
        for (container = this.getParent(); container != null && !(container instanceof Applet); container = container.getParent()) {
        }
        if (container != null) {
            this.host = ((Applet)container).getCodeBase().getHost();
            if (this.fAppletStarted) {
                this.initCommBean();
                this.startMonitoring();
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(20, 20);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("connected") || string.equals("started") || string.equals("suspended")) {
            this.boundSupport.firePropertyChange(string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    public void startMonitoring() {
        if (this.comm != null) {
            this.comm.start();
        }
    }

    public void stopMonitoring() {
        if (this.comm != null) {
            this.comm.stop();
        }
    }

    public void suspendMonitoring() {
        if (this.comm != null) {
            try {
                this.comm.suspend();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void resumeMonitoring() {
        if (this.comm != null) {
            try {
                this.comm.resume();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addServerChangeListener(ServerChangeListener serverChangeListener) {
        this.initCommBean();
        try {
            this.serverChangeEvent = new ServerChangeEvent(this, this.comm);
            serverChangeListener.serverChanged(this.serverChangeEvent);
        }
        finally {
            this.serverChangeEvent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeServerChangeListener(ServerChangeListener serverChangeListener) {
        try {
            this.serverChangeEvent = new ServerChangeEvent(this, null);
            serverChangeListener.serverChanged(this.serverChangeEvent);
        }
        finally {
            this.serverChangeEvent = null;
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.boundSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.boundSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean isStarted() {
        return this.comm != null ? this.comm.isStarted() : false;
    }

    public boolean isConnected() {
        return this.comm != null ? this.comm.isConnected() : false;
    }

    public boolean isSuspended() {
        return this.comm != null ? this.comm.isSuspended() : false;
    }

    public void setLoadSymbols(boolean bl) {
        this.loadSymbols = bl;
    }

    public boolean isLoadSymbols() {
        return this.loadSymbols;
    }

    public ValueAdaptor getAdaptor() {
        return this.comm != null ? this.comm.getAdaptor() : null;
    }

    public ClientHandlerInterface getServer() {
        return this.comm != null ? this.comm.getServer() : null;
    }

    public VarLookupInterface getVarLookup() {
        return this.comm != null ? this.comm.getVarLookup() : null;
    }

    public CommBean getCommBean() {
        return this.comm;
    }

    public ServerChangeEvent getServerChangeEvent() {
        return this.serverChangeEvent;
    }

    private void initCommBean() {
        if (this.comm == null) {
            this.comm = new CommBean(GlobalConfig.getLocale());
            this.comm.addPropertyChangeListener(this);
        }
        if (!this.comm.isConnected() && this.host != null) {
            try {
                this.comm.connect(this.host, this.loadSymbols);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

