/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.factorycast;

import com.schneiderautomation.dt.DT;
import com.schneiderautomation.factorycast.GetRef;
import com.schneiderautomation.factorycast.comm.BadDataTypeException;
import com.schneiderautomation.factorycast.comm.ClientHandlerInterface;
import java.io.Serializable;
import java.util.BitSet;

public class GetBits
extends GetRef
implements Serializable {
    static final long serialVersionUID = 387047658680040846L;
    private transient BitSet bitset;

    public GetBits() {
        super((short)0);
    }

    public GetBits(ClientHandlerInterface clientHandlerInterface) {
        super(clientHandlerInterface, (short)0);
    }

    public BitSet getValue() {
        return this.bitset != null ? (BitSet)this.bitset.clone() : new BitSet();
    }

    public void setDatatype(short s) {
        super.setDatatype(s);
    }

    protected void fireValuePropertyChange(Object object) {
        this.bitset = GetBits.createBitSet(this.getValueObject(), this.getValueType());
        this.firePropertyChange("value", null, this.getValue());
    }

    protected void validateDatatype(short s) throws BadDataTypeException {
        GetBits.getBitsPerValue(s);
    }

    static int getBitsPerValue(short s) throws BadDataTypeException {
        switch (s) {
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 8;
            }
            case 4: 
            case 5: {
                return 16;
            }
            case 6: 
            case 7: {
                return 32;
            }
        }
        throw new BadDataTypeException(DT.toName(s));
    }

    static BitSet createBitSet(Object object, short s) {
        long[] lArray;
        int n;
        if (object == null) {
            return null;
        }
        try {
            n = GetBits.getBitsPerValue(s);
        }
        catch (BadDataTypeException badDataTypeException) {
            return null;
        }
        switch (s) {
            case 1: {
                int n2;
                Object[] objectArray = (boolean[])object;
                lArray = new long[objectArray.length];
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    lArray[n2] = objectArray[n2] ? 1L : 0L;
                }
                break;
            }
            case 2: {
                int n2;
                Object[] objectArray = (byte[])object;
                lArray = new long[objectArray.length];
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    lArray[n2] = objectArray[n2];
                }
                break;
            }
            case 3: 
            case 4: {
                int n2;
                Object[] objectArray = (short[])object;
                lArray = new long[objectArray.length];
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    lArray[n2] = objectArray[n2];
                }
                break;
            }
            case 5: 
            case 6: {
                int n2;
                Object[] objectArray = (int[])object;
                lArray = new long[objectArray.length];
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    lArray[n2] = objectArray[n2];
                }
                break;
            }
            case 7: {
                lArray = (long[])object;
                break;
            }
            default: {
                return null;
            }
        }
        long l = 1L << n - 1;
        BitSet bitSet = new BitSet(lArray.length * n);
        int n3 = 0;
        for (int i = 0; i < lArray.length; ++i) {
            long l2 = lArray[i];
            for (int j = 0; j < n; ++j) {
                if ((l2 & l >>> j) == 0L) {
                    bitSet.clear(n3++);
                    continue;
                }
                bitSet.set(n3++);
            }
        }
        return bitSet;
    }
}

