/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.factorycast;

import com.schneiderautomation.dt.DT;
import com.schneiderautomation.factorycast.GetRef;
import com.schneiderautomation.factorycast.comm.BadDataTypeException;
import com.schneiderautomation.factorycast.comm.ClientHandlerInterface;
import java.io.Serializable;

public class GetNumber
extends GetRef
implements Serializable {
    static final long serialVersionUID = -1140942020292550872L;
    private transient Number[] nValues;

    public GetNumber() {
        super((short)0);
    }

    public GetNumber(ClientHandlerInterface clientHandlerInterface) {
        super(clientHandlerInterface, (short)0);
    }

    public Number getValue() {
        return this.getValues()[0];
    }

    public Number[] getValues() {
        if (this.nValues == null) {
            return GetNumber.getNumberValues(new short[this.getQuantity()], (short)4);
        }
        return this.nValues;
    }

    public Number getValues(int n) {
        return this.getValues()[n];
    }

    public void setDatatype(short s) {
        super.setDatatype(s);
    }

    protected void fireValuePropertyChange(Object object) {
        this.nValues = GetNumber.getNumberValues(this.getValueObject(), this.getValueType());
        if (this.nValues != null) {
            if (this.nValues.length == 1) {
                this.firePropertyChange("value", null, this.nValues[0]);
            }
            this.firePropertyChange("values", null, this.nValues);
        }
    }

    protected void validateDatatype(short s) throws BadDataTypeException {
        if (s == 9) {
            throw new BadDataTypeException(DT.toName(s));
        }
    }

    static Number[] getNumberValues(Object object, short s) {
        Number[] numberArray = null;
        if (object != null) {
            switch (s) {
                case 1: {
                    boolean[] blArray = (boolean[])object;
                    numberArray = new Number[blArray.length];
                    for (int i = 0; i < blArray.length; ++i) {
                        numberArray[i] = new Byte(blArray[i] ? (byte)1 : 0);
                    }
                    break;
                }
                case 2: {
                    byte[] byArray = (byte[])object;
                    numberArray = new Number[byArray.length];
                    for (int i = 0; i < byArray.length; ++i) {
                        numberArray[i] = new Byte(byArray[i]);
                    }
                    break;
                }
                case 3: 
                case 4: {
                    short[] sArray = (short[])object;
                    numberArray = new Number[sArray.length];
                    for (int i = 0; i < sArray.length; ++i) {
                        numberArray[i] = new Short(sArray[i]);
                    }
                    break;
                }
                case 5: 
                case 6: 
                case 14: 
                case 15: {
                    int[] nArray = (int[])object;
                    numberArray = new Number[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        numberArray[i] = new Integer(nArray[i]);
                    }
                    break;
                }
                case 7: 
                case 10: 
                case 16: {
                    long[] lArray = (long[])object;
                    numberArray = new Number[lArray.length];
                    for (int i = 0; i < lArray.length; ++i) {
                        numberArray[i] = new Long(lArray[i]);
                    }
                    break;
                }
                case 8: {
                    float[] fArray = (float[])object;
                    numberArray = new Number[fArray.length];
                    for (int i = 0; i < fArray.length; ++i) {
                        numberArray[i] = new Float(fArray[i]);
                    }
                    break;
                }
            }
        }
        return numberArray;
    }
}

