/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.factorycast;

import com.schneiderautomation.dt.DT;
import com.schneiderautomation.dt.FT;
import com.schneiderautomation.factorycast.AppletColorTable;
import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.factorycast.LiveLabelMgrApplet;
import com.schneiderautomation.factorycast.MonitorNumber;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Label;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class LiveLabelApplet
extends Applet
implements PropertyChangeListener {
    private static final int FONT_SERIF = 0;
    private static final int FONT_SANSSERIF = 1;
    private static final int FONT_MONOSPACE = 2;
    private static final int N_FONTS = 3;
    private static final int ALIGN_LEFT = 0;
    private static final int ALIGN_CENTER = 1;
    private static final int ALIGN_RIGHT = 2;
    private static final int N_ALIGN = 3;
    private static final int N_DTYPES = DT.typeNames.length;
    private static final int[] fmtLookupTable = new int[N_DTYPES];
    private static final String[] fmtNames = new String[9];
    private static final String[] fontNames = new String[3];
    private static final String[] fontTable = new String[3];
    private static final String[] alignNames = new String[3];
    private static final int[] alignTable = new int[3];
    private String address = "";
    private String label = "";
    private String units = "";
    private String onWord = "ON";
    private String offWord = "OFF";
    private short idDataType = 0;
    private int idFormat = 2;
    private boolean fScale = false;
    private float gain = 1.0f;
    private float bias = 0.0f;
    private Color foregrnd = Color.black;
    private Color backgrnd = Color.lightGray;
    private Color error = Color.magenta;
    private String fontName = "SansSerif";
    private int fontStyle = 0;
    private int fontSize = 12;
    private int labelWidth = -1;
    private int unitsWidth = -1;
    private int labelAlign = 0;
    private int valueAlign = 0;
    private int unitsAlign = 0;
    private MonitorNumber monitor;
    private Label labelLbl = new Label();
    private Label valueLbl = new Label();
    private Label unitsLbl = new Label();
    private CommBean comm;

    public void init() {
        this.initParams("");
        this.initLabels();
    }

    public void initParams(String string) {
        Color color;
        Color color2;
        Color color3;
        int n;
        String string2 = this.getParameter(string + "ADDRESS");
        if (string2 != null) {
            this.address = string2;
        }
        if ((string2 = this.getParameter(string + "LABEL")) != null) {
            this.label = string2;
        }
        if ((string2 = this.getParameter(string + "UNITS")) != null) {
            this.units = string2;
        }
        if ((string2 = this.getParameter(string + "ON_WORD")) != null) {
            this.onWord = string2;
        }
        if ((string2 = this.getParameter(string + "OFF_WORD")) != null) {
            this.offWord = string2;
        }
        if ((string2 = this.getParameter(string + "DATATYPE")) != null) {
            this.idDataType = DT.toDT(string2);
            if (this.idDataType == 9) {
                this.idDataType = 0;
            }
        }
        if ((string2 = this.getParameter(string + "FORMAT")) != null) {
            for (n = 1; n < fmtNames.length; ++n) {
                if (!string2.equalsIgnoreCase(fmtNames[n])) continue;
                this.idFormat = n;
                break;
            }
        } else if (this.idDataType > 0 && this.idDataType < N_DTYPES) {
            this.idFormat = fmtLookupTable[this.idDataType];
        }
        if ((string2 = this.getParameter(string + "GAIN")) != null) {
            try {
                this.gain = new Float(string2).floatValue();
                this.fScale = true;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        if ((string2 = this.getParameter(string + "BIAS")) != null) {
            try {
                this.bias = new Float(string2).floatValue();
                this.fScale = true;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        if ((string2 = this.getParameter(string + "FOREGRND")) != null && (color3 = AppletColorTable.lookupColor(string2)) != null) {
            this.foregrnd = color3;
        }
        if ((string2 = this.getParameter(string + "BACKGRND")) != null && (color2 = AppletColorTable.lookupColor(string2)) != null) {
            this.backgrnd = color2;
        }
        if ((string2 = this.getParameter(string + "ERROR_COLOR")) != null && (color = AppletColorTable.lookupColor(string2)) != null) {
            this.error = color;
        }
        if ((string2 = this.getParameter(string + "FONT_NAME")) != null) {
            for (n = 0; n < 3; ++n) {
                if (!string2.equalsIgnoreCase(fontNames[n])) continue;
                this.fontName = fontTable[n];
                break;
            }
        }
        if ((string2 = this.getParameter(string + "FONT_BOLD")) != null && string2.equalsIgnoreCase("TRUE")) {
            ++this.fontStyle;
        }
        if ((string2 = this.getParameter(string + "FONT_ITALIC")) != null && string2.equalsIgnoreCase("TRUE")) {
            this.fontStyle += 2;
        }
        if ((string2 = this.getParameter(string + "FONT_SIZE")) != null) {
            try {
                this.fontSize = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        if ((string2 = this.getParameter(string + "LABEL_WIDTH")) != null) {
            try {
                this.labelWidth = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        if ((string2 = this.getParameter(string + "UNITS_WIDTH")) != null) {
            try {
                this.unitsWidth = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        if ((string2 = this.getParameter(string + "LABEL_ALIGN")) != null) {
            for (int i = 0; i < 3; ++i) {
                if (!string2.equalsIgnoreCase(alignNames[i])) continue;
                this.labelAlign = alignTable[i];
                break;
            }
        }
        if ((string2 = this.getParameter(string + "VALUE_ALIGN")) != null) {
            for (int i = 0; i < 3; ++i) {
                if (!string2.equalsIgnoreCase(alignNames[i])) continue;
                this.valueAlign = alignTable[i];
                break;
            }
        }
        if ((string2 = this.getParameter(string + "UNITS_ALIGN")) != null) {
            for (int i = 0; i < 3; ++i) {
                if (!string2.equalsIgnoreCase(alignNames[i])) continue;
                this.unitsAlign = alignTable[i];
                break;
            }
        }
    }

    public void initLabels() {
        this.labelLbl.setAlignment(this.labelAlign);
        this.labelLbl.setText(this.label);
        this.valueLbl.setAlignment(this.valueAlign);
        this.valueLbl.setText("???");
        this.unitsLbl.setAlignment(this.unitsAlign);
        this.unitsLbl.setText(this.units);
        this.setBackground(this.backgrnd);
        this.setForeground(this.foregrnd);
        this.setFont(new Font(this.fontName, this.fontStyle, this.fontSize));
        this.setLayout(new LiveLabelLayout());
        this.add(this.labelLbl);
        this.add(this.valueLbl);
        this.add(this.unitsLbl);
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, this.valueLbl.getMinimumSize().height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(0, this.valueLbl.getPreferredSize().height);
    }

    public void start() {
        String string = this.getParameter("GLOBAL_COMM_MGR");
        boolean bl = string != null ? string.equalsIgnoreCase("TRUE") : false;
        LiveLabelMgrApplet liveLabelMgrApplet = LiveLabelMgrApplet.findCommMgr(bl ? null : this.getAppletContext());
        if (liveLabelMgrApplet != null) {
            CommBean commBean = liveLabelMgrApplet.getCommBean();
            if (this.comm != commBean) {
                this.start(commBean);
                this.comm = commBean;
                liveLabelMgrApplet.clientModified();
            }
        } else {
            this.setErrorState();
        }
    }

    public void start(CommBean commBean) {
        if (this.monitor != null) {
            this.monitor.deregister();
            this.monitor.removePropertyChangeListener(this);
        }
        this.monitor = new MonitorNumber(commBean.getAdaptor());
        this.monitor.addPropertyChangeListener(this);
        this.monitor.setDatatype(this.idDataType);
        this.monitor.setAddress(this.address);
        this.monitor.register();
    }

    public void setErrorState() {
        this.valueLbl.setForeground(this.error);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("value")) {
            String string2;
            Number number = (Number)propertyChangeEvent.getNewValue();
            if (this.idFormat == 1) {
                boolean bl = number.longValue() != 0L;
                string2 = bl ? this.onWord : this.offWord;
            } else {
                int n = this.monitor.getValueType();
                if (this.fScale && this.idFormat == 2) {
                    n = 8;
                    number = new Float(number.floatValue() * this.gain + this.bias);
                }
                string2 = FT.formatValue(number, this.idFormat, (short)n);
            }
            if (this.labelAlign == 2 && this.valueAlign == 0) {
                string2 = " " + string2;
            } else if (this.valueAlign == 2 && this.unitsAlign == 0) {
                string2 = string2 + " ";
            }
            this.valueLbl.setText(string2);
        } else if (string.equals("subscribeStatus")) {
            String string3 = (String)propertyChangeEvent.getNewValue();
            if (string3.length() > 0) {
                this.printError(string3);
            } else {
                this.valueLbl.setForeground(this.foregrnd);
            }
        }
    }

    private void printError(String string) {
        this.setErrorState();
        System.out.println("LiveLabelApplet " + this.label + " (" + this.address + "): " + string);
    }

    static {
        LiveLabelApplet.fmtLookupTable[1] = 1;
        LiveLabelApplet.fmtLookupTable[2] = 2;
        LiveLabelApplet.fmtLookupTable[3] = 2;
        LiveLabelApplet.fmtLookupTable[4] = 2;
        LiveLabelApplet.fmtLookupTable[5] = 2;
        LiveLabelApplet.fmtLookupTable[6] = 2;
        LiveLabelApplet.fmtLookupTable[7] = 2;
        LiveLabelApplet.fmtLookupTable[8] = 2;
        LiveLabelApplet.fmtLookupTable[10] = 7;
        LiveLabelApplet.fmtLookupTable[14] = 8;
        LiveLabelApplet.fmtLookupTable[15] = 8;
        LiveLabelApplet.fmtLookupTable[16] = 8;
        LiveLabelApplet.fmtNames[0] = "";
        LiveLabelApplet.fmtNames[1] = "BOOL";
        LiveLabelApplet.fmtNames[2] = "DEC";
        LiveLabelApplet.fmtNames[3] = "HEX";
        LiveLabelApplet.fmtNames[4] = "BIN";
        LiveLabelApplet.fmtNames[6] = "ASCII";
        LiveLabelApplet.fmtNames[7] = "TIME";
        LiveLabelApplet.fmtNames[8] = "DATE";
        LiveLabelApplet.fontNames[0] = "SERIF";
        LiveLabelApplet.fontNames[1] = "SANSSERIF";
        LiveLabelApplet.fontNames[2] = "MONOSPACE";
        LiveLabelApplet.fontTable[0] = "Serif";
        LiveLabelApplet.fontTable[1] = "SansSerif";
        LiveLabelApplet.fontTable[2] = "Monospaced";
        LiveLabelApplet.alignNames[0] = "LEFT";
        LiveLabelApplet.alignNames[1] = "CENTER";
        LiveLabelApplet.alignNames[2] = "RIGHT";
        LiveLabelApplet.alignTable[0] = 0;
        LiveLabelApplet.alignTable[1] = 1;
        LiveLabelApplet.alignTable[2] = 2;
    }

    class LiveLabelLayout
    implements LayoutManager {
        LiveLabelLayout() {
        }

        public void layoutContainer(Container container) {
            Dimension dimension = container.getSize();
            if (LiveLabelApplet.this.labelWidth < 0) {
                LiveLabelApplet.this.labelWidth = ((LiveLabelApplet)LiveLabelApplet.this).labelLbl.getMinimumSize().width;
            }
            if (LiveLabelApplet.this.unitsWidth < 0) {
                LiveLabelApplet.this.unitsWidth = ((LiveLabelApplet)LiveLabelApplet.this).unitsLbl.getMinimumSize().width;
            }
            int n = Math.max(0, dimension.width - (LiveLabelApplet.this.labelWidth + LiveLabelApplet.this.unitsWidth));
            int n2 = 0;
            LiveLabelApplet.this.labelLbl.setBounds(n2, 0, LiveLabelApplet.this.labelWidth, dimension.height);
            LiveLabelApplet.this.valueLbl.setBounds(n2 += LiveLabelApplet.this.labelWidth, 0, n, dimension.height);
            LiveLabelApplet.this.unitsLbl.setBounds(n2 += n, 0, LiveLabelApplet.this.unitsWidth, dimension.height);
        }

        public Dimension preferredLayoutSize(Container container) {
            return container.getSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            return container.getSize();
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

