/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.factorycast.comm;

import com.schneiderautomation.factorycast.comm.ClientUpdateInterface;
import com.schneiderautomation.factorycast.comm.GetRefResponse;
import com.schneiderautomation.factorycast.comm.ServerHandlerInterface;
import com.schneiderautomation.factorycast.comm.UpdateKey;
import com.schneiderautomation.factorycast.comm.UpdateValue;
import java.util.Hashtable;

public class UpdateQueue
implements Runnable,
ClientUpdateInterface {
    private ServerHandlerInterface client;
    private Hashtable queue = new Hashtable();
    private Thread engine = null;
    private UpdateKey head = null;
    private UpdateKey tail = null;

    UpdateQueue(ServerHandlerInterface serverHandlerInterface) {
        this.client = serverHandlerInterface;
    }

    public void run() {
        while (this.engine != null) {
            try {
                GetRefResponse getRefResponse = this.getNext();
                if (getRefResponse == null) continue;
                this.client.valueChanged(getRefResponse);
            }
            catch (Exception exception) {
                System.out.println("UpdateQueue Exception calling valueChanged(): " + exception.getMessage());
            }
        }
    }

    public void updateValue(GetRefResponse getRefResponse) {
        this.add(getRefResponse);
    }

    public void purgeValue(int n) {
        this.remove(n);
    }

    synchronized void start() {
        if (this.engine == null) {
            this.engine = new Thread(this);
            this.engine.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Thread thread;
        UpdateQueue updateQueue = this;
        synchronized (updateQueue) {
            thread = this.engine;
            this.engine = null;
            this.clear();
            this.notify();
        }
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    synchronized void remove(int n) {
        UpdateValue updateValue = (UpdateValue)this.queue.get(new UpdateKey(n));
        if (updateValue != null) {
            updateValue.value = null;
        }
    }

    synchronized void add(GetRefResponse getRefResponse) {
        if (this.engine != null) {
            UpdateKey updateKey = new UpdateKey(getRefResponse);
            UpdateValue updateValue = (UpdateValue)this.queue.get(updateKey);
            if (updateValue == null) {
                updateValue = new UpdateValue();
                this.queue.put(updateKey, updateValue);
                if (this.head == null) {
                    this.head = updateKey;
                } else {
                    this.tail.next = updateKey;
                }
                this.tail = updateKey;
                this.notify();
            }
            updateValue.value = getRefResponse;
        }
    }

    private synchronized GetRefResponse getNext() {
        while (this.head == null) {
            if (this.engine == null) {
                return null;
            }
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        UpdateValue updateValue = (UpdateValue)this.queue.remove(this.head);
        if (this.head == this.tail) {
            this.head = null;
            this.tail = null;
        } else {
            this.head = this.head.next;
        }
        return updateValue.value;
    }

    private synchronized void clear() {
        this.head = null;
        this.tail = null;
        this.queue.clear();
    }
}

