/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.factorycast.comm.umas;

import com.schneiderautomation.dt.DT;
import com.schneiderautomation.factorycast.comm.FCIOException;
import com.schneiderautomation.factorycast.comm.InvalidAddressException;
import com.schneiderautomation.factorycast.comm.InvalidSymbolTableException;
import com.schneiderautomation.factorycast.comm.NotFoundException;
import com.schneiderautomation.factorycast.comm.Request;
import com.schneiderautomation.factorycast.comm.UnsupportedDataTypeException;
import com.schneiderautomation.factorycast.comm.umas.IllegalReferenceTypeException;
import com.schneiderautomation.namespace.VarLookupInterface;
import com.schneiderautomation.vars.VarInfo;
import java.util.StringTokenizer;

class AddressUMAS {
    static final int STD = 0;
    static final int IO = 1;
    static final int BOL = 2;
    static final byte SX = 0;
    static final byte SW = 1;
    static final byte MX = 2;
    static final byte MW = 3;
    static final byte KW = 4;
    static final byte IX = 5;
    static final byte IW = 6;
    static final byte SD = 37;
    static final byte MD = 38;
    static final byte KD = 39;
    static final byte MF = 40;
    static final byte IO_ER = 0;
    static final byte IO_IX = 1;
    static final byte IO_QX = 2;
    static final byte IO_IW = 3;
    static final byte IO_QW = 4;
    static final byte IO_MW = 5;
    static final byte IO_MS = 6;
    static final byte IO_KW = 10;
    static final int MWSTATUS_START_RANK = 2;
    private int idAddrType;
    private short idDataType;
    private short quantity;
    private char locPrfx;
    private char sizPrfx;
    private int block;
    private int offset;
    private int bus;
    private int drop;
    private int rack;
    private int slot;
    private int chan;
    private int rank;
    private boolean fMultipleRanks;
    private int index;
    private int size;
    private int bit;
    private boolean fImpliedX;
    private boolean fIndexedAddr;
    private boolean fExtractedBit;
    private boolean fEBoolVar;

    private AddressUMAS() {
    }

    private void setBOLAddress(int n, int n2, int n3) {
        this.idAddrType = 2;
        this.block = n;
        this.offset = n2;
        if (n3 >= 0) {
            this.fExtractedBit = true;
            this.bit = n3;
        }
    }

    private void setDirectAddress(String string) throws InvalidAddressException, IllegalReferenceTypeException {
        try {
            int n = 0;
            String string2 = string.toUpperCase();
            if (string2.charAt(n++) != '%') {
                throw new InvalidAddressException(string);
            }
            this.locPrfx = string2.charAt(n++);
            this.sizPrfx = string2.charAt(n);
            if (Character.isDigit(this.sizPrfx) || this.sizPrfx == '\\') {
                this.fImpliedX = true;
                this.sizPrfx = (char)88;
            } else {
                ++n;
            }
            if (AddressUMAS.isTopologicalAddress(string2)) {
                this.idAddrType = 1;
                this.block = AddressUMAS.getIOObjectType(this.locPrfx, this.sizPrfx);
                if (string2.charAt(n) == '\\') {
                    int n2 = string2.indexOf(92, n + 1);
                    int n3 = string2.indexOf(46, n + 1);
                    if (n3 < 0 || n3 > n2) {
                        this.drop = Integer.parseInt(string2.substring(n + 1, n2));
                    } else {
                        this.bus = Integer.parseInt(string2.substring(n + 1, n3));
                        this.drop = Integer.parseInt(string2.substring(n3 + 1, n2));
                    }
                    n = n2 + 1;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(n), ".");
                this.rack = Integer.parseInt(stringTokenizer.nextToken());
                this.slot = Integer.parseInt(stringTokenizer.nextToken());
                this.chan = Integer.parseInt(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3.equals("ERR")) {
                        if (this.block != 1) {
                            throw new InvalidAddressException(string);
                        }
                        this.block = 0;
                    } else {
                        this.rank = Integer.parseInt(string3);
                        if (this.block == 5 && this.rank >= 2) {
                            this.block = 6;
                        }
                    }
                }
                if (stringTokenizer.hasMoreTokens()) {
                    this.fExtractedBit = true;
                    if (this.sizPrfx != 'W') {
                        throw new InvalidAddressException(string);
                    }
                    this.bit = Integer.parseInt(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens() || this.bus < 0 || this.bus > 65535 || this.drop < 0 || this.drop > 65535 || this.rack < 0 || this.rack > 65535 || this.slot < 0 || this.slot > 65535 || this.chan < 0 || this.chan > 999 || this.rank < 0 || this.rank > 999 || this.bit < 0 || this.bit > 15) {
                    throw new InvalidAddressException(string);
                }
            } else {
                this.idAddrType = 0;
                int n4 = string2.lastIndexOf(46);
                if (n4 > 0) {
                    this.fExtractedBit = true;
                    if (this.sizPrfx != 'W') {
                        throw new InvalidAddressException(string);
                    }
                    this.bit = Integer.parseInt(string2.substring(n4 + 1));
                    string2 = string2.substring(0, n4);
                }
                if ((n4 = string2.lastIndexOf("[")) > 0) {
                    this.fIndexedAddr = true;
                    int n5 = string2.length() - 1;
                    if (string2.charAt(n5) != ']') {
                        throw new InvalidAddressException(string);
                    }
                    this.index = Integer.parseInt(string2.substring(n4 + 1, n5));
                    this.size = this.sizPrfx == 'D' || this.sizPrfx == 'F' ? 2 : 1;
                    string2 = string2.substring(0, n4);
                }
                this.block = AddressUMAS.getSTDObjectType(this.locPrfx, this.sizPrfx);
                this.offset = Integer.parseInt(string2.substring(n));
                if (this.offset < 0 || this.offset > 65535 || this.index < 0 || this.index > 65535 || this.bit < 0 || this.bit > 15) {
                    throw new InvalidAddressException(string);
                }
            }
        }
        catch (InvalidAddressException invalidAddressException) {
            throw invalidAddressException;
        }
        catch (IllegalReferenceTypeException illegalReferenceTypeException) {
            throw illegalReferenceTypeException;
        }
        catch (Exception exception) {
            throw new InvalidAddressException(string);
        }
    }

    final int getAddressType() {
        return this.idAddrType;
    }

    final short getDataType() {
        return this.idDataType;
    }

    final short getQuantity() {
        return this.quantity;
    }

    final int getBlock() {
        return this.block;
    }

    final int getOffset() {
        return this.offset;
    }

    final int getBaseOffset() {
        return this.offset >> 8 & 0xFFFF;
    }

    final short getRelOffset() {
        return (short)(this.offset & 0xFF);
    }

    final byte getObjectType() {
        return (byte)this.block;
    }

    final int getAddress() {
        return this.offset + this.size * this.index;
    }

    final boolean isBitAddress() {
        return this.fExtractedBit;
    }

    final int getBitNumber() {
        return this.bit;
    }

    final int getBus() {
        return this.bus;
    }

    final int getDrop() {
        return this.drop;
    }

    final int getRack() {
        return this.rack;
    }

    final int getSlot() {
        return this.slot;
    }

    final int getChannel() {
        return this.chan;
    }

    final int getRank() {
        if (this.getObjectType() == 6) {
            return this.rank - 2;
        }
        return this.rank;
    }

    final boolean isMultipleRanks() {
        return this.fMultipleRanks;
    }

    final int getObjectSize() {
        switch (this.sizPrfx) {
            case 'X': {
                return 1;
            }
            case 'W': {
                return 2;
            }
            case 'D': {
                return 4;
            }
            case 'F': {
                return 4;
            }
            case 'L': {
                return 8;
            }
        }
        return 1;
    }

    final boolean isBytes() {
        return this.idDataType != 0 && this.idDataType != 1 && DT.getSize(this.idDataType) == 1;
    }

    final boolean isIOMemoryObject() {
        switch (this.getObjectType()) {
            case 5: 
            case 6: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    final boolean isEBoolVar() {
        return this.fEBoolVar;
    }

    final void increment() {
        if (this.fIndexedAddr) {
            ++this.index;
        } else if (this.fExtractedBit) {
            ++this.bit;
        } else if (this.idAddrType == 0) {
            this.offset += (this.getObjectSize() + 1) / 2;
        } else if (this.isIOMemoryObject()) {
            ++this.rank;
        } else {
            ++this.chan;
        }
    }

    final short[] getCompatibleDataTypes(boolean bl) {
        if (this.idAddrType == 2) {
            return new short[]{this.idDataType};
        }
        if (this.fExtractedBit) {
            return new short[]{1};
        }
        switch (this.sizPrfx) {
            case 'X': {
                return new short[]{1};
            }
            case 'W': {
                short[] sArray;
                if (bl) {
                    short[] sArray2 = new short[5];
                    sArray2[0] = 4;
                    sArray2[1] = 5;
                    sArray2[2] = 2;
                    sArray2[3] = 3;
                    sArray = sArray2;
                    sArray2[4] = 9;
                } else {
                    short[] sArray3 = new short[2];
                    sArray3[0] = 4;
                    sArray = sArray3;
                    sArray3[1] = 5;
                }
                return sArray;
            }
            case 'D': {
                return new short[]{6, 7, 10, 14, 15};
            }
            case 'F': {
                return new short[]{8};
            }
        }
        return new short[]{0};
    }

    public String toString() {
        return this.toString(false);
    }

    final String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.idAddrType == 2) {
            stringBuffer.append('@');
            stringBuffer.append(this.block);
            stringBuffer.append(':');
            stringBuffer.append(this.offset);
        } else {
            stringBuffer.append('%');
            stringBuffer.append(this.locPrfx);
            if (this.sizPrfx != 'X') {
                stringBuffer.append(this.sizPrfx);
            } else if (!this.fImpliedX && !bl) {
                stringBuffer.append(this.sizPrfx);
            }
            if (this.idAddrType == 0) {
                stringBuffer.append(bl ? this.getAddress() : this.getOffset());
            } else {
                if (this.bus != 0 || this.drop != 0) {
                    stringBuffer.append('\\');
                    stringBuffer.append(this.bus);
                    stringBuffer.append('.');
                    stringBuffer.append(this.drop);
                    stringBuffer.append('\\');
                }
                stringBuffer.append(this.rack);
                stringBuffer.append('.');
                stringBuffer.append(this.slot);
                stringBuffer.append('.');
                stringBuffer.append(this.chan);
                if (this.rank > 0 || this.fExtractedBit) {
                    stringBuffer.append('.');
                    stringBuffer.append(this.rank);
                }
            }
            if (this.fIndexedAddr && !bl) {
                stringBuffer.append('[');
                stringBuffer.append(this.index);
                stringBuffer.append(']');
            }
            if (this.fExtractedBit && !bl) {
                stringBuffer.append('.');
                stringBuffer.append(this.bit);
            }
        }
        return stringBuffer.toString();
    }

    private static boolean isTopologicalAddress(String string) {
        int n = string.indexOf(46);
        if (n > 0) {
            try {
                return string.indexOf(46, n + 1) >= 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static byte getIOObjectType(char c, char c2) throws IllegalReferenceTypeException {
        switch (c) {
            case 'M': {
                switch (c2) {
                    case 'D': 
                    case 'W': {
                        return 5;
                    }
                }
                throw new IllegalReferenceTypeException("InvalidSize");
            }
            case 'K': {
                switch (c2) {
                    case 'D': 
                    case 'W': {
                        return 10;
                    }
                }
                throw new IllegalReferenceTypeException("InvalidSize");
            }
            case 'I': {
                switch (c2) {
                    case 'X': {
                        return 1;
                    }
                    case 'D': 
                    case 'W': {
                        return 3;
                    }
                }
                throw new IllegalReferenceTypeException("InvalidSize");
            }
            case 'Q': {
                switch (c2) {
                    case 'X': {
                        return 2;
                    }
                    case 'D': 
                    case 'W': {
                        return 4;
                    }
                }
                throw new IllegalReferenceTypeException("InvalidSize");
            }
        }
        throw new IllegalReferenceTypeException("UnknownType");
    }

    private static byte getSTDObjectType(char c, char c2) throws IllegalReferenceTypeException {
        switch (c) {
            case 'M': {
                switch (c2) {
                    case 'X': {
                        return 2;
                    }
                    case 'W': {
                        return 3;
                    }
                    case 'D': {
                        return 38;
                    }
                    case 'F': {
                        return 40;
                    }
                }
                throw new IllegalReferenceTypeException("InvalidSize");
            }
            case 'S': {
                switch (c2) {
                    case 'X': {
                        return 0;
                    }
                    case 'W': {
                        return 1;
                    }
                    case 'D': {
                        return 37;
                    }
                }
                throw new IllegalReferenceTypeException("InvalidSize");
            }
            case 'K': {
                switch (c2) {
                    case 'W': {
                        return 4;
                    }
                    case 'D': {
                        return 39;
                    }
                }
                throw new IllegalReferenceTypeException("InvalidSize");
            }
            case 'I': {
                switch (c2) {
                    case 'X': {
                        return 5;
                    }
                    case 'W': {
                        return 6;
                    }
                }
                throw new IllegalReferenceTypeException("InvalidSize");
            }
        }
        throw new IllegalReferenceTypeException("UnknownType");
    }

    private static void setAddressDataType(AddressUMAS addressUMAS, short s) throws IllegalReferenceTypeException {
        short[] sArray = addressUMAS.getCompatibleDataTypes(addressUMAS.idAddrType == 0);
        if (s == 0) {
            addressUMAS.idDataType = sArray[0];
        } else {
            addressUMAS.idDataType = 0;
            for (int i = 0; i < sArray.length; ++i) {
                if (s != sArray[i]) continue;
                addressUMAS.idDataType = s;
                break;
            }
            if (addressUMAS.idDataType == 0) {
                throw new IllegalReferenceTypeException("MismatchDT");
            }
        }
    }

    static AddressUMAS parse(String string) throws FCIOException {
        AddressUMAS addressUMAS = new AddressUMAS();
        addressUMAS.setDirectAddress(string.trim());
        return addressUMAS;
    }

    static AddressUMAS parse(Request request, VarLookupInterface varLookupInterface) throws FCIOException {
        AddressUMAS addressUMAS = new AddressUMAS();
        String string = request.getAddress().trim();
        if (string.length() == 0) {
            throw new InvalidAddressException(request.getAddress());
        }
        if (string.charAt(0) == '%') {
            addressUMAS.setDirectAddress(string);
            AddressUMAS.setAddressDataType(addressUMAS, request.getDatatype());
            addressUMAS.quantity = request.getQuantity();
            addressUMAS.fMultipleRanks = request.isMultipleRanks();
        } else {
            VarInfo varInfo;
            if (varLookupInterface == null) {
                throw new InvalidSymbolTableException();
            }
            try {
                varInfo = varLookupInterface.get(string);
            }
            catch (Exception exception) {
                throw new FCIOException(exception.getMessage());
            }
            if (varInfo == null) {
                throw new NotFoundException(string);
            }
            short s = DT.getNumericDataType(varInfo.getDataType());
            long l = varInfo.getSymbolID();
            if (l == 0L) {
                addressUMAS.setDirectAddress(varInfo.getAddress());
                AddressUMAS.setAddressDataType(addressUMAS, s);
            } else {
                int n = (int)(l >> 32);
                int n2 = (int)l;
                int n3 = -1;
                if (varInfo.getSymbolType() == 1) {
                    AddressUMAS addressUMAS2 = AddressUMAS.parse(varInfo.getAddress());
                    if (addressUMAS2.isBitAddress()) {
                        n3 = addressUMAS2.getBitNumber();
                        AddressUMAS.setAddressDataType(addressUMAS2, s);
                    } else if (addressUMAS2.sizPrfx == 'X') {
                        addressUMAS.fEBoolVar = true;
                    }
                }
                addressUMAS.setBOLAddress(n, n2 + varInfo.getOffset(), n3);
                addressUMAS.idDataType = s;
            }
            if (addressUMAS.idDataType == 9) {
                if (addressUMAS.idAddrType == 1) {
                    throw new UnsupportedDataTypeException(DT.toName((short)9));
                }
                addressUMAS.quantity = (short)Math.min(varInfo.getMaxStrLen(), request.getQuantity());
            } else {
                addressUMAS.quantity = 1;
            }
        }
        return addressUMAS;
    }
}

