/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.namespace;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class VerInfo
implements Serializable {
    static final long serialVersionUID = 7083793897468646863L;
    private static final int VER_USER = 0;
    private static final int VER_CID = 1;
    private static final int VER_MID = 2;
    private static final int VER_LID = 3;
    private static final int VER_DID = 4;
    private static final int N_VER = 5;
    private static final long Jan_1_1984;
    private String value;

    public VerInfo() {
        this.value = new String();
    }

    public VerInfo(String string) {
        this.value = string;
    }

    public VerInfo(String string, long l, int n) {
        long l2 = (long)n * 86400000L + l;
        this.value = string + ":" + l2;
    }

    public VerInfo(String string, String string2) {
        this.value = string + ":" + string2;
    }

    public VerInfo(String string, String string2, int n, int n2, int n3, int n4) {
        this.value = string + ":" + string2 + "/" + n + "/" + n2 + "/" + n3 + "/" + n4;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        VerInfo verInfo = (VerInfo)object;
        return this.value.equalsIgnoreCase(verInfo.value);
    }

    public boolean symbolVerSame(VerInfo verInfo) {
        if (verInfo == null) {
            return false;
        }
        try {
            String[] stringArray = this.getUnityVersionSignature();
            String[] stringArray2 = verInfo.getUnityVersionSignature();
            return stringArray[1].equals(stringArray2[1]) && stringArray[3].equals(stringArray2[3]) && stringArray[4].equals(stringArray2[4]);
        }
        catch (Exception exception) {
            return this.equals(verInfo);
        }
    }

    public String toString() {
        return this.value;
    }

    public String toDisplayString() {
        int n = this.value.indexOf(58) + 1;
        try {
            long l = Long.parseLong(this.value.substring(n));
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
            return this.value.substring(0, n) + dateFormat.format(new Date(l + Jan_1_1984));
        }
        catch (Exception exception) {
            try {
                String[] stringArray = this.getUnityVersionSignature();
                return this.value.substring(0, n) + stringArray[0];
            }
            catch (Exception exception2) {
                return this.value;
            }
        }
    }

    public void writeData(PrintWriter printWriter) throws IOException {
        printWriter.println("|" + this.value);
    }

    public boolean readData(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        if (string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        try {
            this.value = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        return true;
    }

    private String[] getUnityVersionSignature() {
        String string = this.value.substring(this.value.indexOf(58) + 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        String[] stringArray = new String[5];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    static {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(1984, 0, 1, 0, 0, 0);
        Jan_1_1984 = gregorianCalendar.getTime().getTime();
    }
}

