# Script for converting logical segment and equipment numbering from version 1 to version 2. To be used with sed.
# Save as formatted text file (*.prn) and call d2u <filename> to remove CRs.
#
# Rename Logical Segments:
s%"20030"%"20030XXX"%g
s%"20029"%"20030"%g
s%"20030XXX"%"20029"%g
s%"20425"%"20420"%g
s%"20520"%"20421"%g
s%"20605"%"20620"%g
s%"20606"%"20621"%g
#
# Tag old equipment codes (prefix with XXX):
s%\(2[0-9][0-9][0-9][0-9]/[0-9][0-9][0-9][0-9]\)%XXX\1%g
#
# Rename and untag Equipment Codes:
s%XXX20605/40019999%2---%g
s%XXX20605/4004%2---%g
s%XXX20606/4004%2---%g
s%XXX20606/4201%2---%g
s%XXX20605/5004%2---%g
s%XXX20606/5004%2---%g
s%XXX20719/0001%2---%g
s%XXX20030/0010%20029/2007%g
s%XXX20030/0011%20029/2008%g
s%XXX20030/0012%20029/2009%g
s%XXX20030/0020%20029/2010%g
s%XXX20030/0030%20029/2011%g
s%XXX20030/0035%20029/2012%g
s%XXX20030/0036%20029/2013%g
s%XXX20030/0040%20029/2014%g
s%XXX20030/0041%20029/2015%g
s%XXX20030/0042%20029/2016%g
s%XXX20030/0043%20029/2017%g
s%XXX20030/0044%20029/2018%g
s%XXX20030/0110%20029/2019%g
s%XXX20030/0112%20029/2020%g
s%XXX20030/0115%20029/2021%g
s%XXX20030/0120%20029/2022%g
s%XXX20030/0121%20029/2023%g
s%XXX20030/0122%20029/2024%g
s%XXX20030/0123%20029/2025%g
s%XXX20030/0124%20029/2026%g
s%XXX20030/0125%20029/2027%g
s%XXX20030/0165%20029/2028%g
s%XXX20030/0160%20029/2029%g
s%XXX20030/0270%20029/2030%g
s%XXX20030/0170%20029/2031%g
s%XXX20030/0175%20029/2032%g
s%XXX20030/0176%20029/2033%g
s%XXX20030/0275%20029/2034%g
s%XXX20030/0276%20029/2035%g
s%XXX20029/0010%20030/2107%g
s%XXX20029/0011%20030/2108%g
s%XXX20029/0015%20030/2109%g
s%XXX20029/0012%20030/2110%g
s%XXX20029/0025%20030/2111%g
s%XXX20029/0020%20030/2112%g
s%XXX20029/0030%20030/2113%g
s%XXX20029/0035%20030/2114%g
s%XXX20029/0036%20030/2115%g
s%XXX20029/0040%20030/2116%g
s%XXX20029/0041%20030/2117%g
s%XXX20029/0042%20030/2118%g
s%XXX20029/0043%20030/2119%g
s%XXX20029/0044%20030/2120%g
s%XXX20029/0110%20030/2121%g
s%XXX20029/0111%20030/2122%g
s%XXX20029/0112%20030/2123%g
s%XXX20029/0115%20030/2124%g
s%XXX20029/0120%20030/2125%g
s%XXX20029/0121%20030/2126%g
s%XXX20029/0122%20030/2127%g
s%XXX20029/0123%20030/2128%g
s%XXX20029/0124%20030/2129%g
s%XXX20029/0125%20030/2130%g
s%XXX20029/0165%20030/2131%g
s%XXX20029/0160%20030/2132%g
s%XXX20029/0270%20030/2133%g
s%XXX20029/0170%20030/2134%g
s%XXX20029/0175%20030/2135%g
s%XXX20029/0176%20030/2136%g
s%XXX20029/0275%20030/2137%g
s%XXX20029/0276%20030/2138%g
s%XXX20425/0030%20420/0001%g
s%XXX20425/0035%20420/0002%g
s%XXX20425/0036%20420/0003%g
s%XXX20425/0037%20420/0004%g
s%XXX20425/0040%20420/0005%g
s%XXX20425/0045%20420/0006%g
s%XXX20425/0046%20420/0007%g
s%XXX20425/0050%20420/0008%g
s%XXX20425/0051%20420/0009%g
s%XXX20425/0053%20420/0010%g
s%XXX20425/0054%20420/0011%g
s%XXX20425/0055%20420/0012%g
s%XXX20425/0056%20420/0013%g
s%XXX20425/0057%20420/0014%g
s%XXX20425/0060%20420/0015%g
s%XXX20425/0065%20420/0016%g
s%XXX20425/0066%20420/0017%g
s%XXX20425/0061%20420/0018%g
s%XXX20425/0062%20420/0019%g
s%XXX20425/0110%20420/2007%g
s%XXX20425/0111%20420/2008%g
s%XXX20425/0112%20420/2009%g
s%XXX20425/0125%20420/2010%g
s%XXX20425/0010%20420/2107%g
s%XXX20425/0011%20420/2108%g
s%XXX20425/0012%20420/2109%g
s%XXX20425/0025%20420/2110%g
s%XXX20520/0525%20421/0001%g
s%XXX20520/0530%20421/0002%g
s%XXX20520/0532%20421/0003%g
s%XXX20520/0533%20421/0004%g
s%XXX20520/0534%20421/0005%g
s%XXX20000/0000%20421/0006%g
s%XXX20520/0535%20421/0007%g
s%XXX20520/0541%20421/0008%g
s%XXX20520/0542%20421/0009%g
s%XXX20520/0543%20421/0010%g
s%XXX20520/0544%20421/0011%g
s%XXX20520/0545%20421/0012%g
s%XXX20520/0550%20421/0013%g
s%XXX20520/0555%20421/0014%g
s%XXX20520/0560%20421/0015%g
s%XXX20520/0562%20421/0016%g
s%XXX20520/0563%20421/0017%g
s%XXX20520/0564%20421/0018%g
s%XXX20520/0565%20421/0019%g
s%XXX20000/0000%20421/0021%g
s%XXX20520/0568%20421/0020%g
s%XXX20520/0569%20421/0022%g
s%XXX20520/0570%20421/0023%g
s%XXX20520/0571%20421/0024%g
s%XXX20520/0572%20421/0025%g
s%XXX20520/0573%20421/0026%g
s%XXX20520/0574%20421/0027%g
s%XXX20520/0575%20421/0028%g
s%XXX20520/0601%20421/2001%g
s%XXX20520/0602%20421/2002%g
s%XXX20520/0603%20421/2003%g
s%XXX20520/0605%20421/2004%g
s%XXX20520/0606%20421/2005%g
s%XXX20520/0610%20421/2006%g
s%XXX20520/0711%20421/2101%g
s%XXX20520/0712%20421/2102%g
s%XXX20520/0713%20421/2103%g
s%XXX20520/0714%20421/2104%g
s%XXX20520/0715%20421/2105%g
s%XXX20520/0716%20421/2106%g
s%XXX20520/0717%20421/2107%g
s%XXX20520/0718%20421/2108%g
s%XXX20520/0719%20421/2109%g
s%XXX20520/0720%20421/2110%g
s%XXX20520/0721%20421/2111%g
s%XXX20520/0722%20421/2112%g
s%XXX20520/0723%20421/2113%g
s%XXX20520/0724%20421/2114%g
s%XXX20520/0725%20421/2115%g
s%XXX20520/0726%20421/2116%g
s%XXX20520/0730%20421/2117%g
s%XXX20520/0731%20421/2118%g
s%XXX20520/0732%20421/2119%g
s%XXX20520/0740%20421/2120%g
s%XXX20520/0735%20421/2121%g
s%XXX20520/0845%20421/2122%g
s%XXX20520/0745%20421/2123%g
s%XXX20520/0750%20421/2124%g
s%XXX20520/0751%20421/2125%g
s%XXX20520/0850%20421/2126%g
s%XXX20520/0851%20421/2127%g
s%XXX20520/0510%20421/2201%g
s%XXX20520/0515%20421/2202%g
s%XXX20520/0517%20421/2203%g
s%XXX20520/0518%20421/2204%g
s%XXX20520/0516%20421/2205%g
s%XXX20520/0520%20421/2206%g
s%XXX20520/0556%20421/8001%g
s%XXX20520/0557%20421/8002%g
s%XXX20520/0558%20421/8003%g
s%XXX20605/0001%20620/0001%g
s%XXX20605/2101%20620/0101%g
s%XXX20605/2102%20620/0102%g
s%XXX20605/2103%20620/0103%g
s%XXX20605/2104%20620/0104%g
s%XXX20605/2105%20620/0105%g
s%XXX20000/0000%20620/0106%g
s%XXX20605/2201%20620/0201%g
s%XXX20605/2202%20620/0202%g
s%XXX20605/2203%20620/0203%g
s%XXX20605/2204%20620/0204%g
s%XXX20605/2205%20620/0205%g
s%XXX20000/0000%20620/0206%g
s%XXX20605/2301%20620/0301%g
s%XXX20605/2302%20620/0302%g
s%XXX20605/2303%20620/0303%g
s%XXX20605/2304%20620/0304%g
s%XXX20605/2305%20620/0305%g
s%XXX20000/0000%20620/0306%g
s%XXX20605/2401%20620/0401%g
s%XXX20605/2402%20620/0402%g
s%XXX20605/2403%20620/0403%g
s%XXX20605/2404%20620/0404%g
s%XXX20605/2405%20620/0405%g
s%XXX20000/0000%20620/0406%g
s%XXX20605/4001%20620/1035%g
s%XXX20605/5001%20620/1036%g
s%XXX20605/2701%20620/1101%g
s%XXX20605/2702%20620/1102%g
s%XXX20605/2703%20620/1103%g
s%XXX20605/2704%20620/1104%g
s%XXX20605/2705%20620/1105%g
s%XXX20000/0000%20620/1106%g
s%XXX20605/4002%20620/1135%g
s%XXX20605/5002%20620/1136%g
s%XXX20605/2601%20620/1201%g
s%XXX20605/2602%20620/1202%g
s%XXX20605/2603%20620/1203%g
s%XXX20605/2604%20620/1204%g
s%XXX20605/2605%20620/1205%g
s%XXX20000/0000%20620/1206%g
s%XXX20605/4003%20620/1227%g
s%XXX20605/5003%20620/1228%g
s%XXX20605/2501%20620/1401%g
s%XXX20605/2502%20620/1402%g
s%XXX20605/2503%20620/1403%g
s%XXX20605/2504%20620/1404%g
s%XXX20605/2505%20620/1405%g
s%XXX20000/0000%20620/1406%g
s%XXX20605/4005%20620/1434%g
s%XXX20605/5005%20620/1435%g
s%XXX20605/4006%20620/1534%g
s%XXX20605/5006%20620/1535%g
s%XXX20605/4007%20620/1624%g
s%XXX20605/5007%20620/1625%g
s%XXX20605/4008%20620/1723%g
s%XXX20605/5008%20620/1724%g
s%XXX20000/0000%20620/2001%g
s%XXX20605/2801%20620/2002%g
s%XXX20605/2802%20620/2003%g
s%XXX20605/2803%20620/2004%g
s%XXX20605/2804%20620/2005%g
s%XXX20605/2805%20620/2006%g
s%XXX20605/4011%20620/2038%g
s%XXX20605/5011%20620/2039%g
s%XXX20605/4012%20620/2141%g
s%XXX20605/5012%20620/2142%g
s%XXX20605/0025%20620/3012%g
s%XXX20605/5025%20620/3013%g
s%XXX20605/5027%20620/3106%g
s%XXX20605/4026%20620/3212%g
s%XXX20605/5026%20620/3213%g
s%XXX20605/5029%20620/3306%g
s%XXX20605/5028%20620/3406%g
s%XXX20605/5030%20620/3506%g
s%XXX20605/5032%20620/3606%g
s%XXX20605/5033%20620/3706%g
s%XXX20605/5034%20620/3806%g
s%XXX20605/5035%20620/3906%g
s%XXX20605/5036%20620/4006%g
s%XXX20605/5031%20620/4106%g
s%XXX20605/4037%20620/4213%g
s%XXX20605/5037%20620/4214%g
s%XXX20605/5038%20620/4306%g
s%XXX20605/4039%20620/4412%g
s%XXX20605/5039%20620/4413%g
s%XXX20605/4042%20620/4512%g
s%XXX20605/5040%20620/4513%g
s%XXX20605/4041%20620/4615%g
s%XXX20605/5041%20620/4616%g
s%XXX20605/2901%20620/5001%g
s%XXX20605/2902%20620/5002%g
s%XXX20605/2903%20620/5003%g
s%XXX20605/2904%20620/5004%g
s%XXX20605/2905%20620/5005%g
s%XXX20000/0000%20620/5006%g
s%XXX20605/4013%20620/5130%g
s%XXX20605/5013%20620/5131%g
s%XXX20606/0001%20621/0001%g
s%XXX20606/2101%20621/0101%g
s%XXX20606/2102%20621/0102%g
s%XXX20606/2103%20621/0103%g
s%XXX20606/2104%20621/0104%g
s%XXX20606/2105%20621/0105%g
s%XXX20000/0000%20621/0106%g
s%XXX20606/2201%20621/0201%g
s%XXX20606/2202%20621/0202%g
s%XXX20606/2203%20621/0203%g
s%XXX20606/2204%20621/0204%g
s%XXX20606/2205%20621/0205%g
s%XXX20000/0000%20621/0206%g
s%XXX20606/2301%20621/0301%g
s%XXX20606/2302%20621/0302%g
s%XXX20606/2303%20621/0303%g
s%XXX20606/2304%20621/0304%g
s%XXX20606/2305%20621/0305%g
s%XXX20000/0000%20621/0306%g
s%XXX20606/2401%20621/0401%g
s%XXX20606/2402%20621/0402%g
s%XXX20606/2403%20621/0403%g
s%XXX20606/2404%20621/0404%g
s%XXX20606/2405%20621/0405%g
s%XXX20000/0000%20621/0406%g
s%XXX20606/2701%20621/1001%g
s%XXX20606/2702%20621/1002%g
s%XXX20606/2703%20621/1003%g
s%XXX20606/2704%20621/1004%g
s%XXX20606/2705%20621/1005%g
s%XXX20000/0000%20621/1006%g
s%XXX20606/4001%20621/1033%g
s%XXX20606/5001%20621/1034%g
s%XXX20606/4002%20621/1133%g
s%XXX20606/5002%20621/1134%g
s%XXX20606/2601%20621/1201%g
s%XXX20606/2602%20621/1202%g
s%XXX20606/2603%20621/1203%g
s%XXX20606/2604%20621/1204%g
s%XXX20606/2605%20621/1205%g
s%XXX20000/0000%20621/1206%g
s%XXX20606/4003%20621/1225%g
s%XXX20606/5003%20621/1226%g
s%XXX20606/4005%20621/1432%g
s%XXX20606/5005%20621/1433%g
s%XXX20606/2501%20621/1501%g
s%XXX20606/2502%20621/1502%g
s%XXX20606/2503%20621/1503%g
s%XXX20606/2504%20621/1504%g
s%XXX20606/2505%20621/1505%g
s%XXX20000/0000%20621/1506%g
s%XXX20606/4006%20621/1532%g
s%XXX20606/5006%20621/1533%g
s%XXX20606/4007%20621/1622%g
s%XXX20606/5007%20621/1623%g
s%XXX20606/4008%20621/1721%g
s%XXX20606/5008%20621/1722%g
s%XXX20606/4011%20621/2036%g
s%XXX20606/5011%20621/2037%g
s%XXX20000/0000%20621/2101%g
s%XXX20606/2801%20621/2102%g
s%XXX20606/2802%20621/2103%g
s%XXX20606/2803%20621/2104%g
s%XXX20606/2804%20621/2105%g
s%XXX20606/2805%20621/2106%g
s%XXX20606/4012%20621/2139%g
s%XXX20606/5012%20621/2140%g
s%XXX20606/0025%20621/3010%g
s%XXX20606/5025%20621/3011%g
s%XXX20606/0006%20621/3103%g
s%XXX20000/0000%20621/3104%g
s%XXX20606/5027%20621/3105%g
s%XXX20606/4026%20621/3210%g
s%XXX20606/5026%20621/3211%g
s%XXX20606/5129%20621/3303%g
s%XXX20000/0000%20621/3304%g
s%XXX20606/5029%20621/3305%g
s%XXX20606/5128%20621/3403%g
s%XXX20000/0000%20621/3404%g
s%XXX20606/5028%20621/3405%g
s%XXX20606/5130%20621/3503%g
s%XXX20000/0000%20621/3504%g
s%XXX20606/5030%20621/3505%g
s%XXX20606/5132%20621/3603%g
s%XXX20000/0000%20621/3604%g
s%XXX20606/5032%20621/3605%g
s%XXX20606/5133%20621/3703%g
s%XXX20000/0000%20621/3704%g
s%XXX20606/5033%20621/3705%g
s%XXX20606/5134%20621/3803%g
s%XXX20000/0000%20621/3804%g
s%XXX20606/5034%20621/3805%g
s%XXX20606/5135%20621/3903%g
s%XXX20000/0000%20621/3904%g
s%XXX20606/5035%20621/3905%g
s%XXX20606/5136%20621/4003%g
s%XXX20000/0000%20621/4004%g
s%XXX20606/5036%20621/4005%g
s%XXX20606/5131%20621/4103%g
s%XXX20000/0000%20621/4104%g
s%XXX20606/5031%20621/4105%g
s%XXX20606/4037%20621/4211%g
s%XXX20606/5037%20621/4212%g
s%XXX20606/5138%20621/4303%g
s%XXX20000/0000%20621/4304%g
s%XXX20606/5038%20621/4305%g
s%XXX20606/4039%20621/4410%g
s%XXX20606/5039%20621/4411%g
s%XXX20606/4042%20621/4510%g
s%XXX20606/5040%20621/4511%g
s%XXX20606/4041%20621/4613%g
s%XXX20606/5041%20621/4614%g
s%XXX20606/2901%20621/5001%g
s%XXX20606/2902%20621/5002%g
s%XXX20606/2903%20621/5003%g
s%XXX20606/2904%20621/5004%g
s%XXX20606/2905%20621/5005%g
s%XXX20000/0000%20621/5006%g
s%XXX20606/4013%20621/5128%g
s%XXX20606/5013%20621/5129%g
s%XXX20724/0001%20724/0001%g
s%XXX20724/0002%20724/2401%g
s%XXX20724/0005%20724/2402%g
s%XXX20724/0010%20724/2403%g
s%XXX20724/0011%20724/2404%g
s%XXX20724/0015%20724/2405%g
s%XXX20724/0016%20724/2406%g
s%XXX20724/0111%20724/2407%g
s%XXX20724/0115%20724/2408%g
s%XXX20724/0116%20724/2409%g
s%XXX20726/0001%20726/0001%g
s%XXX20726/0005%20726/2601%g
s%XXX20726/0006%20726/2602%g
s%XXX20727/0001%20727/0001%g
s%XXX20727/0002%20727/2701%g
s%XXX20727/0005%20727/2702%g
s%XXX20727/0010%20727/2703%g
s%XXX20727/0011%20727/2704%g
s%XXX20727/0015%20727/2705%g
s%XXX20727/0016%20727/2706%g
s%XXX20727/0111%20727/2707%g
s%XXX20727/0115%20727/2708%g
s%XXX20727/0116%20727/2709%g
s%XXX20728/0001%20728/0001%g
s%XXX20728/0005%20728/2801%g
s%XXX20728/0006%20728/2802%g
s%XXX20729/0001%20729/0001%g
s%XXX20729/0005%20729/2901%g
s%XXX20729/0006%20729/2902%g
s%XXX20731/0001%20731/0001%g
s%XXX20731/0005%20731/3101%g
s%XXX20731/0006%20731/3102%g
s%XXX20733/0001%20733/0001%g
s%XXX20733/0005%20733/3301%g
s%XXX20733/0006%20733/3302%g
s%XXX20734/0001%20734/0001%g
s%XXX20734/0005%20734/3401%g
s%XXX20734/0006%20734/3402%g
s%XXX20735/0001%20735/0001%g
s%XXX20735/0005%20735/3501%g
s%XXX20735/0006%20735/3502%g
s%XXX20736/0001%20736/0001%g
s%XXX20736/0005%20736/3601%g
s%XXX20736/0006%20736/3602%g
s%XXX20737/0001%20737/0001%g
s%XXX20737/0005%20737/3701%g
s%XXX20737/0006%20737/3702%g
s%XXX20738/0001%20738/0001%g
s%XXX20738/0005%20738/3801%g
s%XXX20738/0006%20738/3802%g
s%XXX20739/0001%20739/0001%g
s%XXX20739/0002%20739/3901%g
s%XXX20739/0005%20739/3902%g
s%XXX20739/0010%20739/3903%g
s%XXX20739/0011%20739/3904%g
s%XXX20739/0012%20739/3905%g
s%XXX20739/0015%20739/3906%g
s%XXX20739/0016%20739/3907%g
s%XXX20739/0112%20739/3908%g
s%XXX20739/0115%20739/3909%g
s%XXX20739/0116%20739/3910%g
s%XXX20740/0001%20740/0001%g
s%XXX20740/0005%20740/4001%g
s%XXX20740/0006%20740/4002%g
s%XXX20741/0001%20741/0001%g
s%XXX20741/0002%20741/4101%g
s%XXX20741/0005%20741/4102%g
s%XXX20741/0010%20741/4103%g
s%XXX20741/0012%20741/4104%g
s%XXX20741/0025%20741/4105%g
s%XXX20741/0026%20741/4106%g
s%XXX20741/0112%20741/4107%g
s%XXX20741/0125%20741/4108%g
s%XXX20741/0126%20741/4109%g
s%XXX20742/0001%20742/0001%g
s%XXX20742/0002%20742/4201%g
s%XXX20742/0005%20742/4202%g
s%XXX20742/0010%20742/4203%g
s%XXX20742/0011%20742/4204%g
s%XXX20742/0015%20742/4205%g
s%XXX20742/0016%20742/4206%g
s%XXX20742/0111%20742/4207%g
s%XXX20742/0115%20742/4208%g
s%XXX20742/0116%20742/4209%g
s%XXX20743/0001%20743/0001%g
s%XXX20743/0002%20743/4301%g
s%XXX20743/0005%20743/4302%g
s%XXX20743/0015%20743/4303%g
s%XXX20743/0016%20743/4304%g
s%XXX20743/0020%20743/4305%g
s%XXX20743/0021%20743/4306%g
s%XXX20743/0022%20743/4307%g
s%XXX20743/0025%20743/4308%g
s%XXX20743/0026%20743/4309%g
s%XXX20743/0122%20743/4310%g
s%XXX20743/0125%20743/4311%g
s%XXX20743/0126%20743/4312%g
s%XXX20820/0001%20820/0001%g
s%XXX20820/0002%20820/0002%g
s%XXX20820/0003%20820/0003%g
s%XXX20820/0005%20820/0004%g
s%XXX20000/0000%20820/0005%g
s%XXX20820/0006%20820/0006%g
s%XXX20820/0007%20820/0007%g
s%XXX20820/0011%20820/0008%g
s%XXX20820/0012%20820/0009%g
s%XXX20820/0013%20820/0010%g
s%XXX20820/0014%20820/0011%g
s%XXX20820/0015%20820/0012%g
s%XXX20820/0016%20820/0013%g
s%XXX20820/0017%20820/0014%g
s%XXX20820/0018%20820/0015%g
s%XXX20820/0019%20820/0016%g
s%XXX20824/0101%20824/0101%g
s%XXX20824/0102%20824/0102%g
s%XXX20824/0111%20824/0111%g
s%XXX20824/0112%20824/0112%g
s%XXX20824/0201%20824/0201%g
s%XXX20824/0202%20824/0202%g
s%XXX20824/0211%20824/0211%g
s%XXX20824/0212%20824/0212%g
s%XXX20824/0301%20824/0301%g
s%XXX20824/0302%20824/0302%g
s%XXX20824/0311%20824/0311%g
s%XXX20824/0312%20824/0312%g
s%XXX20824/0401%20824/0401%g
s%XXX20824/0402%20824/0402%g
s%XXX20824/0411%20824/0411%g
s%XXX20824/0412%20824/0412%g
s%XXX20824/0501%20824/0501%g
s%XXX20824/0502%20824/0502%g
s%XXX20824/0511%20824/0511%g
s%XXX20824/0512%20824/0512%g
s%XXX20824/0601%20824/0601%g
s%XXX20824/0602%20824/0602%g
s%XXX20824/0611%20824/0611%g
s%XXX20824/0612%20824/0612%g
s%XXX20824/0701%20824/0701%g
s%XXX20824/0702%20824/0702%g
s%XXX20824/0711%20824/0711%g
s%XXX20824/0712%20824/0712%g
s%XXX20824/0801%20824/0801%g
s%XXX20824/0802%20824/0802%g
s%XXX20824/0811%20824/0811%g
s%XXX20824/0812%20824/0812%g
s%XXX20824/0901%20824/0901%g
s%XXX20824/0902%20824/0902%g
s%XXX20824/0911%20824/0911%g
s%XXX20824/0912%20824/0912%g
s%XXX20824/1001%20824/1001%g
s%XXX20824/1002%20824/1002%g
s%XXX20824/1011%20824/1011%g
s%XXX20824/1012%20824/1012%g
s%XXX20824/1101%20824/1101%g
s%XXX20824/1102%20824/1102%g
s%XXX20824/1111%20824/1111%g
s%XXX20824/1112%20824/1112%g
s%XXX20824/3010%20824/2107%g
s%XXX20824/3011%20824/2108%g
s%XXX20824/3012%20824/2109%g
s%XXX20824/3013%20824/2110%g
s%XXX20824/3017%20824/2111%g
s%XXX20824/3018%20824/2112%g
s%XXX20824/3025%20824/2113%g
s%XXX20824/3020%20824/2114%g
s%XXX20824/3030%20824/2115%g
s%XXX20824/3035%20824/2116%g
s%XXX20824/3036%20824/2117%g
s%XXX20824/3037%20824/2118%g
s%XXX20824/3040%20824/2119%g
s%XXX20824/3041%20824/2120%g
s%XXX20824/3042%20824/2121%g
s%XXX20824/3045%20824/2122%g
s%XXX20000/0000%20824/2123%g
s%XXX20824/3050%20824/2124%g
s%XXX20824/3055%20824/2125%g
s%XXX20824/0007%20824/2126%g
s%XXX20824/0008%20824/2127%g
s%XXX20824/0009%20824/2128%g
s%XXX20824/0010%20824/2129%g
s%XXX20824/0011%20824/2130%g
s%XXX20824/0012%20824/2131%g
s%XXX20824/0013%20824/2132%g
s%XXX20824/0014%20824/2133%g
s%XXX20824/0015%20824/2134%g
s%XXX20824/0016%20824/2135%g
s%XXX20824/0017%20824/2136%g
s%XXX20824/0018%20824/2137%g
s%XXX20000/0000%20824/2138%g
s%XXX20825/0101%20825/0101%g
s%XXX20825/0102%20825/0102%g
s%XXX20825/0111%20825/0111%g
s%XXX20825/0112%20825/0112%g
s%XXX20825/0201%20825/0201%g
s%XXX20825/0202%20825/0202%g
s%XXX20825/0211%20825/0211%g
s%XXX20825/0212%20825/0212%g
s%XXX20825/0301%20825/0301%g
s%XXX20825/0302%20825/0302%g
s%XXX20825/0311%20825/0311%g
s%XXX20825/0312%20825/0312%g
s%XXX20825/0401%20825/0401%g
s%XXX20825/0402%20825/0402%g
s%XXX20825/0411%20825/0411%g
s%XXX20825/0412%20825/0412%g
s%XXX20825/0501%20825/0501%g
s%XXX20825/0502%20825/0502%g
s%XXX20825/0511%20825/0511%g
s%XXX20825/0512%20825/0512%g
s%XXX20825/0601%20825/0601%g
s%XXX20825/0602%20825/0602%g
s%XXX20825/0611%20825/0611%g
s%XXX20825/0612%20825/0612%g
s%XXX20825/0701%20825/0701%g
s%XXX20825/0702%20825/0702%g
s%XXX20825/0711%20825/0711%g
s%XXX20825/0712%20825/0712%g
s%XXX20825/0801%20825/0801%g
s%XXX20825/0802%20825/0802%g
s%XXX20825/0811%20825/0811%g
s%XXX20825/0812%20825/0812%g
s%XXX20825/0901%20825/0901%g
s%XXX20825/0902%20825/0902%g
s%XXX20825/0911%20825/0911%g
s%XXX20825/0912%20825/0912%g
s%XXX20825/1001%20825/1001%g
s%XXX20825/1002%20825/1002%g
s%XXX20825/1011%20825/1011%g
s%XXX20825/1012%20825/1012%g
s%XXX20825/1101%20825/1101%g
s%XXX20825/1102%20825/1102%g
s%XXX20825/1111%20825/1111%g
s%XXX20825/1112%20825/1112%g
s%XXX20825/3010%20825/2007%g
s%XXX20825/3011%20825/2008%g
s%XXX20825/3012%20825/2009%g
s%XXX20825/3013%20825/2010%g
s%XXX20825/3018%20825/2011%g
s%XXX20825/3020%20825/2012%g
s%XXX20825/3030%20825/2013%g
s%XXX20825/3035%20825/2014%g
s%XXX20825/3036%20825/2015%g
s%XXX20825/3037%20825/2016%g
s%XXX20825/3040%20825/2017%g
s%XXX20825/3041%20825/2018%g
s%XXX20825/3042%20825/2019%g
s%XXX20825/3045%20825/2020%g
s%XXX20000/0000%20825/2021%g
s%XXX20825/3050%20825/2022%g
s%XXX20825/3055%20825/2023%g
s%XXX20825/0007%20825/2024%g
s%XXX20825/0008%20825/2025%g
s%XXX20825/0009%20825/2026%g
s%XXX20825/0010%20825/2027%g
s%XXX20825/0011%20825/2028%g
s%XXX20825/0012%20825/2029%g
s%XXX20825/0013%20825/2030%g
s%XXX20825/0014%20825/2031%g
s%XXX20825/0015%20825/2032%g
s%XXX20825/0016%20825/2033%g
s%XXX20825/0017%20825/2034%g
s%XXX20825/0018%20825/2035%g
s%XXX20000/0000%20825/2036%g
s%XXX20826/0101%20826/0101%g
s%XXX20826/0102%20826/0102%g
s%XXX20826/0111%20826/0111%g
s%XXX20826/0112%20826/0112%g
s%XXX20826/0201%20826/0201%g
s%XXX20826/0202%20826/0202%g
s%XXX20826/0211%20826/0211%g
s%XXX20826/0212%20826/0212%g
s%XXX20826/0301%20826/0301%g
s%XXX20826/0302%20826/0302%g
s%XXX20826/0311%20826/0311%g
s%XXX20826/0312%20826/0312%g
s%XXX20826/0401%20826/0401%g
s%XXX20826/0402%20826/0402%g
s%XXX20826/0411%20826/0411%g
s%XXX20826/0412%20826/0412%g
s%XXX20826/0501%20826/0501%g
s%XXX20826/0502%20826/0502%g
s%XXX20826/0511%20826/0511%g
s%XXX20826/0512%20826/0512%g
s%XXX20826/0601%20826/0601%g
s%XXX20826/0602%20826/0602%g
s%XXX20826/0611%20826/0611%g
s%XXX20826/0612%20826/0612%g
s%XXX20826/0701%20826/0701%g
s%XXX20826/0702%20826/0702%g
s%XXX20826/0711%20826/0711%g
s%XXX20826/0712%20826/0712%g
s%XXX20826/0801%20826/0801%g
s%XXX20826/0802%20826/0802%g
s%XXX20826/0811%20826/0811%g
s%XXX20826/0812%20826/0812%g
s%XXX20826/0901%20826/0901%g
s%XXX20826/0902%20826/0902%g
s%XXX20826/0911%20826/0911%g
s%XXX20826/0912%20826/0912%g
s%XXX20826/1001%20826/1001%g
s%XXX20826/1002%20826/1002%g
s%XXX20826/1011%20826/1011%g
s%XXX20826/1012%20826/1012%g
s%XXX20826/1101%20826/1101%g
s%XXX20826/1102%20826/1102%g
s%XXX20826/1111%20826/1111%g
s%XXX20826/1112%20826/1112%g
s%XXX20826/3010%20826/2107%g
s%XXX20826/3011%20826/2108%g
s%XXX20826/3012%20826/2109%g
s%XXX20826/3013%20826/2110%g
s%XXX20826/3017%20826/2111%g
s%XXX20826/3018%20826/2112%g
s%XXX20826/3025%20826/2113%g
s%XXX20826/3020%20826/2114%g
s%XXX20826/3030%20826/2115%g
s%XXX20826/3035%20826/2116%g
s%XXX20826/3036%20826/2117%g
s%XXX20826/3037%20826/2118%g
s%XXX20826/3040%20826/2119%g
s%XXX20826/3041%20826/2120%g
s%XXX20000/0000%20826/2121%g
s%XXX20826/3042%20826/2122%g
s%XXX20826/3045%20826/2123%g
s%XXX20826/3046%20826/2124%g
s%XXX20826/0007%20826/2125%g
s%XXX20826/0008%20826/2126%g
s%XXX20826/0009%20826/2127%g
s%XXX20826/0010%20826/2128%g
s%XXX20826/0011%20826/2129%g
s%XXX20826/0012%20826/2130%g
s%XXX20826/0013%20826/2131%g
s%XXX20000/0000%20826/2132%g
s%XXX20827/0101%20827/0101%g
s%XXX20827/0102%20827/0102%g
s%XXX20827/0111%20827/0111%g
s%XXX20827/0112%20827/0112%g
s%XXX20827/0113%20827/0113%g
s%XXX20827/0201%20827/0201%g
s%XXX20827/0202%20827/0202%g
s%XXX20827/0211%20827/0211%g
s%XXX20827/0212%20827/0212%g
s%XXX20827/0301%20827/0301%g
s%XXX20827/0302%20827/0302%g
s%XXX20827/0311%20827/0311%g
s%XXX20827/0312%20827/0312%g
s%XXX20827/0401%20827/0401%g
s%XXX20827/0402%20827/0402%g
s%XXX20827/0411%20827/0411%g
s%XXX20827/0412%20827/0412%g
s%XXX20827/0501%20827/0501%g
s%XXX20827/0502%20827/0502%g
s%XXX20827/0511%20827/0511%g
s%XXX20827/0512%20827/0512%g
s%XXX20827/0601%20827/0601%g
s%XXX20827/0602%20827/0602%g
s%XXX20827/0611%20827/0611%g
s%XXX20827/0612%20827/0612%g
s%XXX20827/0701%20827/0701%g
s%XXX20827/0702%20827/0702%g
s%XXX20827/0711%20827/0711%g
s%XXX20827/0712%20827/0712%g
s%XXX20827/0801%20827/0801%g
s%XXX20827/0802%20827/0802%g
s%XXX20827/0811%20827/0811%g
s%XXX20827/0812%20827/0812%g
s%XXX20827/0901%20827/0901%g
s%XXX20827/0902%20827/0902%g
s%XXX20827/0911%20827/0911%g
s%XXX20827/0912%20827/0912%g
s%XXX20827/1001%20827/1001%g
s%XXX20827/1002%20827/1002%g
s%XXX20827/1011%20827/1011%g
s%XXX20827/1012%20827/1012%g
s%XXX20827/1101%20827/1101%g
s%XXX20827/1102%20827/1102%g
s%XXX20827/1111%20827/1111%g
s%XXX20827/1112%20827/1112%g
s%XXX20827/3010%20827/2007%g
s%XXX20827/3011%20827/2008%g
s%XXX20827/3012%20827/2009%g
s%XXX20827/3013%20827/2010%g
s%XXX20827/3018%20827/2011%g
s%XXX20827/3020%20827/2012%g
s%XXX20827/3030%20827/2013%g
s%XXX20827/3035%20827/2014%g
s%XXX20827/3036%20827/2015%g
s%XXX20827/3037%20827/2016%g
s%XXX20000/0000%20827/2017%g
s%XXX20827/3038%20827/2018%g
s%XXX20827/3040%20827/2019%g
s%XXX20827/3042%20827/2020%g
s%XXX20827/0008%20827/2021%g
s%XXX20827/0009%20827/2022%g
s%XXX20827/0010%20827/2023%g
s%XXX20827/0011%20827/2024%g
s%XXX20827/0012%20827/2025%g
s%XXX20827/0013%20827/2026%g
s%XXX20827/0014%20827/2027%g
s%XXX20000/0000%20827/2028%g
s%XXX20828/0101%20828/0101%g
s%XXX20828/0102%20828/0102%g
s%XXX20828/0111%20828/0111%g
s%XXX20828/0112%20828/0112%g
s%XXX20828/0201%20828/0201%g
s%XXX20828/0202%20828/0202%g
s%XXX20828/0211%20828/0211%g
s%XXX20828/0212%20828/0212%g
s%XXX20828/0301%20828/0301%g
s%XXX20828/0302%20828/0302%g
s%XXX20828/0311%20828/0311%g
s%XXX20828/0312%20828/0312%g
s%XXX20828/0401%20828/0401%g
s%XXX20828/0402%20828/0402%g
s%XXX20828/0411%20828/0411%g
s%XXX20828/0412%20828/0412%g
s%XXX20828/0501%20828/0501%g
s%XXX20828/0502%20828/0502%g
s%XXX20828/0511%20828/0511%g
s%XXX20828/0512%20828/0512%g
s%XXX20828/0601%20828/0601%g
s%XXX20828/0602%20828/0602%g
s%XXX20828/0611%20828/0611%g
s%XXX20828/0612%20828/0612%g
s%XXX20828/0701%20828/0701%g
s%XXX20828/0702%20828/0702%g
s%XXX20828/0711%20828/0711%g
s%XXX20828/0712%20828/0712%g
s%XXX20828/0801%20828/0801%g
s%XXX20828/0802%20828/0802%g
s%XXX20828/0811%20828/0811%g
s%XXX20828/0812%20828/0812%g
s%XXX20828/0901%20828/0901%g
s%XXX20828/0902%20828/0902%g
s%XXX20828/0911%20828/0911%g
s%XXX20828/0912%20828/0912%g
s%XXX20828/1001%20828/1001%g
s%XXX20828/1002%20828/1002%g
s%XXX20828/1011%20828/1011%g
s%XXX20828/1012%20828/1012%g
s%XXX20828/1101%20828/1101%g
s%XXX20828/1102%20828/1102%g
s%XXX20828/1111%20828/1111%g
s%XXX20828/1112%20828/1112%g
s%XXX20828/3010%20828/2107%g
s%XXX20828/3011%20828/2108%g
s%XXX20828/3012%20828/2109%g
s%XXX20828/3013%20828/2110%g
s%XXX20828/3017%20828/2111%g
s%XXX20828/3018%20828/2112%g
s%XXX20828/3025%20828/2113%g
s%XXX20828/3020%20828/2114%g
s%XXX20828/3030%20828/2115%g
s%XXX20828/3035%20828/2116%g
s%XXX20828/3036%20828/2117%g
s%XXX20828/3037%20828/2118%g
s%XXX20828/3040%20828/2119%g
s%XXX20828/3042%20828/2120%g
s%XXX20828/0007%20828/2121%g
s%XXX20828/0008%20828/2122%g
s%XXX20828/0009%20828/2123%g
s%XXX20828/0011%20828/2124%g
s%XXX20828/0012%20828/2125%g
s%XXX20828/0013%20828/2126%g
s%XXX20828/0014%20828/2127%g
s%XXX20000/0000%20828/2128%g
s%XXX20829/0102%20829/0102%g
s%XXX20829/0202%20829/0202%g
s%XXX20829/0302%20829/0302%g
s%XXX20829/0402%20829/0402%g
s%XXX20829/0502%20829/0502%g
s%XXX20829/0602%20829/0602%g
s%XXX20829/0702%20829/0702%g
s%XXX20829/0802%20829/0802%g
s%XXX20829/0902%20829/0902%g
s%XXX20829/1002%20829/1002%g
s%XXX20829/1102%20829/1102%g
s%XXX20829/3010%20829/2007%g
s%XXX20829/3011%20829/2008%g
s%XXX20829/3012%20829/2009%g
s%XXX20829/3013%20829/2010%g
s%XXX20829/3018%20829/2011%g
s%XXX20829/3020%20829/2012%g
s%XXX20829/3030%20829/2013%g
s%XXX20829/3035%20829/2014%g
s%XXX20829/3036%20829/2015%g
s%XXX20829/3037%20829/2016%g
s%XXX20829/3040%20829/2017%g
s%XXX20829/3042%20829/2018%g
s%XXX20829/3705%20829/2019%g
s%XXX20829/3706%20829/2020%g
s%XXX20829/3707%20829/2021%g
s%XXX20829/3708%20829/2022%g
s%XXX20829/3709%20829/2023%g
s%XXX20829/3710%20829/2024%g
s%XXX20829/3712%20829/2025%g
s%XXX20829/3713%20829/2026%g
s%XXX20829/3714%20829/2027%g
s%XXX20829/3715%20829/2028%g
s%XXX20829/3716%20829/2029%g
s%XXX20829/3717%20829/2030%g
s%XXX20000/0000%20829/2031%g
s%XXX20830/0112%20830/0112%g
s%XXX20830/0212%20830/0212%g
s%XXX20830/0312%20830/0312%g
s%XXX20830/0412%20830/0412%g
s%XXX20830/0512%20830/0512%g
s%XXX20830/0612%20830/0612%g
s%XXX20830/0712%20830/0712%g
s%XXX20830/0812%20830/0812%g
s%XXX20830/0912%20830/0912%g
s%XXX20830/1012%20830/1012%g
s%XXX20830/1112%20830/1112%g
s%XXX20830/0050%20830/2901%g
s%XXX20830/0051%20830/2902%g
s%XXX20830/0052%20830/2903%g
s%XXX20830/0053%20830/2904%g
s%XXX20830/0026%20830/2905%g
s%XXX20830/0027%20830/2906%g
s%XXX20830/0029%20830/2907%g
s%XXX20000/0000%20830/2908%g
s%XXX20831/0001%20833/0001%g
s%XXX20831/0002%20833/0002%g
s%XXX20831/0003%20833/0003%g
s%XXX20831/0005%20833/0004%g
s%XXX20000/0000%20833/0005%g
s%XXX20831/0010%20833/0006%g
s%XXX20831/0012%20833/0007%g
s%XXX20831/0015%20833/0008%g
s%XXX20831/0016%20833/0009%g
s%XXX20831/0017%20833/0010%g
s%XXX20831/0101%20833/0011%g
s%XXX20831/0105%20833/0012%g
s%XXX20831/0106%20833/0013%g
s%XXX20831/0107%20833/0014%g
s%XXX20831/0110%20833/0015%g
s%XXX20831/0120%20833/0016%g
s%XXX20831/0115%20833/0017%g
s%XXX20831/0225%20833/0018%g
s%XXX20831/0125%20833/0019%g
s%XXX20831/0130%20833/0020%g
s%XXX20831/0230%20833/0021%g
s%XXX20920/0001%20920/0001%g
s%XXX20920/0002%20920/0002%g
s%XXX20920/0003%20920/0003%g
s%XXX20920/0004%20920/0004%g
s%XXX20920/0005%20920/0005%g
s%XXX21401/0010%21401/2107%g
s%XXX21401/0015%21401/2108%g
s%XXX21401/0016%21401/2109%g
s%XXX21401/0020%21401/2110%g
s%XXX21401/0021%21401/2111%g
s%XXX21401/0022%21401/2112%g
s%XXX20000/0000%21401/2113%g
s%XXX21401/0023%21401/2114%g
s%XXX21401/0024%21401/2115%g
s%XXX21401/0030%21401/2116%g
s%XXX21401/0031%21401/2117%g
s%XXX21401/0032%21401/2118%g
s%XXX21401/0035%21401/2119%g
s%XXX20000/0000%21401/2120%g
s%XXX21401/0040%21401/2121%g
s%XXX21401/0041%21401/2122%g
s%XXX21401/0042%21401/2123%g
s%XXX21401/0043%21401/2124%g
s%XXX21401/0050%21401/2125%g
s%XXX21401/0045%21401/2126%g
s%XXX21401/0155%21401/2127%g
s%XXX21401/0055%21401/2128%g
s%XXX21401/0060%21401/2129%g
s%XXX21401/0061%21401/2130%g
s%XXX21401/0160%21401/2131%g
s%XXX21401/0161%21401/2132%g
s%XXX21402/0010%21402/2007%g
s%XXX21402/0015%21402/2008%g
s%XXX21402/0016%21402/2009%g
s%XXX21402/0017%21402/2010%g
s%XXX21402/0020%21402/2011%g
s%XXX21402/0022%21402/2012%g
s%XXX20000/0000%21402/2013%g
s%XXX21402/0023%21402/2014%g
s%XXX21402/0024%21402/2015%g
s%XXX21402/0025%21402/2016%g
s%XXX21402/0030%21402/2017%g
s%XXX21402/0032%21402/2018%g
s%XXX21402/0035%21402/2019%g
s%XXX20000/0000%21402/2020%g
s%XXX21402/0040%21402/2021%g
s%XXX21402/0041%21402/2022%g
s%XXX21402/0042%21402/2023%g
s%XXX21402/0043%21402/2024%g
s%XXX21402/0050%21402/2025%g
s%XXX21402/0045%21402/2026%g
s%XXX21402/0155%21402/2027%g
s%XXX21402/0055%21402/2028%g
s%XXX21402/0060%21402/2029%g
s%XXX21402/0061%21402/2030%g
s%XXX21402/0160%21402/2031%g
s%XXX21402/0161%21402/2032%g
s%XXX21403/0035%21403/0001%g
s%XXX21403/0040%21403/0002%g
s%XXX21403/0045%21403/0003%g
s%XXX21403/0046%21403/0004%g
s%XXX21403/0047%21403/0005%g
s%XXX20000/0000%21403/0006%g
s%XXX21403/0048%21403/0007%g
s%XXX21403/0050%21403/0008%g
s%XXX21403/0051%21403/0009%g
s%XXX21403/0052%21403/0010%g
s%XXX21403/0055%21403/0011%g
s%XXX20000/0000%21403/0012%g
s%XXX21403/0056%21403/0013%g
s%XXX21403/0057%21403/0014%g
s%XXX21403/0058%21403/0015%g
s%XXX21403/0059%21403/0016%g
s%XXX21403/0065%21403/0017%g
s%XXX21403/0060%21403/0018%g
s%XXX21403/0170%21403/0019%g
s%XXX21403/0070%21403/0020%g
s%XXX21403/0075%21403/0021%g
s%XXX21403/0076%21403/0022%g
s%XXX21403/0175%21403/0023%g
s%XXX21403/0176%21403/0024%g
s%XXX21403/0110%21403/2007%g
s%XXX21403/0115%21403/2008%g
s%XXX21403/0116%21403/2009%g
s%XXX21403/0120%21403/2010%g
s%XXX21403/0121%21403/2011%g
s%XXX21403/0130%21403/2012%g
s%XXX21403/0010%21403/2107%g
s%XXX21403/0015%21403/2108%g
s%XXX21403/0016%21403/2109%g
s%XXX21403/0020%21403/2110%g
s%XXX20000/0000%21403/2111%g
s%XXX21403/0030%21403/2112%g
s%XXX21405/0010%21405/2007%g
s%XXX21405/0015%21405/2008%g
s%XXX21405/0017%21405/2009%g
s%XXX20000/0000%21405/2010%g
s%XXX21405/0018%21405/2011%g
s%XXX21405/0019%21405/2012%g
s%XXX21405/0020%21405/2013%g
s%XXX21405/0021%21405/2014%g
s%XXX21405/0025%21405/2015%g
s%XXX21405/0026%21405/2016%g
s%XXX21405/0027%21405/2017%g
s%XXX21405/0030%21405/2018%g
s%XXX20000/0000%21405/2019%g
s%XXX21405/0035%21405/2020%g
s%XXX21405/0036%21405/2021%g
s%XXX21405/0037%21405/2022%g
s%XXX21405/0038%21405/2023%g
s%XXX21405/0045%21405/2024%g
s%XXX21405/0040%21405/2025%g
s%XXX21405/0150%21405/2026%g
s%XXX21405/0050%21405/2027%g
s%XXX21405/0055%21405/2028%g
s%XXX21405/0056%21405/2029%g
s%XXX21405/0155%21405/2030%g
s%XXX21405/0156%21405/2031%g
s%XXX21406/0010%21406/2107%g
s%XXX21406/0015%21406/2108%g
s%XXX21406/0016%21406/2109%g
s%XXX21406/0017%21406/2110%g
s%XXX20000/0000%21406/2111%g
s%XXX21406/0018%21406/2112%g
s%XXX21406/0019%21406/2113%g
s%XXX21406/0020%21406/2114%g
s%XXX21406/0021%21406/2115%g
s%XXX21406/0025%21406/2116%g
s%XXX21406/0027%21406/2117%g
s%XXX21406/0030%21406/2118%g
s%XXX20000/0000%21406/2119%g
s%XXX21406/0035%21406/2120%g
s%XXX21406/0036%21406/2121%g
s%XXX21406/0037%21406/2122%g
s%XXX21406/0038%21406/2123%g
s%XXX21406/0045%21406/2124%g
s%XXX21406/0040%21406/2125%g
s%XXX21406/0150%21406/2126%g
s%XXX21406/0050%21406/2127%g
s%XXX21406/0055%21406/2128%g
s%XXX21406/0056%21406/2129%g
s%XXX21406/0155%21406/2130%g
s%XXX21406/0156%21406/2131%g
s%XXX21407/0015%21407/0001%g
s%XXX21407/0010%21407/0002%g
s%XXX21407/0025%21407/0003%g
s%XXX21407/0026%21407/0004%g
s%XXX21407/0030%21407/0005%g
s%XXX21407/0031%21407/0006%g
s%XXX21407/0034%21407/0007%g
s%XXX21407/0035%21407/0008%g
s%XXX20000/0000%21407/0009%g
s%XXX21407/0040%21407/0010%g
s%XXX21407/0041%21407/0011%g
s%XXX21407/0042%21407/0012%g
s%XXX21407/0043%21407/0013%g
s%XXX21407/0050%21407/0014%g
s%XXX21407/0045%21407/0015%g
s%XXX21407/0155%21407/0016%g
s%XXX21407/0055%21407/0017%g
s%XXX21407/0060%21407/0018%g
s%XXX21407/0061%21407/0019%g
s%XXX21407/0160%21407/0020%g
s%XXX21407/0161%21407/0021%g
s%XXX21407/0003%21407/2901%g
s%XXX21407/0005%21407/2902%g
s%XXX21407/0006%21407/2903%g
s%XXX21407/0020%21407/2904%g
s%XXX21407/0105%21407/3301%g
s%XXX21407/0106%21407/3302%g
s%XXX21407/0120%21407/3303%g
s%XXX21408/0020%21408/0001%g
s%XXX21408/0025%21408/0002%g
s%XXX21408/0030%21408/0003%g
s%XXX21408/0031%21408/0004%g
s%XXX21408/0033%21408/0005%g
s%XXX21408/0034%21408/0006%g
s%XXX21408/0035%21408/0007%g
s%XXX20000/0000%21408/0008%g
s%XXX21408/0040%21408/0009%g
s%XXX21408/0041%21408/0010%g
s%XXX21408/0042%21408/0011%g
s%XXX21408/0043%21408/0012%g
s%XXX21408/0050%21408/0013%g
s%XXX21408/0045%21408/0014%g
s%XXX21408/0155%21408/0015%g
s%XXX21408/0055%21408/0016%g
s%XXX21408/0060%21408/0017%g
s%XXX21408/0061%21408/0018%g
s%XXX21408/0160%21408/0019%g
s%XXX21408/0161%21408/0020%g
s%XXX21408/0005%21408/3001%g
s%XXX21408/0006%21408/3002%g
s%XXX21408/0010%21408/3003%g
s%XXX21408/0011%21408/3004%g
s%XXX21408/0012%21408/3005%g
s%XXX21408/0015%21408/3006%g
s%XXX21408/0231%21408/3301%g
s%XXX21408/0235%21408/3302%g
s%XXX21408/0236%21408/3303%g
s%XXX21408/0240%21408/3304%g
s%XXX21408/0245%21408/3305%g
s%XXX21408/0250%21408/3306%g
s%XXX20520/0502%2---%g
s%XXX20520/0504%2---%g
s%XXX20743/0010%2---%g
s%XXX21404/0015%2---%g
s%XXX21404/0020%2---%g
s%XXX21404/0050%2---%g
s%XXX20520/0501%2---%g
s%XXX20520/0503%2---%g
s%XXX20520/0505%2---%g
s%XXX20520/0506%2---%g
s%XXX20520/0507%2---%g
s%XXX20520/0508%2---%g
s%XXX20520/0509%2---%g
s%XXX20520/5001%2---%g
s%XXX20520/5003%2---%g
s%XXX20520/5004%2---%g
s%XXX20520/5005%2---%g
s%XXX20741/0011%2---%g
s%XXX20743/0011%2---%g
s%XXX20743/0012%2---%g
s%XXX21403/0021%2---%g
s%XXX21403/0022%2---%g
s%XXX21403/0023%2---%g
s%XXX21403/0024%2---%g
s%XXX21404/0010%2---%g
s%XXX21404/0016%2---%g
s%XXX21404/0021%2---%g
s%XXX21404/0022%2---%g
s%XXX21404/0024%2---%g
s%XXX21404/0052%2---%g
s%XXX21404/0055%2---%g
s%XXX21404/0056%2---%g
s%XXX21404/0057%2---%g
s%XXX21404/0058%2---%g
s%XXX21404/0059%2---%g
s%XXX21404/0060%2---%g
s%XXX21404/0070%2---%g
s%XXX21404/0075%2---%g
s%XXX21404/0076%2---%g
s%XXX21404/0170%2---%g
s%XXX21404/0175%2---%g
s%XXX21404/0176%2---%g
s%XXX21404/0065%2---%g
s%XXX20520/5002%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
s%XXX20000/0000%2---%g
