#!/usr/bin/bash

# ===========================================================================
#
#             T-Systems GEI mbH  -  Geschaeftsstelle Aachen
#
# ===========================================================================
# Computer............:     IBM PC
# Operating-System....:     Windows 2000
# Compiler............:     cygwin bash interpreter
# ===========================================================================

# $RCSfile: create_tm_package.sh,v $
# $Revision: 1.11 $
# $Date: 2002/10/29 15:43:31 $
# $Author: jan $
#

rc=0

if [ $# -le 0 ]; then
	echo usage: $( basename $0 ) \<major.minor as x.yy\> \<path\>
	echo path is where run is, for ex: /cygdrive/e/daten/AMS-TM
	rc=1
else
  
  # return codes
  #  rc = 0 : success
  #  rc = 1 : too few parameters given
  #  rc = 2 : revision syntax error
  #  rc = 3 : copy encountered a problem
    
  revision=$1
  releasetype=Debug #Release

  tm_release=$(echo ${TM_RELEASE} | sed -e 's/\\/\//g' -e 's/^./\/cygdrive\/&/g' -e 's/://g' )
  tm_home=$(   echo ${TM_HOME}    | sed -e 's/\\/\//g' -e 's/^./\/cygdrive\/&/g' -e 's/://g' )

  pkgdir=$tm_release 
  pkgbin=${pkgdir}/run/bin

  test -d ${pkgdir} || mkdir ${pkgdir}
  
  echo $revision | egrep -q "^[0-9]\.[0-9][0-9]$" || rc=2
  
  if [ $rc -eq 0 ]; then
 
#
# enter "source" directory
# 
    if [ "$2" != "" ]; then
      pushd $2
    else
      pushd $tm_home # on a development machine, this should also contain run/
    fi

    test -d run/bin || echo ERROR: cannot find bin directory
    test -d run/bin || exit
    
#
# prepare package destination directories
#
    dat=$( date +%Y%m%d_%H%M )

    echo removing   backup: _run
    rm -rf ${pkgdir}/_run

    echo making new backup: run moved to _run
    mkdir ${pkgdir}/_run
    mv -f ${pkgdir}/run/bin ${pkgdir}/run/etc ${pkgdir}/run/cfg  ${pkgdir}/_run/

    echo making directories ${pkgdir}/run/\{bin,log\}
    test -d ${pkgdir}/run     || mkdir ${pkgdir}/run
    test -d ${pkgdir}/run/log || mkdir ${pkgdir}/run/log
    test -d ${pkgdir}/run/bin || mkdir ${pkgdir}/run/bin

#
# collect TM files
#
    echo copying scripts and configuration
    cp -a run/etc/ run/cfg ${pkgdir}/run/

    sys=/cygdrive/c/WINNT/system32

    echo copying system DLLs
    cp ${sys}/MSVCP60*.DLL ${pkgbin}/
    cp ${sys}/MSVCRTD.DLL  ${pkgbin}/
    cp ${sys}/MSVCIRTD.DLL  ${pkgbin}/
    cp ${sys}/tls*.dll  ${pkgbin}/
    cp ${sys}/dbt*.dll  ${pkgbin}/

    echo copying TM binaries
    cp run/bin/${releasetype}/*  ${pkgbin}/
    cp run/bin/logging.dll       ${pkgbin}/
    cp run/bin/xerces*.dll       ${pkgbin}/

    echo copying TC simulation binaries and MFC DLLs
    cp simulation/tc_simulation/Debug/tc_simulation.exe ${pkgbin}/
    cp ${sys}/MFC*.DLL ${pkgbin}/
    
    echo making file list
    pushd ${pkgdir}
    #find . -name "CVS" -exec rm -rf {} \;

    zipname=TM-${revision}-${dat}.zip
    zipexe=TM-${revision}-${dat}.exe

		cat <${tm_home}/run/etc/tm_installer.bat | \
			sed -e s/REM\ REPLACEME/${zipexe}\ -d\ \%TM_HOME\%/g >install.bat
    
    filelist=$( find run | egrep -v "Release|Debug|CVS|run\/log|\.ilk|\.bak|\.\#" )

#
# ZIP it and compute md5sum
#
    echo making ZIP archive
    rm -f ${zipname}
    zip -1 -v ${zipname} ${filelist}

    echo 
    echo -n "checking zip file integrity ... "
    zip -T ${zipname} || exit

    echo 
    echo -n "creating self extracting zip ..."

		cat run/etc/unzipsfx.exe ${zipname} >${zipexe}
	  zip -A ${zipexe}	
	  chmod a+x ${zipexe}

    echo zips are located in `pwd`

    md5sum ${zipexe} >${zipexe}.md5sum
    echo md5sum of exe is $( cat < ${zipexe}.md5sum | cut -f 1 -d \  )
		echo
    md5sum ${zipname} >${zipname}.md5sum
    echo md5sum of zip is $( cat < ${zipname}.md5sum | cut -f 1 -d \  )
    echo
    
    popd
    popd
    
  fi

fi

if [ $rc -eq 2 ]; then
  echo revision syntax error: ${revision}
fi

exit $rc
