#!/usr/bin/bash

# ===========================================================================
#
#             T-Systems GEI mbH  -  Geschaeftsstelle Aachen
#
# ===========================================================================
# Computer............:     IBM PC
# Operating-System....:     Windows 2000
# Compiler............:     cygwin bash interpreter
# ===========================================================================

# $RCSfile: mod_ip_address.sh,v $
# $Revision: 1.2 $
# $Date: 2002/10/07 15:58:02 $
# $Author: jan $
#


rc=0

if [ $# -le 2 ]; then 
	echo usage: $( basename $0 ) \[add\|del\] \<tmname\> \<tmhost\>
	rc=1
else
  
  # return codes
  #  rc = 0 : success in either adding or removing an IP address
  #  rc = 1 : too few parameters given
  #  rc = 2 : IP address already set	, before add
  #  rc = 3 : IP address could not be set, after add
  #  rc = 4 : IP address was not set	, before delete
  #  rc = 5 : IP address still   set	, after delete
  
  mod=$1
  tmname=$2
  tmhost=$3

	tmip=$( get_ip.sh ${tmname}_host  )
	

  if [ "$mod" == "add" ]; then 
  	ping ${tmip} | grep -q "timed out" || rc=2
  
    if [ $rc -eq 0 ]; then
  	  echo adding IP ${tmip} to host ${tmhost} to run ${tmname}
  	  netsh.exe -c "interface ip" -r \\\\${tmhost} add address "Local Area Connection" ${tmip} 255.255.255.0
  	  ping ${tmip} | grep -q "timed out" && rc=3
  	fi
  	
  fi
  
  
  if [ "$mod" == "del" ]; then 
  	ping ${tmip} | grep -q "timed out" && rc=4
  	
    if [ $rc -eq 0 ]; then
      tmhost=${tmname} 
    	echo deleting  IP ${tmip} from host ${tmhost} 
  	  netsh.exe -c "interface ip" -r \\\\${tmhost} del address "Local Area Connection" ${tmip} 
    	ping ${tmip} | grep -q "timed out" || rc=5
    fi
  fi
  
fi 

if [ $rc -eq 0 ]; then
	echo success
	exit 0
else
	echo error: return code $rc
	exit $rc
fi


