#!/usr/bin/bash

# ===========================================================================
#
#             T-Systems GEI mbH  -  Geschaeftsstelle Aachen
#
# ===========================================================================
# Computer............:     IBM PC
# Operating-System....:     Windows 2000
# Compiler............:     cygwin bash interpreter
# ===========================================================================

# $RCSfile: sync_with_tm.sh,v $
# $Revision: 1.3 $
# $Date: 2002/10/07 15:58:02 $
# $Author: jan $
#


rc=0

if [ $# -le 2 ]; then
	echo usage: $( basename $0 ) \<tmname\> \[push\|pull\] \[system\|config\|all\]
	rc=1
else
  
  # return codes
  #  rc = 0 : success
  #  rc = 1 : too few parameters given
  #  rc = 2 : unsupported option 
  #  rc = 3 : unsupported mode push or pull
  #  rc = 4 : copy encountered a problem
    
  tmname=$1
  tmhost=${tmname}_host
	tmip=$( get_ip.sh ${tmhost} )

  mode=$2
  selection=$3
  tmhome=$(echo ${TM_HOME} | sed -e 's/\\/\//g' -e 's/^./\/cygdrive\/&/g' -e 's/://g' )

  rc=4
  if [ $mode == push ]; then  
    sourceprefix=${tmhome}
    targetprefix=//${tmip}/d$
    rc=0
  fi
  if [ $mode == pull ]; then  
    targetprefix=/cygdrive/e/TM_HOME
    sourceprefix=${tmhome}
    rc=0
  fi
  
  rc=2
  
  if [ $selection == system ]; then
    workingcopy=${sourceprefix}/run/cfg/tm_system_parameter-${tmname}.txt
    rc=0
    test -f ${workingcopy} || rc=3
  fi
   
  if [ $selection == config ] && [ $mode == push ]; then
    workingcopy=${sourceprefix}/run/cfg/tm_config_parameter.txt
    rc=0
    test -f ${workingcopy} || rc=3
  fi
   
  if [ $selection == all    ] && [ $mode == push ]; then
    workingcopy=${sourceprefix}/run
    rc=0
    echo ${workingcopy}
    test -d ${workingcopy} || rc=3
  fi
 
  if [ ${rc} -eq 0 ]; then
    cp -av ${workingcopy} ${targetprefix}/   || rc=4
  fi
  
fi

echo sync_with_tm.sh: return code: ${rc}

exit $rc
