#!/usr/bin/bash

# ===========================================================================
#
#             T-Systems GEI mbH  -  Geschaeftsstelle Aachen
#
# ===========================================================================
# Computer............:     IBM PC
# Operating-System....:     Windows 2000
# Compiler............:     cygwin bash interpreter
# ===========================================================================

# $RCSfile: control_tm.sh,v $
# $Revision: 1.2 $
# $Date: 2002/10/07 15:58:03 $
# $Author: jan $
#


rc=0

if [ $# -le 1 ]; then 
	echo usage: $( basename $0 )  \<tmname\> \[start\|stop\|reboot\]
	echo all:$@ num:$# each:$0 $1 $2 
	rc=1
else
    
  tmname=$1
  tmhost=${tmname}
	tmservice=TransportManager$( echo $tmname | sed -e 's/TM//g' )
	tmip=$( get_ip.sh ${tmname}_host )
  mode=$2
  
  rc=2

	echo about to $mode service $tmservice on host $tmip
  
  if [ $mode == start ]; then
    rc=0;
    sc \\\\${tmip} start ${tmservice}
		sleep 2
    sc \\\\${tmip} query ${tmservice} | grep -q "RUNNING" || rc=1
  fi

  if [ $mode == stop ]; then
    rc=0;
    sc \\\\${tmip} stop  ${tmservice}
	  sleep 2
    sc \\\\${tmip} query ${tmservice} | grep -q "STOPPED" || rc=1
  fi

  if [ $mode == reboot ]; then
    shutdown \\\\${tmip} /R /T:5 /Y /C
    rc=0;
  fi
  
fi

echo return code $rc >/dev/stderr

exit $rc
