#!/usr/bin/bash

# ===========================================================================
#
#             T-Systems GEI mbH  -  Geschaeftsstelle Aachen
#
# ===========================================================================
# Computer............:     IBM PC
# Operating-System....:     Windows 2000
# Compiler............:     cygwin bash interpreter
# ===========================================================================

# $RCSfile: create_admin_folders.sh,v $
# $Revision: 1.4 $
# $Date: 2002/10/07 15:58:03 $
# $Author: jan $
#


basepath=$(echo ${USERPROFILE}/Desktop | \
  sed -e 's/\\/\//g' -e 's/C:/\/cygdrive\/c/g')

create_admin_folder()
{
  basepath=$1
  tmname=$2
	bashpath="D:\tools\cygwin\bin\bash --login"
  
  etcpath=$(echo ${TM_HOME}/run/etc | \
    sed -e 's/\\/\//g' -e 's/^./\/cygdrive\/&/g' -e 's/://g')
  
  cfgpath=$(echo ${TM_HOME}/run/cfg | \
    sed -e 's/\\/\//g' -e 's/^./\/cygdrive\/&/g' -e 's/://g')
  
  
  echo "  creating folder: " "${basepath}/${tmname}"
  rm -rf "${basepath}/${tmname}"
  mkdir  "${basepath}/${tmname}"
  
  
  echo "  creating shortcut for README.txt"
  mkshortcut.exe -A -n "${basepath}/${tmname}/${prefix}README.txt" \
                       "${etcpath}/README.txt"
  
  echo "  creating shortcut for tm_config_parameter-${tmname}.txt"
  mkshortcut.exe -A -n "${basepath}/${tmname}/${prefix}tm_config_parameter.txt" \
                        "${cfgpath}/tm_config_parameter-${tmname}.txt"
  
  echo "  creating shortcut for event viewer"
  mkshortcut.exe -A --arguments=":\Documents and Settings\Administrator\Start Menu\Programs\Administrative Tools\Console1.msc"    \
		    -n "${basepath}/event_viewer" \
                       "/cygdrive/c/WINNT/system32/eventvwr"
  
################################ start stop reboot

  for i in start stop reboot; do
  
    echo \@echo\ off=                            | tr '=' '\r'  > "${etcpath}/${i}_tm.bat"
    echo cmd\ \/K\ ${bashpath}\ control_tm.sh\ \%1 \%2= | tr '=' '\r' >> "${etcpath}/${i}_tm.bat"
    
    chmod 755 "${etcpath}/${i}_tm.bat"
    
    echo "  creating shortcut for control_tm.sh ${i}"
    mkshortcut.exe -A --arguments="${tmname} ${i}" \
                   -n "${basepath}/${tmname}/${i}_tm.lnk" \
                      "${etcpath}/${i}_tm.bat"
  done
  
################################ push pull

  for i in push pull; do
    for j in config system all; do
    
      if [ $i == push ] || ( [ $i == pull ] && [ $j == system ] ) ; then
      
        echo \@echo\ off=                                  | tr '=' '\r'  > "${etcpath}/${i}_${j}_tm.bat"
        echo cmd\ \/K\ ${bashpath}\ sync_with_tm.sh\ \%1 \%2 \%3= | tr '=' '\r' >> "${etcpath}/${i}_${j}_tm.bat"
        
        chmod 755 "${etcpath}/${i}_${j}_tm.bat"
        
        echo "  creating shortcut for sync_with_tm.sh ${i} ${j}"
        mkshortcut.exe -A --arguments="${tmname} ${i} ${j}" \
                       -n "${basepath}/${tmname}/${i}_${j}_tm.lnk" \
                          "${etcpath}/${i}_${j}_tm.bat"
      fi
    done
  done

################################ check in/out

  for i in checkin checkout; do
    for j in config system all; do
    
      echo \@echo\ off=                            | tr '=' '\r'  > "${etcpath}/${i}_${j}_tm.bat"
      echo cmd\ \/K\ ${bashpath}\ cvs_tm.sh\ \%1 \%2 \%3= | tr '=' '\r' >> "${etcpath}/${i}_${j}_tm.bat"
      
      chmod 755 "${etcpath}/${i}_${j}_tm.bat"
      
      echo "  creating shortcut for cvs_tm.sh ${i} ${j}"
      mkshortcut.exe -A --arguments="${tmname} ${i} ${j}" \
                     -n "${basepath}/${tmname}/${i}_${j}_tm.lnk" \
                        "${etcpath}/${i}_${j}_tm.bat"
    done
  done
}



################################ MAIN ###################################


if [ $# -eq 0 ]; then
  echo usage: $( basename $0 ) \<TM name\|\[all\]\> 
  exit 1
fi


if [ $# -eq 1 ]; then
  if [ $1 == all ]; then
    list=$( seq 31 45 | sed -e 's/^/TM/g' )
  else
    list=$1
  fi
fi


for i in $list; do
#for i in `seq --format "%02g" $first $last`; do
#  test -d "${basepath}/${i}" || mkdir "${basepath}/${i}"
  echo processing TM folder $i
  create_admin_folder "${basepath}" "${i}"
done

# setup baggage trace file deletion

echo setting up baggage trace file deletion schedule

at /DELETE /YES > nul
at 11:00:00 /EVERY:Monday,Tuesday,Wednesday,Thursday,Friday,Saturday,Sunday \%TM_HOME\%\\run\\etc\\delete_trace_files.sh all > nul

