#!/usr/bin/bash

# ===========================================================================
#
#             T-Systems GEI mbH  -  Geschaeftsstelle Aachen
#
# ===========================================================================
# Computer............:     IBM PC
# Operating-System....:     Windows 2000
# Compiler............:     cygwin bash interpreter
# ===========================================================================

# $RCSfile: cvs_tm.sh,v $
# $Revision: 1.3 $
# $Date: 2002/10/07 15:58:03 $
# $Author: jan $
#


rc=0

if [ $# -le 2 ]; then
	echo usage: $( basename $0 ) \<tmname\> \[checkin\|checkout\] \[system\|config\|all\]
	rc=1
else
  
  # return codes
  #  rc = 0 : success
  #  rc = 1 : too few parameters given
  #  rc = 2 : unsupported option
  #  rc = 3 : unsupported cvs mode
    
  logmessage="commit on $( date )"
    
  export PATH=$PATH:/cygdrive/c/Program\ Files/GNU/WinCVS\ 1.2  
  export CVSROOT=//acp1051/admin_repository
    
  tmname=$1
  tmhost=${tmname}_host
  inout=$2    #cvs mode
  selection=$3
  modulename=AdminPC_TM
  workpath=/cygdrive/e/VI-AMS-TM/src
    
  rc=2
  
  pushd ${workpath}
  
  if [ $selection == system ]; then
    workingcopy=${modulename}/run/cfg/tm_system_parameter-${tmname}.txt
    rc=0
    test -f ${workingcopy} || rc=3
  fi
   
  if [ $selection == config ]; then
    workingcopy=${modulename}/run/cfg/tm_config_parameter.txt
    rc=0
    test -f ${workingcopy} || rc=3
  fi
   
  if [ $selection == all    ]; then
    workingcopy=${modulename}/run
    rc=0
    test -d ${workingcopy} || rc=3
  fi
   
  if [ $rc -eq 0 ]; then
    rc=4
    if [ $inout == checkin ]; then
      echo checking in $( ls -R ${workingcopy} )
      cvs -t commit -m "${logmessage}" ${workingcopy}
      rc=0
    fi
    if [ $inout == checkout ]; then
      echo checking out $( ls -R ${workingcopy} )
      rm -f        ${workingcopy}
      cvs checkout ${workingcopy}
      rc=0
    fi
  fi
  
  popd
fi


if [ $rc -eq 2 ]; then
  echo unknown option: $selection
fi

if [ $rc -eq 3 ]; then
  echo file not found: ${workingcopy}
fi

if [ $rc -eq 4 ]; then
  echo unknown cvs mode: ${workingcopy}
fi

echo sync_with_tm.sh: return code: ${rc}

exit $rc

