#!/usr/bin/bash

# ===========================================================================
#
#             T-Systems GEI mbH  -  Geschaeftsstelle Aachen
#
# ===========================================================================
# Computer............:     IBM PC
# Operating-System....:     Windows 2000
# Compiler............:     cygwin bash interpreter
# ===========================================================================

# $RCSfile: delete_trace_files.sh,v $
# $Revision: 1.4 $
# $Date: 2002/10/08 15:26:07 $
# $Author: jan $
#

rc=0

if [ $# -le 0 ]; then 
	echo usage: $( basename $0 )  \<tmname\> 
	rc=1
else

  if [ "$1"  == "all" ] || [ "$1" == "ALL" ]; then
    tmlist=$( seq 31 45 | sed -e 's/^/TM/g' )
  else 
    tmlist=$1
  fi

	tm_home=$(echo ${TM_HOME} | sed -e 's/\\/\//g' -e 's/^./\/cygdrive\/&/g' -e 's/://g' )
	logfile=${tm_home}/trace_deletion.log
	mv -f ${logfile} ${logfile}.old	


	for tmname in $tmlist; do

	# currently hostname is TM??_host. may change in schiphol
		tmhost=${tmname}_host

	# unfortunately, we need to use IP addresses in the test lab
		tmip=$( get_ip.sh $tmhost )

		if [ ${tmip} != "UNKNOWN_HOST" ]; then

			echo  >> $logfile
			echo deleting tracefiles on $tmname >> $logfile

		# do we have a way to find out about the remote TM's TM_HOME value?
		# if not we use current machines TM_HOME as d:\
			
			tracedir=//${tmip}/d$/run/log/${tmname}

			echo searching files...
			echo $( find ${tracedir} -type f -mtime +2 ) | tr ' ' '\n' 
			echo $(date) >>$logfile 
			echo $( find ${tracedir} -type f -mtime +2 ) | tr ' ' '\n' >> ${logfile}
			echo you have 5 seconds to press CTRL-C to cancel the delete operation!
			sleep 5 && find ${tracedir} -type f -mtime +2 
		fi
	done
fi

exit $rc

