#!/usr/bin/bash

# ===========================================================================
#
#             T-Systems GEI mbH  -  Geschaeftsstelle Aachen
#
# ===========================================================================
# Computer............:     IBM PC
# Operating-System....:     Windows 2000
# Compiler............:     cygwin bash interpreter
# ===========================================================================

# $RCSfile: get_ip.sh,v $
# $Revision: 1.1 $
# $Date: 2002/10/07 15:58:02 $
# $Author: jan $
#

rc=0

if [ $# -le 0 ]; then
  echo usage: $( basename $0 ) \< hostname \> >/dev/stderr
  rc=1
else

	echo $1 | egrep -q "[0-9]+.[0-9]+.[0-9]+.[0-9]+" && rc=3

	if [ $rc -le 0 ];then

	#
	# find DNS server, then try to look up hostname
	# 
	# turned off, since ping is ok.
	#
#		dnsip=$( nslookup a1b2c3d4f5g6h7i8j9 | grep Address | tr -s ' ' | cut -f 2 -d \  )
#		tmip=$(  nslookup $1 | egrep -A 1 Name\: | grep Address | grep -v ${dnsip} | tr -s ' ' | cut -f 2 -d \  )	


	#
	# ping the address, if not found, try by pinging hostname
	# 
	#	ping ${tmip} | egrep -q "Options|Syntax|timed out" && rc=2
		rc=2

		if [ $rc -eq 2 ]; then
			#echo cannot find hostname by DNS >/dev/stderr
			tmip=$( ping -n 1 $1 | grep "\["  | cut -f 2 -d \[ | cut -f 1 -d \] )
			ping ${tmip} | egrep -q "Unknown host|timed out|berschreitung der" || rc=0
		fi
	else
		tmip=$1
		rc=0
	fi
fi

#
# last check, if everything has failed
#
if [ "$tmip" == "" ];then
	rc=1
fi

#
# provide return value
#
if [ $rc -le 0 ]; then
	echo $tmip
else
	echo cannot find hostname $1 by pinging it >/dev/stderr
	echo UNKNOWN_HOST
	exit 1
fi
