#!/usr/bin/bash

# ===========================================================================
#
#             T-Systems GEI mbH  -  Geschaeftsstelle Aachen
#
# ===========================================================================
# Computer............:     IBM PC
# Operating-System....:     Windows 2000
# Compiler............:     cygwin bash interpreter
# ===========================================================================

# $RCSfile: install_release.sh,v $
# $Revision: 1.4 $
# $Date: 2002/10/09 15:35:24 $
# $Author: jan $
#

rc=0

if [ $# -le 0 ]; then
        echo usage: $( basename $0 ) \<full path to release zip file\>
        rc=1
else

  release=$1
	localrl=$( basename $release )
  cvsmodulename=run
	
	echo checking local and remote existence of specified zip file
  test -f $localrl || test -f $release || rc=2

  if [ $rc -le 0 ]; then

		export CVSROOT=//127.0.0.1/TMRepository/
    cd /cygdrive/d/workingcopy

    test -f $localrl || echo copying $release to local directory
    test -f $localrl || cp $release $localrl

    test -f $localrl || rc=3
		
		if [ $rc -le 0 ]; then
			echo release is found on local directory

#
# make backup copies
#
			echo remove oldest backup
			rm -rf __run
		
			echo "move current _run to __run as backup"
			mv -f _run __run

			echo "copy current  run to  _run as backup"
			cp -a run _run

#
# unzip new release
#
			echo unzip new release overwriting old files
			echo A | unzip $release 2>&1> zip.log

			filelist=$( cat <zip.log | grep run | grep -v \/\ | cut -f 2 -d \: )

#
# add or commit new or changed files into CVS
#
# purpose is to detect when to add new files to the repository
# and to add or set them to binary if necessary.
#
			echo
			echo add or commit new or changed files into CVS

			for i in $filelist; do
				cvs status $i 2>&1 | cat >cvs.tmp
				result=$( grep Status cvs.tmp | cut -f 3 -d \: )
				grep -q "\-kb" cvs.tmp && binary=-kb || binary=

				if [ "$result" == " Unknown" ]; then
					echo "add $binary and commit $i"
					cvs add $binary $i 											2>&1 | cat >>cvs-err.log
					cvs commit -m "release ${localrl}" $i 	2>&1 | cat >>cvs-err.log
				else
					if [ "$binary" != "-kb" ]; then
						echo $i | egrep -iq "\.DLL$|\.EXE|\.gdl" && fl=1 || fl=0
						if [ $fl -eq 1 ]; then
							echo "set to binary  $i"
							cvs admin -kb $i  2>&1 | cat >>cvs-err.log
							cvs update -A $i  2>&1 | cat >>cvs-err.log
						fi
					fi
#
# ascii files that contain CVS keywords will always be committed
# since they always be different within the originating and this repository
#
				  if [ "$result" != " Up-to-date" ]; then
						echo "        commit $i"
						cvs commit -m "release ${localrl}" $i 2>&1 | cat >>cvs-err.log
					else
						    echo "did not commit $i"
					fi
				fi
			done

		
exit
			cp setx.exe run/etc/
			cd run/etc

#
# now push new release to TMs
#
			echo push new release to TM
			for i in `seq 31 45`; do

				echo -n "searching host TM$i ... "

				tmhost=TM${i}_host
				tmip=$( get_ip.sh $tmhost )

				ping ${tmip} | egrep -q "Unknown host|timed out" || \
					./sync_with_tm.sh TM${i} push all 
			done

		fi
  fi

fi

case $rc in
  2)
    echo could not find specified file: $release
  ;;
	3)
		echo error when copying file from remote to local directory
  ;;
esac
 

echo done.
